/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.refactoring.rename;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameProcessor;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class ResourceBundleRenameUtil {
    private static final Logger LOG = Logger.getInstance(ResourceBundleRenameUtil.class);

    public static void renameResourceBundleKey(@NotNull PsiElement psiElement, @NotNull Project project) {
        if (psiElement == null) {
            ResourceBundleRenameUtil.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ResourceBundleRenameUtil.$$$reportNull$$$0(1);
        }
        if (psiElement.isValid()) {
            PsiElementRenameHandler.invoke((PsiElement)psiElement, (Project)project, (PsiElement)psiElement.getContainingFile(), null);
        }
    }

    public static void renameResourceBundleBaseName(@NotNull ResourceBundle resourceBundle, @NotNull Project project) {
        if (resourceBundle == null) {
            ResourceBundleRenameUtil.$$$reportNull$$$0(2);
        }
        if (project == null) {
            ResourceBundleRenameUtil.$$$reportNull$$$0(3);
        }
        Messages.showInputDialog((Project)project, (String)PropertiesBundle.message((String)"rename.bundle.enter.new.resource.bundle.base.name.prompt.text", (Object[])new Object[0]), (String)PropertiesBundle.message((String)"rename.resource.bundle.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)resourceBundle.getBaseName(), (InputValidator)new ResourceBundleBaseNameInputValidator(project, resourceBundle));
    }

    public static void renameResourceBundleKeySection(List<? extends PsiElement> psiElements, String section, int sectionPosition) {
        if (psiElements.isEmpty()) {
            return;
        }
        Project project = psiElements.get(0).getProject();
        Messages.showInputDialog((Project)project, (String)PropertiesBundle.message((String)"rename.bundle.enter.new.resource.bundle.section.name.prompt.text", (Object[])new Object[0]), (String)PropertiesBundle.message((String)"rename.resource.bundle.section.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)section, (InputValidator)new ResourceBundleKeySectionInputValidator(psiElements, section, sectionPosition, project));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceBundle";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/properties/refactoring/rename/ResourceBundleRenameUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "renameResourceBundleKey";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "renameResourceBundleBaseName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ResourceBundleBaseNameInputValidator
    implements InputValidator {
        private final Project myProject;
        private final ResourceBundle myResourceBundle;

        ResourceBundleBaseNameInputValidator(Project project, ResourceBundle resourceBundle) {
            this.myProject = project;
            this.myResourceBundle = resourceBundle;
        }

        public boolean checkInput(String inputString) {
            return inputString.indexOf(File.separatorChar) < 0 && inputString.indexOf(47) < 0;
        }

        public boolean canClose(String inputString) {
            List propertiesFiles = this.myResourceBundle.getPropertiesFiles();
            for (PropertiesFile propertiesFile : propertiesFiles) {
                if (FileModificationService.getInstance().prepareFileForWrite(propertiesFile.getContainingFile())) continue;
                return false;
            }
            RenameProcessor renameProcessor = null;
            String baseName = this.myResourceBundle.getBaseName();
            for (PropertiesFile propertiesFile : propertiesFiles) {
                VirtualFile virtualFile = propertiesFile.getVirtualFile();
                if (virtualFile == null) continue;
                String newName = inputString + virtualFile.getNameWithoutExtension().substring(baseName.length()) + "." + virtualFile.getExtension();
                if (renameProcessor == null) {
                    renameProcessor = new RenameProcessor(this.myProject, (PsiElement)propertiesFile.getContainingFile(), newName, false, false);
                    continue;
                }
                renameProcessor.addElement((PsiElement)propertiesFile.getContainingFile(), newName);
            }
            if (renameProcessor == null) {
                LOG.assertTrue(false);
                return true;
            }
            renameProcessor.setCommandName(PropertiesBundle.message((String)"rename.resource.bundle.dialog.title", (Object[])new Object[0]));
            renameProcessor.doRun();
            return true;
        }
    }

    private static final class ResourceBundleKeySectionInputValidator
    implements InputValidator {
        private final List<? extends PsiElement> myPsiElements;
        private final String mySection;
        private final int mySectionPosition;
        private final Project myProject;

        private ResourceBundleKeySectionInputValidator(List<? extends PsiElement> psiElements, String section, int sectionPosition, Project project) {
            this.myPsiElements = psiElements;
            this.mySection = section;
            this.mySectionPosition = sectionPosition;
            this.myProject = project;
        }

        public boolean checkInput(String inputString) {
            return true;
        }

        public boolean canClose(String inputString) {
            RenameProcessor renameProcessor = null;
            for (PsiElement psiElement : this.myPsiElements) {
                assert (psiElement instanceof PsiNamedElement);
                String oldName = ((PsiNamedElement)psiElement).getName();
                assert (oldName != null);
                String newName = oldName.substring(0, this.mySectionPosition) + inputString + oldName.substring(this.mySectionPosition + this.mySection.length());
                if (renameProcessor == null) {
                    renameProcessor = new RenameProcessor(this.myProject, psiElement, newName, false, false);
                    continue;
                }
                renameProcessor.addElement(psiElement, newName);
            }
            assert (renameProcessor != null);
            renameProcessor.setCommandName(PropertiesBundle.message((String)"rename.resource.bundle.section.dialog.title", (Object[])new Object[0]));
            renameProcessor.doRun();
            return true;
        }
    }
}

