/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.AbstractBasicJavaSmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import com.intellij.psi.impl.source.BasicJavaElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CatchDeclarationFixer
implements Fixer {
    @Override
    public void apply(Editor editor, AbstractBasicJavaSmartEnterProcessor processor, @NotNull ASTNode astNode) throws IncorrectOperationException {
        if (astNode == null) {
            CatchDeclarationFixer.$$$reportNull$$$0(0);
        }
        if (BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_CATCH_SECTION)) {
            Document doc = editor.getDocument();
            int catchStart = astNode.getTextRange().getStartOffset();
            int stopOffset = doc.getLineEndOffset(doc.getLineNumber(catchStart));
            ASTNode catchBlock = BasicJavaAstTreeUtil.getCatchBlock(astNode);
            if (catchBlock != null) {
                stopOffset = Math.min(stopOffset, catchBlock.getTextRange().getStartOffset());
            }
            stopOffset = Math.min(stopOffset, astNode.getTextRange().getEndOffset());
            ASTNode lParenth = BasicJavaAstTreeUtil.getLParenth(astNode);
            if (lParenth == null) {
                doc.replaceString(catchStart, stopOffset, (CharSequence)"catch ()");
                processor.registerUnresolvedError(catchStart + "catch (".length());
            } else {
                if (BasicJavaAstTreeUtil.getParameter(astNode) == null) {
                    processor.registerUnresolvedError(lParenth.getTextRange().getEndOffset());
                }
                if (BasicJavaAstTreeUtil.getRParenth(astNode) == null) {
                    doc.insertString(stopOffset, (CharSequence)")");
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astNode", "com/intellij/codeInsight/editorActions/smartEnter/CatchDeclarationFixer", "apply"));
    }
}

