/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LabeledJavaBlock
extends AbstractJavaBlock {
    public LabeledJavaBlock(ASTNode node, Wrap wrap, Alignment alignment, Indent indent, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings, @NotNull FormattingMode formattingMode) {
        if (formattingMode == null) {
            LabeledJavaBlock.$$$reportNull$$$0(0);
        }
        super(node, wrap, alignment, indent, settings, javaSettings, formattingMode);
    }

    protected List<Block> buildChildren() {
        ArrayList<Block> result = new ArrayList<Block>();
        Indent currentIndent = this.getLabelIndent();
        Wrap currentWrap = null;
        for (ASTNode child = this.myNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (FormatterUtil.containsWhiteSpacesOnly((ASTNode)child) || child.getTextLength() <= 0) continue;
            result.add(this.createJavaBlock(child, this.mySettings, this.myJavaSettings, currentIndent, currentWrap, AlignmentStrategy.getNullStrategy(), this.getFormattingMode()));
            if (child.getElementType() != JavaTokenType.COLON) continue;
            currentIndent = Indent.getNoneIndent();
            currentWrap = Wrap.createWrap((WrapType)WrapType.ALWAYS, (boolean)true);
        }
        return result;
    }

    private Indent getLabelIndent() {
        if (this.mySettings.getRootSettings().getIndentOptions((FileType)JavaFileType.INSTANCE).LABEL_INDENT_ABSOLUTE) {
            return Indent.getAbsoluteLabelIndent();
        }
        return Indent.getLabelIndent();
    }

    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        return new ChildAttributes(Indent.getNoneIndent(), null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formattingMode", "com/intellij/psi/formatter/java/LabeledJavaBlock", "<init>"));
    }
}

