/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.build;

import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.task.BuildTask;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ModuleFilesBuildTask;
import com.intellij.task.ModuleResourcesBuildTask;
import com.intellij.task.ProjectModelBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.impl.JpsProjectTaskRunner;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.jvm.ClassDirectoryBinaryNamingScheme;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;
import org.jetbrains.plugins.gradle.execution.build.CachedModuleDataFinder;
import org.jetbrains.plugins.gradle.execution.build.GradleBuildTasksProvider;
import org.jetbrains.plugins.gradle.service.execution.GradleInitScriptUtil;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.task.VersionSpecificInitScript;
import org.jetbrains.plugins.gradle.util.GradleModuleData;

@ApiStatus.Internal
public class TasksExecutionSettingsBuilder {
    @Language(value="Groovy")
    private static final String FORCE_COMPILE_TASKS_INIT_SCRIPT_TEMPLATE = "projectsEvaluated { \n  rootProject.findProject('%s')?.tasks?.withType(AbstractCompile) {  \n    outputs.upToDateWhen { false } \n  } \n}\n";
    private final MultiMap<String, String> buildTasksMap;
    private final MultiMap<String, String> initScripts;
    private final MultiMap<String, VersionSpecificInitScript> versionedInitScripts;
    private final List<Module> modulesToBuild;
    private final List<Module> modulesOfResourcesToBuild;
    private final List<Module> modulesOfFiles;

    public TasksExecutionSettingsBuilder(@NotNull List<ProjectTask> tasks) {
        if (tasks == null) {
            TasksExecutionSettingsBuilder.$$$reportNull$$$0(0);
        }
        this.buildTasksMap = MultiMap.createLinkedSet();
        this.initScripts = MultiMap.createLinkedSet();
        this.versionedInitScripts = MultiMap.createLinkedSet();
        Map taskMap = JpsProjectTaskRunner.groupBy(tasks);
        this.modulesToBuild = this.addModulesBuildTasks((Collection)taskMap.get(ModuleBuildTask.class));
        this.modulesOfResourcesToBuild = this.addModulesBuildTasks((Collection)taskMap.get(ModuleResourcesBuildTask.class));
        this.modulesOfFiles = this.addModulesBuildTasks((Collection)taskMap.get(ModuleFilesBuildTask.class));
        this.addArtifactsBuildTasks((Collection)taskMap.get(ProjectModelBuildTask.class));
    }

    public Set<String> getRootPaths() {
        return this.buildTasksMap.keySet();
    }

    public List<Module> getAffectedModules() {
        return ContainerUtil.concat((List[])new List[]{this.modulesToBuild, this.modulesOfResourcesToBuild, this.modulesOfFiles});
    }

    public void addInitScripts(String rootProjectPath, Iterable<VersionSpecificInitScript> initScript) {
        Collection versionSpecificInitScripts = this.versionedInitScripts.getModifiable((Object)rootProjectPath);
        ContainerUtil.addAll((Collection)versionSpecificInitScripts, initScript);
    }

    public Collection<VersionSpecificInitScript> getVersionedInitScripts(String rootProjectPath) {
        return this.versionedInitScripts.get((Object)rootProjectPath);
    }

    public String getInitScript(String rootProjectPath) {
        return GradleInitScriptUtil.joinInitScripts((Iterable)this.initScripts.get((Object)rootProjectPath));
    }

    public List<String> getTasksToExecute(String rootProjectPath) {
        return new ArrayList<String>(this.buildTasksMap.get((Object)rootProjectPath));
    }

    private List<Module> addModulesBuildTasks(@Nullable Collection<? extends ProjectTask> projectTasks) {
        if (ContainerUtil.isEmpty(projectTasks)) {
            return Collections.emptyList();
        }
        SmartList affectedModules = new SmartList();
        Map rootPathsMap = FactoryMap.create(module -> StringUtil.notNullize((String)GradleRunnerUtil.resolveProjectPath(module)));
        for (ProjectTask projectTask : projectTasks) {
            String buildTaskSuffix;
            List taskDataList;
            String gradleIdentityPath;
            String gradlePath;
            GradleModuleData gradleModuleData;
            String externalProjectPath;
            String projectId;
            if (!(projectTask instanceof ModuleBuildTask)) continue;
            ModuleBuildTask moduleBuildTask = (ModuleBuildTask)projectTask;
            TasksExecutionSettingsBuilder.collectAffectedModules((List<Module>)affectedModules, moduleBuildTask);
            Module module2 = moduleBuildTask.getModule();
            String rootProjectPath = (String)rootPathsMap.get(module2);
            if (StringUtil.isEmpty((String)rootProjectPath) || (projectId = ExternalSystemApiUtil.getExternalProjectId((Module)module2)) == null || (externalProjectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module2)) == null || (gradleModuleData = CachedModuleDataFinder.getGradleModuleData((Module)module2)) == null || (gradlePath = gradleModuleData.getGradlePathOrNull()) == null || (gradleIdentityPath = gradleModuleData.getGradleIdentityPathOrNull()) == null) continue;
            boolean isGradleProjectDirUsedToRunTasks = gradleModuleData.getDirectoryToRunTask().equals(gradleModuleData.getGradleProjectDir());
            if (!isGradleProjectDirUsedToRunTasks) {
                rootProjectPath = gradleModuleData.getDirectoryToRunTask();
            }
            if ((taskDataList = ContainerUtil.mapNotNull((Collection)gradleModuleData.findAll(ProjectKeys.TASK), taskData -> taskData.isInherited() ? null : taskData)).isEmpty()) continue;
            String taskPathPrefix = StringUtil.trimEnd((String)gradleIdentityPath, (String)":") + ":";
            List gradleModuleTasks = ContainerUtil.map((Collection)taskDataList, data -> StringUtil.trimStart((String)data.getName(), (String)taskPathPrefix));
            Collection projectInitScripts = this.initScripts.getModifiable((Object)rootProjectPath);
            Collection buildRootTasks = this.buildTasksMap.getModifiable((Object)rootProjectPath);
            String moduleType = ExternalSystemApiUtil.getExternalModuleType((Module)module2);
            if (!moduleBuildTask.isIncrementalBuild() && !(moduleBuildTask instanceof ModuleFilesBuildTask)) {
                projectInitScripts.add(String.format(FORCE_COMPILE_TASKS_INIT_SCRIPT_TEMPLATE, gradlePath));
            }
            if (moduleBuildTask.isIncludeRuntimeDependencies()) {
                projectInitScripts.add("System.setProperty('org.gradle.java.compile-classpath-packaging', 'true')\n");
            }
            String assembleTask = "assemble";
            boolean buildOnlyResources = projectTask instanceof ModuleResourcesBuildTask;
            String buildTaskPrefix = buildOnlyResources ? "process" : "";
            String string = buildTaskSuffix = buildOnlyResources ? "resources" : "classes";
            if ("sourceSet".equals(moduleType)) {
                String sourceSetName = GradleProjectResolverUtil.getSourceSetName((Module)module2);
                String gradleTask = TasksExecutionSettingsBuilder.getTaskName(buildTaskPrefix, buildTaskSuffix, sourceSetName);
                if (!TasksExecutionSettingsBuilder.addIfContains(taskPathPrefix, gradleTask, gradleModuleTasks, buildRootTasks) && ("main".equals(sourceSetName) || "test".equals(sourceSetName))) {
                    buildRootTasks.add(taskPathPrefix + assembleTask);
                }
                for (GradleBuildTasksProvider buildTasksProvider : (GradleBuildTasksProvider[])GradleBuildTasksProvider.EP_NAME.getExtensions()) {
                    if (!buildTasksProvider.isApplicable((BuildTask)moduleBuildTask)) continue;
                    buildTasksProvider.addBuildTasks((BuildTask)moduleBuildTask, (Consumer<ExternalTaskPojo>)((Consumer)task -> this.buildTasksMap.putValue((Object)task.getLinkedExternalProjectPath(), (Object)task.getName())), (path, script) -> this.versionedInitScripts.putValue(path, script));
                }
                continue;
            }
            String gradleTask = TasksExecutionSettingsBuilder.getTaskName(buildTaskPrefix, buildTaskSuffix, null);
            if (TasksExecutionSettingsBuilder.addIfContains(taskPathPrefix, gradleTask, gradleModuleTasks, buildRootTasks)) {
                String gradleTestTask = TasksExecutionSettingsBuilder.getTaskName(buildTaskPrefix, buildTaskSuffix, "test");
                TasksExecutionSettingsBuilder.addIfContains(taskPathPrefix, gradleTestTask, gradleModuleTasks, buildRootTasks);
                continue;
            }
            if (!gradleModuleTasks.contains(assembleTask)) continue;
            buildRootTasks.add(taskPathPrefix + assembleTask);
        }
        return affectedModules;
    }

    @NotNull
    private static String getTaskName(@NotNull String taskPrefix, @NotNull String taskSuffix, @Nullable String sourceSetName) {
        if (taskPrefix == null) {
            TasksExecutionSettingsBuilder.$$$reportNull$$$0(1);
        }
        if (taskSuffix == null) {
            TasksExecutionSettingsBuilder.$$$reportNull$$$0(2);
        }
        if (Strings.isEmpty((String)sourceSetName)) {
            sourceSetName = "main";
        }
        String string = new ClassDirectoryBinaryNamingScheme(sourceSetName).getTaskName(taskPrefix, taskSuffix);
        if (string == null) {
            TasksExecutionSettingsBuilder.$$$reportNull$$$0(3);
        }
        return string;
    }

    private void addArtifactsBuildTasks(@Nullable Collection<? extends ProjectTask> tasks) {
        if (ContainerUtil.isEmpty(tasks)) {
            return;
        }
        for (ProjectTask projectTask : tasks) {
            if (!(projectTask instanceof ProjectModelBuildTask)) continue;
            ProjectModelBuildTask projectModelBuildTask = (ProjectModelBuildTask)projectTask;
            for (GradleBuildTasksProvider buildTasksProvider : (GradleBuildTasksProvider[])GradleBuildTasksProvider.EP_NAME.getExtensions()) {
                if (!buildTasksProvider.isApplicable((BuildTask)projectModelBuildTask)) continue;
                buildTasksProvider.addBuildTasks((BuildTask)projectModelBuildTask, (Consumer<ExternalTaskPojo>)((Consumer)task -> this.buildTasksMap.putValue((Object)task.getLinkedExternalProjectPath(), (Object)task.getName())), (path, script) -> this.versionedInitScripts.putValue(path, script));
            }
        }
    }

    private static boolean addIfContains(@NotNull String taskPathPrefix, @NotNull String gradleTask, @NotNull List<String> moduleTasks, @NotNull Collection<String> buildRootTasks) {
        if (taskPathPrefix == null) {
            TasksExecutionSettingsBuilder.$$$reportNull$$$0(4);
        }
        if (gradleTask == null) {
            TasksExecutionSettingsBuilder.$$$reportNull$$$0(5);
        }
        if (moduleTasks == null) {
            TasksExecutionSettingsBuilder.$$$reportNull$$$0(6);
        }
        if (buildRootTasks == null) {
            TasksExecutionSettingsBuilder.$$$reportNull$$$0(7);
        }
        if (moduleTasks.contains(gradleTask)) {
            buildRootTasks.add(taskPathPrefix + gradleTask);
            return true;
        }
        return false;
    }

    private static void collectAffectedModules(@NotNull List<Module> affectedModules, @NotNull ModuleBuildTask moduleBuildTask) {
        if (affectedModules == null) {
            TasksExecutionSettingsBuilder.$$$reportNull$$$0(8);
        }
        if (moduleBuildTask == null) {
            TasksExecutionSettingsBuilder.$$$reportNull$$$0(9);
        }
        Module module = moduleBuildTask.getModule();
        if (moduleBuildTask.isIncludeDependentModules()) {
            OrderEnumerator enumerator = ModuleRootManager.getInstance((Module)module).orderEntries().recursively();
            if (!moduleBuildTask.isIncludeRuntimeDependencies()) {
                enumerator = enumerator.compileOnly();
            }
            enumerator.forEachModule((Processor)new CommonProcessors.CollectProcessor(affectedModules));
        } else {
            affectedModules.add(module);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskPrefix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskSuffix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/execution/build/TasksExecutionSettingsBuilder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskPathPrefix";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleTask";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleTasks";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildRootTasks";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedModules";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleBuildTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/execution/build/TasksExecutionSettingsBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaskName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTaskName";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addIfContains";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectAffectedModules";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

