/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.jgroups.util.ByteArray;

public class ByteArrayDataInputStream
extends InputStream
implements DataInput {
    protected final byte[] buf;
    protected int pos;
    protected final int limit;
    protected static final ByteBuffer EMPTY = ByteBuffer.allocate(0);

    public ByteArrayDataInputStream(byte[] buf) {
        this(buf, 0, buf != null ? buf.length : 0);
    }

    public ByteArrayDataInputStream(byte[] buf, int offset, int length) {
        this.buf = buf;
        this.limit = Math.min(buf.length, offset + length);
        this.pos = this.checkBounds(offset);
    }

    public ByteArrayDataInputStream(ByteArray buf) {
        this(buf.getArray(), buf.getOffset(), buf.getLength());
    }

    public ByteArrayDataInputStream(ByteBuffer buffer) {
        int offset = buffer.hasArray() ? buffer.arrayOffset() + buffer.position() : buffer.position();
        int len = buffer.remaining();
        if (!buffer.isDirect()) {
            this.buf = buffer.array();
            this.pos = offset;
            this.limit = offset + len;
        } else {
            byte[] tmp = new byte[len];
            buffer.get(tmp, 0, len);
            this.buf = tmp;
            this.pos = 0;
            this.limit = len;
        }
    }

    public ByteArrayDataInputStream position(int pos) {
        this.pos = this.checkBounds(pos);
        return this;
    }

    public byte[] buffer() {
        return this.buf;
    }

    public ByteArray getBuffer() {
        return new ByteArray(this.buf, this.pos, this.limit - this.pos);
    }

    public ByteBuffer byteBuffer() {
        return ByteBuffer.wrap(this.buf, this.pos, this.limit - this.pos);
    }

    public int position() {
        return this.pos;
    }

    public int limit() {
        return this.limit;
    }

    public int capacity() {
        return this.buf.length;
    }

    public ByteArrayDataInputStream advance(int amount) {
        if (this.pos + amount > this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.pos += amount;
        return this;
    }

    @Override
    public int read() {
        return this.pos < this.limit ? this.buf[this.pos++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        Objects.requireNonNull(b);
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.limit) {
            return -1;
        }
        int avail = this.limit - this.pos;
        if (len > avail) {
            len = avail;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = this.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    public ByteBuffer readBuffer(int len) {
        int avail = this.limit - this.pos;
        if (len > avail || len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return EMPTY;
        }
        ByteBuffer val = ByteBuffer.wrap(this.buf, this.pos, len);
        this.pos += len;
        return val;
    }

    @Override
    public int skipBytes(int n) {
        int k = this.limit - this.pos;
        if (n < k) {
            k = Math.max(n, 0);
        }
        this.pos += k;
        return k;
    }

    @Override
    public boolean readBoolean() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    @Override
    public short readShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + (ch2 << 0);
    }

    @Override
    public char readChar() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    @Override
    public int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read()) | (ch3 = this.read()) | (ch4 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    @Override
    public long readLong() throws IOException {
        return ((long)this.read() << 56) + ((long)(this.read() & 0xFF) << 48) + ((long)(this.read() & 0xFF) << 40) + ((long)(this.read() & 0xFF) << 32) + ((long)(this.read() & 0xFF) << 24) + (long)((this.read() & 0xFF) << 16) + (long)((this.read() & 0xFF) << 8) + (long)((this.read() & 0xFF) << 0);
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public String readLine() throws IOException {
        StringBuilder sb = new StringBuilder(35);
        while (true) {
            int ch;
            if ((ch = this.read()) == -1) {
                return sb.length() == 0 ? null : sb.toString();
            }
            if (ch == 13) continue;
            if (ch == 10) break;
            sb.append((char)ch);
        }
        return sb.toString();
    }

    @Override
    public String readUTF() throws IOException {
        int c;
        int count;
        int utflen = this.readUnsignedShort();
        byte[] bytearr = new byte[utflen];
        char[] chararr = new char[utflen];
        if ((short)utflen == -1) {
            return null;
        }
        int chararr_count = 0;
        this.readFully(bytearr, 0, utflen);
        for (count = 0; count < utflen && (c = bytearr[count] & 0xFF) <= 127; ++count) {
            chararr[chararr_count++] = (char)c;
        }
        block6: while (count < utflen) {
            c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararr_count++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + count);
        }
        return new String(chararr, 0, chararr_count);
    }

    public String toString() {
        return "pos=" + this.pos + " lim=" + this.limit + " cap=" + this.buf.length;
    }

    protected int checkBounds(int pos) {
        if (pos < 0 || pos >= this.limit) {
            throw new IndexOutOfBoundsException("pos=" + pos + ", limit=" + this.limit);
        }
        return pos;
    }
}

