# This file was automatically generated by bifcl from /pobj/zeek-8.0.1/zeek-8.0.1/src/analyzer/protocol/login/functions.bif (plugin mode).

export {



## Returns the state of the given login (Telnet or Rlogin) connection.
##
## cid: The connection ID.
##
## Returns: False if the connection is not active or is not tagged as a
##          login analyzer. Otherwise the function returns the state, which can
##          be one of:
##
##              - ``LOGIN_STATE_AUTHENTICATE``: The connection is in its
##                initial authentication dialog.
##              - ``LOGIN_STATE_LOGGED_IN``: The analyzer believes the user has
##                successfully authenticated.
##              - ``LOGIN_STATE_SKIP``: The analyzer has skipped any further
##                processing of the connection.
##              - ``LOGIN_STATE_CONFUSED``: The analyzer has concluded that it
##                does not correctly know the state of the connection, and/or
##                the username associated with it.
##
## .. zeek:see:: set_login_state
global get_login_state: function(cid: conn_id ): count ;


## Sets the login state of a connection with a login analyzer.
##
## cid: The connection ID.
##
## new_state: The new state of the login analyzer. See
##            :zeek:id:`get_login_state` for possible values.
##
## Returns: Returns false if *cid* is not an active connection
##          or is not tagged as a login analyzer, and true otherwise.
##
## .. zeek:see:: get_login_state
global set_login_state: function(cid: conn_id , new_state: count ): bool ;

} # end of export section
module GLOBAL;
