Recently I was working on an security issue in some other software that has yet to be disclosed which created a rather interesting condition. As a non-root user I was able to write to any file on the system that was not SIP-protected but the resulting file would not be root-owned, even if it previously was.

This presented an interesting challenge for privilege escalation - how would you exploit this to obtain root access? The obvious first attempt was the sudoers file but sudo is smart enough not to process it if the file isn't root-owned so that didn't work.

I then discovered (after a tip from a friend - thanks pndc!) that the cron system in macOS does not care who the crontab files are owned by. Getting root was a simple case of creating a crontab file at:

```
/var/at/tabs/root
```

with a 60-second cron line, eg:

```
* * * * * chown root:wheel /tmp/payload && chmod 4755 /tmp/payload
```

and then waiting for it to execute. It's not clear if this is a macOS-specific issue or a hangover from the BSD-inherited cron system, I suspect the latter.

The issue has been reported to Apple so hopefully they will fix it.