untrusted comment: signature from openbsd 6.0 base secret key
RWSho3oKSqgLQ06Q5htJ+dET+Fnmw0G1tDcGgonr9FlE6V7I0/F8NT3dlySQFpZUitqWrRF7SjT8Oqc0OcGajxN7QkKhQgINRAo=

OpenBSD 6.0 errata 034, August 3, 2017:

Missing socket address validation from userland may result in an info leak.

Apply by doing:
    signify -Vep /etc/signify/openbsd-60-base.pub -x 034_sockaddr.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/kern/uipc_syscalls.c
===================================================================
RCS file: /cvs/src/sys/kern/uipc_syscalls.c,v
--- sys/kern/uipc_syscalls.c	1 Aug 2017 22:10:56 -0000	1.151.4.1
+++ sys/kern/uipc_syscalls.c	1 Aug 2017 22:21:24 -0000	1.151.4.2
@@ -1104,8 +1104,10 @@ sockargs(struct mbuf **mp, const void *b
 	 * We can't allow socket names > UCHAR_MAX in length, since that
 	 * will overflow sa_len. Also, control data more than MCLBYTES in
 	 * length is just too much.
+	 * Memory for sa_len and sa_family must exist.
 	 */
-	if (buflen > (type == MT_SONAME ? UCHAR_MAX : MCLBYTES))
+	if ((buflen > (type == MT_SONAME ? UCHAR_MAX : MCLBYTES)) ||
+	    (type == MT_SONAME && buflen < offsetof(struct sockaddr, sa_data)))
 		return (EINVAL);
 
 	/* Allocate an mbuf to hold the arguments. */
