untrusted comment: signature from openbsd 6.0 base secret key
RWSho3oKSqgLQ5/xQlA/78kaKvliGgaP/wZNKjrLmS7oCyFrOzTM/o4I1P3WUiuOIfSy3jkK7u10csVSb2D0njWgr/s3fWM2tQU=

OpenBSD 6.0 errata 038, August 3, 2017:

A race condition in sosplice() may result in a kernel memory leak.

Apply by doing:
    signify -Vep /etc/signify/openbsd-60-base.pub -x 038_sosplice.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/kern/uipc_socket.c
===================================================================
RCS file: /cvs/src/sys/kern/uipc_socket.c,v
--- sys/kern/uipc_socket.c	13 Jun 2016 21:24:43 -0000	1.152
+++ sys/kern/uipc_socket.c	2 Aug 2017 16:29:08 -0000
@@ -1047,6 +1047,7 @@ sosplice(struct socket *so, int fd, off_
 {
 	struct file	*fp;
 	struct socket	*sosp;
+	struct sosplice	*sp;
 	int		 s, error = 0;
 
 	if ((so->so_proto->pr_flags & PR_SPLICE) == 0)
@@ -1056,8 +1057,13 @@ sosplice(struct socket *so, int fd, off_
 	if ((so->so_state & (SS_ISCONNECTED|SS_ISCONNECTING)) == 0 &&
 	    (so->so_proto->pr_flags & PR_CONNREQUIRED))
 		return (ENOTCONN);
-	if (so->so_sp == NULL)
-		so->so_sp = pool_get(&sosplice_pool, PR_WAITOK | PR_ZERO);
+	if (so->so_sp == NULL) {
+		sp = pool_get(&sosplice_pool, PR_WAITOK | PR_ZERO);
+		if (so->so_sp == NULL)
+			so->so_sp = sp;
+		else
+			pool_put(&sosplice_pool, sp);
+	}
 
 	/* If no fd is given, unsplice by removing existing link. */
 	if (fd < 0) {
@@ -1083,8 +1089,13 @@ sosplice(struct socket *so, int fd, off_
 	if ((error = getsock(curproc, fd, &fp)) != 0)
 		return (error);
 	sosp = fp->f_data;
-	if (sosp->so_sp == NULL)
-		sosp->so_sp = pool_get(&sosplice_pool, PR_WAITOK | PR_ZERO);
+	if (sosp->so_sp == NULL) {
+		sp = pool_get(&sosplice_pool, PR_WAITOK | PR_ZERO);
+		if (sosp->so_sp == NULL)
+			sosp->so_sp = sp;
+		else
+			pool_put(&sosplice_pool, sp);
+	}
 
 	/* Lock both receive and send buffer. */
 	if ((error = sblock(&so->so_rcv,
