/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.web;

import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Repeatable(value=Routes.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
public @interface Route {
    public String path() default "";

    public String regex() default "";

    public HttpMethod[] methods() default {};

    public HandlerType type() default HandlerType.NORMAL;

    public int order() default 0;

    public String[] produces() default {};

    public String[] consumes() default {};

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Routes {
        public Route[] value();
    }

    public static enum HandlerType {
        NORMAL,
        BLOCKING,
        FAILURE;


        public static HandlerType from(String value) {
            for (HandlerType handlerType : HandlerType.values()) {
                if (!handlerType.toString().equals(value)) continue;
                return handlerType;
            }
            return null;
        }
    }

    public static enum HttpMethod {
        GET,
        HEAD,
        POST,
        PUT,
        DELETE,
        OPTIONS;

    }
}

