'''OpenGL extension SGIS.texture4D

This module customises the behaviour of the 
OpenGL.raw.GL.SGIS.texture4D to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension defines 4-dimensional texture mapping.  If EXT_subtexture
	is supported, this extension also defines a mechanism to redefine a
	portion of an existing 4-dimensional texture image.  Because
	EXT_texture3D is required, this extension utilizes the 3-dimensional
	image support defined in by EXT_texture3D as a base for 4-dimensional
	image manipulation.
	
	The 4th dimension has an abstract, rather than physical, reference
	and will be called "extent", since the definition of extent is "that which
	specifies the range or magnitude of an area or volume."
	
	Four-dimensional texture mapping is more constrained than its one, two,
	and three-dimensional counterparts.  Mipmapping is not supported, so
	only the level-zero 4-dimensional texture image can be defined.  Cubic
	filtering is not supported, so the border width must be either zero or
	one.
	
	Four-dimensional textures are used primarily as color lookup tables for
	color conversion.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/SGIS/texture4D.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.SGIS.texture4D import *
from OpenGL.raw.GL.SGIS.texture4D import _EXTENSION_NAME

def glInitTexture4DSGIS():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glTexImage4DSGIS.pixels size not checked against 'format,type,width,height,depth,size4d'
glTexImage4DSGIS=wrapper.wrapper(glTexImage4DSGIS).setInputArraySize(
    'pixels', None
)
# INPUT glTexSubImage4DSGIS.pixels size not checked against 'format,type,width,height,depth,size4d'
glTexSubImage4DSGIS=wrapper.wrapper(glTexSubImage4DSGIS).setInputArraySize(
    'pixels', None
)
### END AUTOGENERATED SECTION

from OpenGL.GL import images as _i
_i.images.RANK_PACKINGS.setdefault(4,[]).extend([
    (_i.GL_1_1.glPixelStorei,GL_PACK_SKIP_VOLUMES_SGIS, 0),
    (_i.GL_1_1.glPixelStorei,GL_PACK_IMAGE_DEPTH_SGIS, 0),
])
