/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.ArcContextPropagationConfig;
import io.quarkus.arc.deployment.ArcDevModeConfig;
import io.quarkus.arc.deployment.ArcTestConfig;
import io.quarkus.deployment.index.IndexDependencyConfig;
import io.quarkus.runtime.annotations.ConfigDocIgnore;
import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@ConfigRoot(phase=ConfigPhase.BUILD_TIME)
@ConfigMapping(prefix="quarkus.arc")
public interface ArcConfig {
    public static final Set<String> ALLOWED_REMOVE_UNUSED_BEANS_VALUES = Set.of("all", "true", "none", "false", "fwk", "framework");

    @WithDefault(value="all")
    public String removeUnusedBeans();

    @WithDefault(value="true")
    public boolean autoInjectFields();

    @WithDefault(value="true")
    public boolean transformUnproxyableClasses();

    @WithDefault(value="true")
    public boolean transformPrivateInjectedFields();

    @WithDefault(value="true")
    public boolean failOnInterceptedPrivateMethod();

    public Optional<List<String>> selectedAlternatives();

    @WithDefault(value="true")
    public boolean autoProducerMethods();

    public Optional<List<String>> excludeTypes();

    public Optional<List<String>> unremovableTypes();

    @ConfigDocSection
    @ConfigDocMapKey(value="dependency-name")
    public Map<String, IndexDependencyConfig> excludeDependency();

    @WithDefault(value="true")
    public boolean detectUnusedFalsePositives();

    @WithDefault(value="true")
    public boolean detectWrongAnnotations();

    @WithDefault(value="false")
    public boolean strictCompatibility();

    public ArcDevModeConfig devMode();

    public ArcTestConfig test();

    public Optional<List<String>> ignoredSplitPackages();

    public ArcContextPropagationConfig contextPropagation();

    @WithDefault(value="auto")
    @ConfigDocIgnore
    public OptimizeContexts optimizeContexts();

    default public boolean isRemoveUnusedBeansFieldValid() {
        return ALLOWED_REMOVE_UNUSED_BEANS_VALUES.contains(this.removeUnusedBeans().toLowerCase());
    }

    default public boolean shouldEnableBeanRemoval() {
        String lowerCase = this.removeUnusedBeans().toLowerCase();
        return "all".equals(lowerCase) || "true".equals(lowerCase) || "fwk".equals(lowerCase) || "framework".equals(lowerCase);
    }

    default public boolean shouldOnlyKeepAppBeans() {
        String lowerCase = this.removeUnusedBeans().toLowerCase();
        return "fwk".equals(lowerCase) || "framework".equals(lowerCase);
    }

    public static enum OptimizeContexts {
        TRUE,
        FALSE,
        AUTO;

    }
}

