/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSceneObjectMSFT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneObjectsMSFT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SCENEOBJECTCOUNT;
    public static final int SCENEOBJECTS;

    public XrSceneObjectsMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSceneObjectsMSFT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSceneObjectsMSFT.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrSceneObjectsMSFT.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int sceneObjectCount() {
        return XrSceneObjectsMSFT.nsceneObjectCount(this.address());
    }

    @Nullable
    @NativeType(value="XrSceneObjectMSFT *")
    public XrSceneObjectMSFT.Buffer sceneObjects() {
        return XrSceneObjectsMSFT.nsceneObjects(this.address());
    }

    public XrSceneObjectsMSFT type(@NativeType(value="XrStructureType") int value) {
        XrSceneObjectsMSFT.ntype(this.address(), value);
        return this;
    }

    public XrSceneObjectsMSFT type$Default() {
        return this.type(1000097008);
    }

    public XrSceneObjectsMSFT next(@NativeType(value="void *") long value) {
        XrSceneObjectsMSFT.nnext(this.address(), value);
        return this;
    }

    public XrSceneObjectsMSFT sceneObjectCount(@NativeType(value="uint32_t") int value) {
        XrSceneObjectsMSFT.nsceneObjectCount(this.address(), value);
        return this;
    }

    public XrSceneObjectsMSFT sceneObjects(@Nullable @NativeType(value="XrSceneObjectMSFT *") XrSceneObjectMSFT.Buffer value) {
        XrSceneObjectsMSFT.nsceneObjects(this.address(), value);
        return this;
    }

    public XrSceneObjectsMSFT set(int type, long next, int sceneObjectCount, @Nullable XrSceneObjectMSFT.Buffer sceneObjects) {
        this.type(type);
        this.next(next);
        this.sceneObjectCount(sceneObjectCount);
        this.sceneObjects(sceneObjects);
        return this;
    }

    public XrSceneObjectsMSFT set(XrSceneObjectsMSFT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSceneObjectsMSFT malloc() {
        return (XrSceneObjectsMSFT)XrSceneObjectsMSFT.wrap(XrSceneObjectsMSFT.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrSceneObjectsMSFT calloc() {
        return (XrSceneObjectsMSFT)XrSceneObjectsMSFT.wrap(XrSceneObjectsMSFT.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrSceneObjectsMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrSceneObjectsMSFT)XrSceneObjectsMSFT.wrap(XrSceneObjectsMSFT.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrSceneObjectsMSFT create(long address) {
        return (XrSceneObjectsMSFT)XrSceneObjectsMSFT.wrap(XrSceneObjectsMSFT.class, (long)address);
    }

    @Nullable
    public static XrSceneObjectsMSFT createSafe(long address) {
        return address == 0L ? null : (XrSceneObjectsMSFT)XrSceneObjectsMSFT.wrap(XrSceneObjectsMSFT.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrSceneObjectsMSFT.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrSceneObjectsMSFT.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrSceneObjectsMSFT.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneObjectsMSFT.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrSceneObjectsMSFT.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrSceneObjectsMSFT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrSceneObjectsMSFT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrSceneObjectsMSFT malloc(MemoryStack stack) {
        return (XrSceneObjectsMSFT)XrSceneObjectsMSFT.wrap(XrSceneObjectsMSFT.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSceneObjectsMSFT calloc(MemoryStack stack) {
        return (XrSceneObjectsMSFT)XrSceneObjectsMSFT.wrap(XrSceneObjectsMSFT.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSceneObjectsMSFT.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSceneObjectsMSFT.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nsceneObjectCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)SCENEOBJECTCOUNT);
    }

    @Nullable
    public static XrSceneObjectMSFT.Buffer nsceneObjects(long struct) {
        return XrSceneObjectMSFT.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)SCENEOBJECTS)), XrSceneObjectsMSFT.nsceneObjectCount(struct));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nsceneObjectCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SCENEOBJECTCOUNT, value);
    }

    public static void nsceneObjects(long struct, @Nullable XrSceneObjectMSFT.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SCENEOBJECTS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        if (value != null) {
            XrSceneObjectsMSFT.nsceneObjectCount(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrSceneObjectsMSFT.__struct((Struct.Member[])new Struct.Member[]{XrSceneObjectsMSFT.__member((int)4), XrSceneObjectsMSFT.__member((int)POINTER_SIZE), XrSceneObjectsMSFT.__member((int)4), XrSceneObjectsMSFT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SCENEOBJECTCOUNT = layout.offsetof(2);
        SCENEOBJECTS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrSceneObjectsMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneObjectsMSFT ELEMENT_FACTORY = XrSceneObjectsMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSceneObjectsMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSceneObjectsMSFT.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrSceneObjectsMSFT.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int sceneObjectCount() {
            return XrSceneObjectsMSFT.nsceneObjectCount(this.address());
        }

        @Nullable
        @NativeType(value="XrSceneObjectMSFT *")
        public XrSceneObjectMSFT.Buffer sceneObjects() {
            return XrSceneObjectsMSFT.nsceneObjects(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSceneObjectsMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000097008);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrSceneObjectsMSFT.nnext(this.address(), value);
            return this;
        }

        public Buffer sceneObjectCount(@NativeType(value="uint32_t") int value) {
            XrSceneObjectsMSFT.nsceneObjectCount(this.address(), value);
            return this;
        }

        public Buffer sceneObjects(@Nullable @NativeType(value="XrSceneObjectMSFT *") XrSceneObjectMSFT.Buffer value) {
            XrSceneObjectsMSFT.nsceneObjects(this.address(), value);
            return this;
        }
    }
}

