/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.xxhash;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct XXH3_state_t")
public class XXH3State
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ACC;
    public static final int CUSTOMSECRET;
    public static final int BUFFER;
    public static final int BUFFEREDSIZE;
    public static final int USESEED;
    public static final int NBSTRIPESSOFAR;
    public static final int TOTALLEN;
    public static final int NBSTRIPESPERBLOCK;
    public static final int SECRETLIMIT;
    public static final int SEED;
    public static final int RESERVED64;
    public static final int EXTSECRET;

    public XXH3State(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XXH3State.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XXH64_hash_t[8]")
    public LongBuffer acc() {
        return XXH3State.nacc(this.address());
    }

    @NativeType(value="XXH64_hash_t")
    public long acc(int index) {
        return XXH3State.nacc(this.address(), index);
    }

    @NativeType(value="unsigned char[XXH3_SECRET_DEFAULT_SIZE]")
    public ByteBuffer customSecret() {
        return XXH3State.ncustomSecret(this.address());
    }

    @NativeType(value="unsigned char")
    public byte customSecret(int index) {
        return XXH3State.ncustomSecret(this.address(), index);
    }

    @NativeType(value="unsigned char[256]")
    public ByteBuffer buffer() {
        return XXH3State.nbuffer(this.address());
    }

    @NativeType(value="unsigned char")
    public byte buffer(int index) {
        return XXH3State.nbuffer(this.address(), index);
    }

    @NativeType(value="XXH32_hash_t")
    public int bufferedSize() {
        return XXH3State.nbufferedSize(this.address());
    }

    @NativeType(value="XXH32_hash_t")
    public int useSeed() {
        return XXH3State.nuseSeed(this.address());
    }

    @NativeType(value="size_t")
    public long nbStripesSoFar() {
        return XXH3State.nnbStripesSoFar(this.address());
    }

    @NativeType(value="XXH64_hash_t")
    public long totalLen() {
        return XXH3State.ntotalLen(this.address());
    }

    @NativeType(value="size_t")
    public long nbStripesPerBlock() {
        return XXH3State.nnbStripesPerBlock(this.address());
    }

    @NativeType(value="size_t")
    public long secretLimit() {
        return XXH3State.nsecretLimit(this.address());
    }

    @NativeType(value="XXH64_hash_t")
    public long seed() {
        return XXH3State.nseed(this.address());
    }

    @NativeType(value="XXH64_hash_t")
    public long reserved64() {
        return XXH3State.nreserved64(this.address());
    }

    @NativeType(value="unsigned char const *")
    public ByteBuffer extSecret(int capacity) {
        return XXH3State.nextSecret(this.address(), capacity);
    }

    public static XXH3State malloc() {
        return (XXH3State)XXH3State.wrap(XXH3State.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XXH3State calloc() {
        return (XXH3State)XXH3State.wrap(XXH3State.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XXH3State create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XXH3State)XXH3State.wrap(XXH3State.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XXH3State create(long address) {
        return (XXH3State)XXH3State.wrap(XXH3State.class, (long)address);
    }

    @Nullable
    public static XXH3State createSafe(long address) {
        return address == 0L ? null : (XXH3State)XXH3State.wrap(XXH3State.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XXH3State.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XXH3State.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XXH3State.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XXH3State.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XXH3State.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XXH3State.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XXH3State.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static XXH3State mallocStack() {
        return XXH3State.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XXH3State callocStack() {
        return XXH3State.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XXH3State mallocStack(MemoryStack stack) {
        return XXH3State.malloc(stack);
    }

    @Deprecated
    public static XXH3State callocStack(MemoryStack stack) {
        return XXH3State.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return XXH3State.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return XXH3State.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return XXH3State.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return XXH3State.calloc(capacity, stack);
    }

    public static XXH3State malloc(MemoryStack stack) {
        return (XXH3State)XXH3State.wrap(XXH3State.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XXH3State calloc(MemoryStack stack) {
        return (XXH3State)XXH3State.wrap(XXH3State.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XXH3State.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XXH3State.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static LongBuffer nacc(long struct) {
        return MemoryUtil.memLongBuffer((long)(struct + (long)ACC), (int)8);
    }

    public static long nacc(long struct, int index) {
        return UNSAFE.getLong(null, struct + (long)ACC + Checks.check((int)index, (int)8) * 8L);
    }

    public static ByteBuffer ncustomSecret(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)CUSTOMSECRET), (int)192);
    }

    public static byte ncustomSecret(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)CUSTOMSECRET + Checks.check((int)index, (int)192) * 1L);
    }

    public static ByteBuffer nbuffer(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)BUFFER), (int)256);
    }

    public static byte nbuffer(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)BUFFER + Checks.check((int)index, (int)256) * 1L);
    }

    public static int nbufferedSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)BUFFEREDSIZE);
    }

    public static int nuseSeed(long struct) {
        return UNSAFE.getInt(null, struct + (long)USESEED);
    }

    public static long nnbStripesSoFar(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NBSTRIPESSOFAR));
    }

    public static long ntotalLen(long struct) {
        return UNSAFE.getLong(null, struct + (long)TOTALLEN);
    }

    public static long nnbStripesPerBlock(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NBSTRIPESPERBLOCK));
    }

    public static long nsecretLimit(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SECRETLIMIT));
    }

    public static long nseed(long struct) {
        return UNSAFE.getLong(null, struct + (long)SEED);
    }

    public static long nreserved64(long struct) {
        return UNSAFE.getLong(null, struct + (long)RESERVED64);
    }

    public static ByteBuffer nextSecret(long struct, int capacity) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)EXTSECRET)), (int)capacity);
    }

    static {
        Struct.Layout layout = XXH3State.__struct((int)DEFAULT_PACK_ALIGNMENT, (int)64, (Struct.Member[])new Struct.Member[]{XXH3State.__array((int)8, (int)8), XXH3State.__array((int)1, (int)192), XXH3State.__padding((int)64, (boolean)false), XXH3State.__array((int)1, (int)256), XXH3State.__member((int)4), XXH3State.__member((int)4), XXH3State.__member((int)POINTER_SIZE), XXH3State.__member((int)8), XXH3State.__member((int)POINTER_SIZE), XXH3State.__member((int)POINTER_SIZE), XXH3State.__member((int)8), XXH3State.__member((int)8), XXH3State.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ACC = layout.offsetof(0);
        CUSTOMSECRET = layout.offsetof(1);
        BUFFER = layout.offsetof(3);
        BUFFEREDSIZE = layout.offsetof(4);
        USESEED = layout.offsetof(5);
        NBSTRIPESSOFAR = layout.offsetof(6);
        TOTALLEN = layout.offsetof(7);
        NBSTRIPESPERBLOCK = layout.offsetof(8);
        SECRETLIMIT = layout.offsetof(9);
        SEED = layout.offsetof(10);
        RESERVED64 = layout.offsetof(11);
        EXTSECRET = layout.offsetof(12);
    }

    public static class Buffer
    extends StructBuffer<XXH3State, Buffer>
    implements NativeResource {
        private static final XXH3State ELEMENT_FACTORY = XXH3State.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XXH3State getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XXH64_hash_t[8]")
        public LongBuffer acc() {
            return XXH3State.nacc(this.address());
        }

        @NativeType(value="XXH64_hash_t")
        public long acc(int index) {
            return XXH3State.nacc(this.address(), index);
        }

        @NativeType(value="unsigned char[XXH3_SECRET_DEFAULT_SIZE]")
        public ByteBuffer customSecret() {
            return XXH3State.ncustomSecret(this.address());
        }

        @NativeType(value="unsigned char")
        public byte customSecret(int index) {
            return XXH3State.ncustomSecret(this.address(), index);
        }

        @NativeType(value="unsigned char[256]")
        public ByteBuffer buffer() {
            return XXH3State.nbuffer(this.address());
        }

        @NativeType(value="unsigned char")
        public byte buffer(int index) {
            return XXH3State.nbuffer(this.address(), index);
        }

        @NativeType(value="XXH32_hash_t")
        public int bufferedSize() {
            return XXH3State.nbufferedSize(this.address());
        }

        @NativeType(value="XXH32_hash_t")
        public int useSeed() {
            return XXH3State.nuseSeed(this.address());
        }

        @NativeType(value="size_t")
        public long nbStripesSoFar() {
            return XXH3State.nnbStripesSoFar(this.address());
        }

        @NativeType(value="XXH64_hash_t")
        public long totalLen() {
            return XXH3State.ntotalLen(this.address());
        }

        @NativeType(value="size_t")
        public long nbStripesPerBlock() {
            return XXH3State.nnbStripesPerBlock(this.address());
        }

        @NativeType(value="size_t")
        public long secretLimit() {
            return XXH3State.nsecretLimit(this.address());
        }

        @NativeType(value="XXH64_hash_t")
        public long seed() {
            return XXH3State.nseed(this.address());
        }

        @NativeType(value="XXH64_hash_t")
        public long reserved64() {
            return XXH3State.nreserved64(this.address());
        }

        @NativeType(value="unsigned char const *")
        public ByteBuffer extSecret(int capacity) {
            return XXH3State.nextSecret(this.address(), capacity);
        }
    }
}

