/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.Jvm;
import org.graalvm.visualvm.application.jvm.JvmFactory;
import org.graalvm.visualvm.application.snapshot.ApplicationSnapshot;
import org.graalvm.visualvm.core.VisualVM;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.DataSourceRepository;
import org.graalvm.visualvm.core.datasource.Storage;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import org.graalvm.visualvm.core.datasupport.DataChangeEvent;
import org.graalvm.visualvm.core.datasupport.DataChangeListener;
import org.graalvm.visualvm.core.snapshot.Snapshot;
import org.graalvm.visualvm.core.ui.DataSourceWindowManager;
import org.graalvm.visualvm.core.ui.actions.ActionUtils;
import org.graalvm.visualvm.jfr.JFRSnapshotSupport;
import org.graalvm.visualvm.jfr.impl.JFRDumpAction;
import org.graalvm.visualvm.jfr.impl.JFRDumpImpl;
import org.graalvm.visualvm.jfr.impl.JFRParameters;
import org.graalvm.visualvm.jfr.impl.JFRSnapshotImpl;
import org.graalvm.visualvm.jfr.impl.JFRStartAction;
import org.graalvm.visualvm.jfr.impl.JFRStopAction;
import org.graalvm.visualvm.tools.jfr.JfrModel;
import org.graalvm.visualvm.tools.jfr.JfrModelFactory;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class JFRRecordingProvider {
    private static final Logger LOGGER = Logger.getLogger(JFRRecordingProvider.class.getName());

    public void jfrStartRecording(Application application) {
        this.jfrStartRecording(application, null);
    }

    public void jfrStartRecording(Application application, String params) {
        JFRParameters parameters = JFRParameters.parse(params);
        this.jfrStartRecording(application, parameters.get("name"), parameters.get("settings"), null, null, null, null, null, null, null);
    }

    public void jfrStartRecording(final Application application, final String name, final String settings, final String delay, final String duration, final Boolean disk, final String path, final String maxAge, final String maxSize, final Boolean dumpOnExit) {
        VisualVM.getInstance().runTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Jvm jvm = JvmFactory.getJVMFor((Application)application);
                ProgressHandle pHandle = null;
                try {
                    String[] stringArray;
                    pHandle = ProgressHandle.createHandle((String)NbBundle.getMessage(JFRRecordingProvider.class, (String)"LBL_Starting_JFR_Recording"));
                    pHandle.setInitialDelay(0);
                    pHandle.start();
                    if (settings == null) {
                        stringArray = null;
                    } else {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = settings;
                    }
                    String[] _settings = stringArray;
                    if (!jvm.startJfrRecording(name, _settings, delay, duration, disk, path, maxAge, maxSize, dumpOnExit)) {
                        JFRRecordingProvider.this.notifyJfrDumpFailed((DataSource)application);
                    } else {
                        Set ds = ActionUtils.getSelectedDataSources();
                        JFRDumpAction.instance().updateState(ds);
                        JFRStartAction.instance().updateState(ds);
                        JFRStopAction.instance().updateState(ds);
                    }
                }
                finally {
                    if (pHandle != null) {
                        ProgressHandle pHandleF = pHandle;
                        SwingUtilities.invokeLater(() -> pHandleF.finish());
                    }
                }
            }
        });
    }

    public void remoteJfrStartRecording(Application application) {
        this.jfrStartRecording(application);
    }

    public void jfrStopRecording(final Application application) {
        VisualVM.getInstance().runTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Jvm jvm = JvmFactory.getJVMFor((Application)application);
                ProgressHandle pHandle = null;
                try {
                    pHandle = ProgressHandle.createHandle((String)NbBundle.getMessage(JFRRecordingProvider.class, (String)"LBL_Stopping_JFR_Recording"));
                    pHandle.setInitialDelay(0);
                    pHandle.start();
                    if (!jvm.stopJfrRecording()) {
                        JFRRecordingProvider.this.notifyJfrStopFailed((DataSource)application);
                    } else {
                        Set ds = ActionUtils.getSelectedDataSources();
                        JFRDumpAction.instance().updateState(ds);
                        JFRStartAction.instance().updateState(ds);
                        JFRStopAction.instance().updateState(ds);
                    }
                }
                finally {
                    if (pHandle != null) {
                        ProgressHandle pHandleF = pHandle;
                        SwingUtilities.invokeLater(() -> pHandleF.finish());
                    }
                }
            }
        });
    }

    public void remoteJfrStopRecording(Application application) {
        this.jfrStopRecording(application);
    }

    public void createJfrDump(final Application application, final boolean stopJfr, final boolean openView) {
        VisualVM.getInstance().runTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block11: {
                    Jvm jvm = JvmFactory.getJVMFor((Application)application);
                    List recordings = Collections.emptyList();
                    if (jvm != null) {
                        recordings = jvm.jfrCheck();
                    }
                    if (recordings.isEmpty()) {
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JFRRecordingProvider.class, (String)"MSG_Cannot_Take_JFR_dump", (Object)DataSourceDescriptorFactory.getDescriptor((DataSource)application).getName()), 0));
                        return;
                    }
                    ProgressHandle pHandle = null;
                    try {
                        pHandle = ProgressHandle.createHandle((String)NbBundle.getMessage(JFRRecordingProvider.class, (String)"LBL_Creating_JFR_Dump"));
                        pHandle.setInitialDelay(0);
                        pHandle.start();
                        try {
                            File snapshotDir = application.getStorage().getDirectory();
                            String name = JFRSnapshotSupport.getCategory().createFileName();
                            File file = new File(snapshotDir, name);
                            jvm.takeJfrDump(((Long)recordings.get(0)).longValue(), file.getAbsolutePath());
                            if (file.isFile()) {
                                JFRDumpImpl jfrDump = new JFRDumpImpl(file, (DataSource)application);
                                application.getRepository().addDataSource((DataSource)jfrDump);
                                if (openView) {
                                    DataSourceWindowManager.sharedInstance().openDataSource((DataSource)jfrDump);
                                }
                                if (stopJfr) {
                                    JFRRecordingProvider.this.jfrStopRecording(application);
                                }
                                break block11;
                            }
                            JFRRecordingProvider.this.notifyJfrDumpFailed((DataSource)application);
                        }
                        catch (IOException ex) {
                            LOGGER.log(Level.INFO, "createJFRDump-Application", ex);
                            JFRRecordingProvider.this.notifyJfrDumpFailed((DataSource)application);
                        }
                    }
                    finally {
                        if (pHandle != null) {
                            ProgressHandle pHandleF = pHandle;
                            SwingUtilities.invokeLater(() -> pHandleF.finish());
                        }
                    }
                }
            }
        });
    }

    public void createRemoteJfrDump(final Application application, final String dumpFile, final boolean customizeDumpFile) {
        VisualVM.getInstance().runTask(new Runnable(){

            @Override
            public void run() {
                JfrModel model = JfrModelFactory.getJFRFor((Application)application);
                if (model == null) {
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JFRRecordingProvider.class, (String)"MSG_Dump_failed"), 0));
                    return;
                }
                List recordings = model.jfrCheck();
                if (recordings.isEmpty()) {
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JFRRecordingProvider.class, (String)"MSG_Cannot_Take_JFR_dump", (Object)DataSourceDescriptorFactory.getDescriptor((DataSource)application).getName()), 0));
                    return;
                }
                String file = dumpFile;
                if (file == null) {
                    file = JFRRecordingProvider.defineRemoteFile(application, customizeDumpFile);
                }
                if (file == null) {
                    return;
                }
                if (model.takeJfrDump(((Long)recordings.get(0)).longValue(), file) != null) {
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JFRRecordingProvider.class, (String)"MSG_Dump_ok", (Object)file), 1));
                } else {
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JFRRecordingProvider.class, (String)"MSG_Dump_save_failed", (Object)file), 0));
                }
            }
        });
    }

    private static String defineRemoteFile(Application app, boolean customizeDumpFile) {
        final String[] path = new String[]{JFRRecordingProvider.defaultJfrDumpPath(app)};
        if (customizeDumpFile) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JLabel label = new JLabel();
                        Mnemonics.setLocalizedText((JLabel)label, (String)NbBundle.getMessage(JFRRecordingProvider.class, (String)"MSG_Remote_JFR_dump"));
                        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
                        JTextField field = new JTextField();
                        label.setLabelFor(field);
                        field.setText(path[0]);
                        Dimension dim = field.getPreferredSize();
                        dim.width = 350;
                        field.setPreferredSize(dim);
                        field.selectAll();
                        JPanel selector = new JPanel(new BorderLayout());
                        selector.setBorder(BorderFactory.createEmptyBorder(15, 10, 5, 10));
                        selector.add((Component)label, "North");
                        selector.add((Component)field, "South");
                        DialogDescriptor dd = new DialogDescriptor((Object)selector, NbBundle.getMessage(JFRRecordingProvider.class, (String)"CAPTION_Remote_JFR_Dump"), true, null);
                        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
                        d.pack();
                        d.setVisible(true);
                        path[0] = dd.getValue() == DialogDescriptor.OK_OPTION ? field.getText() : null;
                    }
                });
            }
            catch (Throwable t) {
                path[0] = null;
            }
        }
        return path[0];
    }

    private static String defaultJfrDumpPath(Application app) {
        String fileName = JFRSnapshotSupport.getCategory().createFileName();
        Jvm jvm = JvmFactory.getJVMFor((Application)app);
        if (jvm == null) {
            return fileName;
        }
        Properties sysprops = jvm.getSystemProperties();
        if (sysprops == null) {
            return fileName;
        }
        String jfrDumpTarget = JFRRecordingProvider.getJfrDumpTarget(sysprops);
        if (jfrDumpTarget == null || jfrDumpTarget.isEmpty()) {
            return fileName;
        }
        String pathsep = sysprops.getProperty("file.separator");
        if (!jfrDumpTarget.endsWith(pathsep)) {
            jfrDumpTarget = jfrDumpTarget + pathsep;
        }
        return jfrDumpTarget + fileName;
    }

    private static String getJfrDumpTarget(Properties sysprops) {
        String targetDir = null;
        String osName = sysprops.getProperty("os.name");
        if (osName != null) {
            if (osName.equals("Solaris") || osName.startsWith("SunOS")) {
                targetDir = sysprops.getProperty("user.home");
            }
            targetDir = sysprops.getProperty("java.io.tmpdir");
        }
        if (targetDir == null) {
            targetDir = sysprops.getProperty("user.dir");
        }
        return targetDir;
    }

    public void initialize() {
        DataSourceRepository.sharedInstance().addDataChangeListener((DataChangeListener)new SnapshotListener(), Snapshot.class);
        DataSourceRepository.sharedInstance().addDataChangeListener((DataChangeListener)new ApplicationListener(), Application.class);
    }

    private void processNewSnapshot(Snapshot snapshot) {
        if (snapshot instanceof JFRSnapshotImpl) {
            return;
        }
        boolean appSnapshot = snapshot instanceof ApplicationSnapshot;
        File snapshotFile = snapshot.getFile();
        if (snapshotFile != null && snapshotFile.isDirectory()) {
            File[] files = snapshotFile.listFiles(JFRSnapshotSupport.getCategory().getFilenameFilter());
            if (files == null) {
                return;
            }
            HashSet<JFRDumpImpl> jfrDumps = new HashSet<JFRDumpImpl>();
            for (File file : files) {
                try {
                    JFRDumpImpl jfrDump = new JFRDumpImpl(file, (DataSource)snapshot);
                    if (appSnapshot) {
                        jfrDump.forceViewClosable(true);
                    }
                    jfrDumps.add(jfrDump);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            snapshot.getRepository().addDataSources(jfrDumps);
        }
    }

    private void processNewApplication(Application application) {
        Storage storage = application.getStorage();
        if (storage.directoryExists()) {
            File[] files = storage.getDirectory().listFiles(JFRSnapshotSupport.getCategory().getFilenameFilter());
            if (files == null) {
                return;
            }
            HashSet<JFRDumpImpl> jfrDumps = new HashSet<JFRDumpImpl>();
            for (File file : files) {
                try {
                    jfrDumps.add(new JFRDumpImpl(file, (DataSource)application));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            application.getRepository().addDataSources(jfrDumps);
        }
    }

    private void notifyJfrDumpFailed(DataSource dataSource) {
        String displayName = DataSourceDescriptorFactory.getDescriptor((DataSource)dataSource).getName();
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JFRRecordingProvider.class, (String)"MSG_Cannot_Take_JFR_dump", (Object)displayName), 0));
    }

    private void notifyJfrStopFailed(DataSource dataSource) {
        String displayName = DataSourceDescriptorFactory.getDescriptor((DataSource)dataSource).getName();
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JFRRecordingProvider.class, (String)"MSG_Cannot_Stop_JFR", (Object)displayName), 0));
    }

    private class ApplicationListener
    implements DataChangeListener<Application> {
        private ApplicationListener() {
        }

        public void dataChanged(DataChangeEvent<Application> event) {
            final Set applications = event.getAdded();
            if (!applications.isEmpty()) {
                VisualVM.getInstance().runTask(new Runnable(){

                    @Override
                    public void run() {
                        for (Application application : applications) {
                            JFRRecordingProvider.this.processNewApplication(application);
                        }
                    }
                });
            }
        }
    }

    private class SnapshotListener
    implements DataChangeListener<Snapshot> {
        private SnapshotListener() {
        }

        public void dataChanged(DataChangeEvent<Snapshot> event) {
            final Set snapshots = event.getAdded();
            if (!snapshots.isEmpty()) {
                VisualVM.getInstance().runTask(new Runnable(){

                    @Override
                    public void run() {
                        for (Snapshot snapshot : snapshots) {
                            JFRRecordingProvider.this.processNewSnapshot(snapshot);
                        }
                    }
                });
            }
        }
    }
}

