/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.aop.config.AopNamespaceUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.config.ConfigUtils;
import org.springframework.security.intercept.method.MapBasedMethodDefinitionSource;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class GlobalMethodSecurityBeanDefinitionParser
implements BeanDefinitionParser {
    public static final String SECURED_DEPENDENCY_CLASS = "org.springframework.security.annotation.Secured";
    public static final String SECURED_METHOD_DEFINITION_SOURCE_CLASS = "org.springframework.security.annotation.SecuredMethodDefinitionSource";
    public static final String JSR_250_SECURITY_METHOD_DEFINITION_SOURCE_CLASS = "org.springframework.security.annotation.Jsr250MethodDefinitionSource";
    public static final String JSR_250_VOTER_CLASS = "org.springframework.security.annotation.Jsr250Voter";
    private static final String ATT_ACCESS = "access";
    private static final String ATT_EXPRESSION = "expression";
    private static final String ATT_ACCESS_MGR = "access-decision-manager-ref";
    private static final String ATT_USE_JSR250 = "jsr250-annotations";
    private static final String ATT_USE_SECURED = "secured-annotations";
    static /* synthetic */ Class class$org$springframework$security$intercept$method$DelegatingMethodDefinitionSource;
    static /* synthetic */ Class class$org$springframework$security$intercept$method$ProtectPointcutPostProcessor;
    static /* synthetic */ Class class$org$springframework$security$intercept$method$aopalliance$MethodSecurityInterceptor;
    static /* synthetic */ Class class$org$springframework$security$config$MethodSecurityInterceptorPostProcessor;
    static /* synthetic */ Class class$org$springframework$security$intercept$method$aopalliance$MethodDefinitionSourceAdvisor;

    GlobalMethodSecurityBeanDefinitionParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Object source = parserContext.extractSource((Object)element);
        ManagedList delegates = new ManagedList();
        boolean jsr250Enabled = this.registerAnnotationBasedMethodDefinitionSources(element, parserContext, delegates);
        MapBasedMethodDefinitionSource mapBasedMethodDefinitionSource = new MapBasedMethodDefinitionSource();
        delegates.add(mapBasedMethodDefinitionSource);
        Map pointcutMap = this.parseProtectPointcuts(parserContext, DomUtils.getChildElementsByTagName((Element)element, (String)"protect-pointcut"));
        if (pointcutMap.size() > 0) {
            this.registerProtectPointcutPostProcessor(parserContext, pointcutMap, mapBasedMethodDefinitionSource, source);
        }
        this.registerDelegatingMethodDefinitionSource(parserContext, delegates, source);
        String accessManagerId = element.getAttribute(ATT_ACCESS_MGR);
        if (!StringUtils.hasText((String)accessManagerId)) {
            ConfigUtils.registerDefaultAccessManagerIfNecessary(parserContext);
            if (jsr250Enabled) {
                ConfigUtils.addVoter((BeanDefinition)new RootBeanDefinition(JSR_250_VOTER_CLASS, null, null), parserContext);
            }
            accessManagerId = "_accessManager";
        }
        this.registerMethodSecurityInterceptor(parserContext, accessManagerId, source);
        this.registerAdvisor(parserContext, source);
        AopNamespaceUtils.registerAutoProxyCreatorIfNecessary((ParserContext)parserContext, (Object)element);
        return null;
    }

    private boolean registerAnnotationBasedMethodDefinitionSources(Element element, ParserContext pc, ManagedList delegates) {
        boolean useJsr250 = "enabled".equals(element.getAttribute(ATT_USE_JSR250));
        boolean useSecured = "enabled".equals(element.getAttribute(ATT_USE_SECURED));
        if (useSecured) {
            delegates.add(BeanDefinitionBuilder.rootBeanDefinition((String)SECURED_METHOD_DEFINITION_SOURCE_CLASS).getBeanDefinition());
        }
        if (useJsr250) {
            delegates.add(BeanDefinitionBuilder.rootBeanDefinition((String)JSR_250_SECURITY_METHOD_DEFINITION_SOURCE_CLASS).getBeanDefinition());
        }
        return useJsr250;
    }

    private void registerDelegatingMethodDefinitionSource(ParserContext parserContext, ManagedList delegates, Object source) {
        if (parserContext.getRegistry().containsBeanDefinition("_delegatingMethodDefinitionSource")) {
            parserContext.getReaderContext().error("Duplicate <global-method-security> detected.", source);
        }
        RootBeanDefinition delegatingMethodDefinitionSource = new RootBeanDefinition(class$org$springframework$security$intercept$method$DelegatingMethodDefinitionSource == null ? (class$org$springframework$security$intercept$method$DelegatingMethodDefinitionSource = GlobalMethodSecurityBeanDefinitionParser.class$("org.springframework.security.intercept.method.DelegatingMethodDefinitionSource")) : class$org$springframework$security$intercept$method$DelegatingMethodDefinitionSource);
        delegatingMethodDefinitionSource.setRole(2);
        delegatingMethodDefinitionSource.setSource(source);
        delegatingMethodDefinitionSource.getPropertyValues().addPropertyValue("methodDefinitionSources", (Object)delegates);
        parserContext.getRegistry().registerBeanDefinition("_delegatingMethodDefinitionSource", (BeanDefinition)delegatingMethodDefinitionSource);
    }

    private void registerProtectPointcutPostProcessor(ParserContext parserContext, Map pointcutMap, MapBasedMethodDefinitionSource mapBasedMethodDefinitionSource, Object source) {
        RootBeanDefinition ppbp = new RootBeanDefinition(class$org$springframework$security$intercept$method$ProtectPointcutPostProcessor == null ? (class$org$springframework$security$intercept$method$ProtectPointcutPostProcessor = GlobalMethodSecurityBeanDefinitionParser.class$("org.springframework.security.intercept.method.ProtectPointcutPostProcessor")) : class$org$springframework$security$intercept$method$ProtectPointcutPostProcessor);
        ppbp.setRole(2);
        ppbp.setSource(source);
        ppbp.getConstructorArgumentValues().addGenericArgumentValue((Object)mapBasedMethodDefinitionSource);
        ppbp.getPropertyValues().addPropertyValue("pointcutMap", (Object)pointcutMap);
        parserContext.getRegistry().registerBeanDefinition("_protectPointcutPostProcessor", (BeanDefinition)ppbp);
    }

    private Map parseProtectPointcuts(ParserContext parserContext, List protectPointcutElts) {
        LinkedHashMap<String, ConfigAttributeDefinition> pointcutMap = new LinkedHashMap<String, ConfigAttributeDefinition>();
        Iterator i = protectPointcutElts.iterator();
        while (i.hasNext()) {
            Element childElt = (Element)i.next();
            String accessConfig = childElt.getAttribute(ATT_ACCESS);
            String expression = childElt.getAttribute(ATT_EXPRESSION);
            if (!StringUtils.hasText((String)accessConfig)) {
                parserContext.getReaderContext().error("Access configuration required", parserContext.extractSource((Object)childElt));
            }
            if (!StringUtils.hasText((String)expression)) {
                parserContext.getReaderContext().error("Pointcut expression required", parserContext.extractSource((Object)childElt));
            }
            ConfigAttributeDefinition def = new ConfigAttributeDefinition(StringUtils.commaDelimitedListToStringArray((String)accessConfig));
            pointcutMap.put(expression, def);
        }
        return pointcutMap;
    }

    private void registerMethodSecurityInterceptor(ParserContext parserContext, String accessManagerId, Object source) {
        RootBeanDefinition interceptor = new RootBeanDefinition(class$org$springframework$security$intercept$method$aopalliance$MethodSecurityInterceptor == null ? (class$org$springframework$security$intercept$method$aopalliance$MethodSecurityInterceptor = GlobalMethodSecurityBeanDefinitionParser.class$("org.springframework.security.intercept.method.aopalliance.MethodSecurityInterceptor")) : class$org$springframework$security$intercept$method$aopalliance$MethodSecurityInterceptor);
        interceptor.setRole(2);
        interceptor.setSource(source);
        interceptor.getPropertyValues().addPropertyValue("accessDecisionManager", (Object)new RuntimeBeanReference(accessManagerId));
        interceptor.getPropertyValues().addPropertyValue("authenticationManager", (Object)new RuntimeBeanReference("_authenticationManager"));
        interceptor.getPropertyValues().addPropertyValue("objectDefinitionSource", (Object)new RuntimeBeanReference("_delegatingMethodDefinitionSource"));
        parserContext.getRegistry().registerBeanDefinition("_methodSecurityInterceptor", (BeanDefinition)interceptor);
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)interceptor, "_methodSecurityInterceptor"));
        parserContext.getRegistry().registerBeanDefinition("_methodSecurityInterceptorPostProcessor", (BeanDefinition)new RootBeanDefinition(class$org$springframework$security$config$MethodSecurityInterceptorPostProcessor == null ? (class$org$springframework$security$config$MethodSecurityInterceptorPostProcessor = GlobalMethodSecurityBeanDefinitionParser.class$("org.springframework.security.config.MethodSecurityInterceptorPostProcessor")) : class$org$springframework$security$config$MethodSecurityInterceptorPostProcessor));
    }

    private void registerAdvisor(ParserContext parserContext, Object source) {
        RootBeanDefinition advisor = new RootBeanDefinition(class$org$springframework$security$intercept$method$aopalliance$MethodDefinitionSourceAdvisor == null ? (class$org$springframework$security$intercept$method$aopalliance$MethodDefinitionSourceAdvisor = GlobalMethodSecurityBeanDefinitionParser.class$("org.springframework.security.intercept.method.aopalliance.MethodDefinitionSourceAdvisor")) : class$org$springframework$security$intercept$method$aopalliance$MethodDefinitionSourceAdvisor);
        advisor.setRole(2);
        advisor.setSource(source);
        advisor.getConstructorArgumentValues().addGenericArgumentValue((Object)"_methodSecurityInterceptor");
        advisor.getConstructorArgumentValues().addGenericArgumentValue((Object)new RuntimeBeanReference("_delegatingMethodDefinitionSource"));
        parserContext.getRegistry().registerBeanDefinition("_methodDefinitionSourceAdvisor", (BeanDefinition)advisor);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

