/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.audio.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Header;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.audio.AudioFormat;
import org.openhab.core.audio.utils.AudioSinkUtils;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component
public class AudioSinkUtilsImpl
implements AudioSinkUtils {
    private final Logger logger = LoggerFactory.getLogger(AudioSinkUtilsImpl.class);

    @Override
    public @Nullable Long transferAndAnalyzeLength(InputStream in, OutputStream out, AudioFormat audioFormat) throws IOException {
        byte[] dataBytes = in.readNBytes(8192);
        long startTime = System.nanoTime();
        out.write(dataBytes);
        Long dataTransferedLength = (long)dataBytes.length + in.transferTo(out);
        if (dataTransferedLength > 0L) {
            if ("PCM_SIGNED".equals(audioFormat.getCodec())) {
                try {
                    Throwable throwable = null;
                    Object var9_11 = null;
                    try (AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(new ByteArrayInputStream(dataBytes));){
                        int frameSize = audioInputStream.getFormat().getFrameSize();
                        float frameRate = audioInputStream.getFormat().getFrameRate();
                        long computedDuration = Float.valueOf((float)dataTransferedLength.longValue() / ((float)frameSize * frameRate) * 1.0E9f).longValue();
                        return startTime + computedDuration;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | UnsupportedAudioFileException e) {
                    this.logger.debug("Cannot compute the duration of input stream with method java stream sound analysis", (Throwable)e);
                    Integer bitRate = audioFormat.getBitRate();
                    if (bitRate != null && bitRate != 0) {
                        long computedDuration = Float.valueOf(8.0f * (float)dataTransferedLength.longValue() / (float)bitRate.intValue() * 1.0E9f).longValue();
                        return startTime + computedDuration;
                    }
                    this.logger.debug("Cannot compute the duration of input stream by using audio format information");
                    return null;
                }
            }
            if ("MP3".equals(audioFormat.getCodec())) {
                Bitstream bitstream = new Bitstream(new ByteArrayInputStream(dataBytes));
                try {
                    Header h = bitstream.readFrame();
                    if (h != null) {
                        long computedDuration = Float.valueOf(h.total_ms(dataTransferedLength.intValue()) * 1000000.0f).longValue();
                        return startTime + computedDuration;
                    }
                }
                catch (BitstreamException ex) {
                    this.logger.debug("Cannot compute the duration of input stream", (Throwable)ex);
                    return null;
                }
            }
        }
        return null;
    }
}

