/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Set;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class EasyTrackProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("*").expression("..,").number("d+,").expression("([^,]{2}),").expression("([AV]),").number("(xx)(xx)(xx),").number("(xx)(xx)(xx),").number("(x)(x{7}),").number("(x)(x{7}),").number("(x{4}),").number("(x{4}),").number("(x{8}),").number("(x+),").number("(d+),").number("(x+),").number("(x+)").groupBegin().number(",(x+)").groupBegin().number(",d+").number(",(x*)").number(",(x+)").number(",(d+.d+)").number(",(d+)").groupEnd("?").groupEnd("?").any().compile();
    private static final Pattern PATTERN_CELL = new PatternBuilder().text("*").expression("..,").number("d+,").text("JZ,").number("[01],").number("(d+),").number("(d+),").number("(d+),").number("(d+)").any().compile();
    private static final Pattern PATTERN_OBD = new PatternBuilder().text("*").expression("..,").number("d+,").text("OB,").text("BD$").number("V(d+.d);").number("R(d+);").number("S(d+);").number("P(d+.d);").number("O(d+.d);").number("C(d+);").number("L(d+.d);").number("[XY][MH]d+.d+;").number("Md+.?d*;").number("F(d+.d+);").number("T(d+);").any().compile();

    public EasyTrackProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void decodeAlarm(Position position, long status, String model) {
        if ((status & 0x2000000L) != 0L) {
            position.addAlarm("geofenceEnter");
        }
        if ((status & 0x4000000L) != 0L) {
            position.addAlarm("geofenceExit");
        }
        if ((status & 0x8000000L) != 0L) {
            position.addAlarm("lowBattery");
        }
        if ((status & 0x10000000L) != 0L || (status & 8L) != 0L) {
            position.addAlarm("jamming");
        }
        if ((status & 0x20000000L) != 0L) {
            position.addAlarm("vibration");
        }
        if ((status & 0x80000000L) != 0L) {
            position.addAlarm("overspeed");
        }
        if ((status & 0x10000L) != 0L || (status & 0x400L) != 0L) {
            position.addAlarm("sos");
        }
        if ((status & 0x40000L) != 0L) {
            position.addAlarm("E3+4G".equals(model) ? "tampering" : "powerCut");
        }
        if ((status & 0x40000L) != 0L) {
            position.addAlarm("powerCut");
        }
        if ((status & 0x4000L) != 0L) {
            position.addAlarm("lowPower");
        }
        if ((status & 0x8000L) != 0L) {
            position.addAlarm("temperature");
        }
        if ((status & 0x100L) != 0L) {
            position.addAlarm("removing");
        }
        if ((status & 1L) != 0L) {
            position.addAlarm("hardBraking");
        }
        if ((status & 2L) != 0L) {
            position.addAlarm("hardAcceleration");
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        int typeIndex = sentence.indexOf(44, 4) + 1;
        String imei = sentence.substring(4, typeIndex - 1);
        String type = sentence.substring(typeIndex, typeIndex + 2);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        if (channel != null) {
            if (type.equals("TX") || type.equals("MQ")) {
                channel.writeAndFlush((Object)new NetworkMessage(sentence + "#", remoteAddress));
            } else if ("E3+4G".equals(this.getDeviceModel(deviceSession)) && Set.of("HB", "CC", "AM", "DW", "JZ").contains(type)) {
                channel.writeAndFlush((Object)new NetworkMessage(sentence.substring(0, typeIndex + 3) + "ACK#", remoteAddress));
            }
        }
        if (type.equals("OB")) {
            return this.decodeObd(deviceSession, sentence);
        }
        if (type.equals("JZ")) {
            if (channel != null && Integer.parseInt(sentence.substring(typeIndex + 3, typeIndex + 4)) > 0) {
                channel.writeAndFlush((Object)new NetworkMessage(String.format("*ET,%s,JZ,undefined#", imei), remoteAddress));
            }
            return this.decodeCell(deviceSession, sentence);
        }
        return this.decodeLocation(deviceSession, sentence);
    }

    private Position decodeLocation(DeviceSession deviceSession, String sentence) {
        Parser parser = new Parser(PATTERN, sentence);
        if (!parser.matches()) {
            return null;
        }
        String model = this.getDeviceModel(deviceSession);
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("command", parser.next());
        position.setValid(parser.next().equals("A"));
        DateBuilder dateBuilder = new DateBuilder().setDate(parser.nextHexInt(), parser.nextHexInt(), parser.nextHexInt()).setTime(parser.nextHexInt(), parser.nextHexInt(), parser.nextHexInt());
        position.setTime(dateBuilder.getDate());
        if (BitUtil.check(parser.nextHexInt().intValue(), 3)) {
            position.setLatitude((double)(-parser.nextHexInt().intValue()) / 600000.0);
        } else {
            position.setLatitude((double)parser.nextHexInt().intValue() / 600000.0);
        }
        if (BitUtil.check(parser.nextHexInt().intValue(), 3)) {
            position.setLongitude((double)(-parser.nextHexInt().intValue()) / 600000.0);
        } else {
            position.setLongitude((double)parser.nextHexInt().intValue() / 600000.0);
        }
        position.setSpeed(UnitsConverter.knotsFromKph((double)parser.nextHexInt().intValue() / 100.0));
        double course = (double)parser.nextHexInt().intValue() * 0.01;
        if (course < 360.0) {
            position.setCourse(course);
        }
        long status = parser.nextHexLong();
        this.decodeAlarm(position, status, model);
        position.set("blocked", (status & 0x80000L) > 0L);
        position.set("ignition", (status & 0x800000L) > 0L);
        position.set("status", status);
        position.set("rssi", parser.nextHexInt());
        position.set("power", parser.nextDouble());
        if ("E3+4G".equals(model)) {
            position.set("index", parser.nextHexInt());
        } else {
            position.set("fuel", parser.nextHexInt());
        }
        position.set("odometer", parser.nextHexInt() * 100);
        position.setAltitude(parser.nextDouble(0.0));
        if (parser.hasNext(4)) {
            if ("E3+4G".equals(model)) {
                position.set("hours", parser.nextHexLong() * 60000L);
            } else {
                position.set("driverUniqueId", parser.next());
            }
            position.set("temp1", (double)parser.nextHexInt().intValue() * 0.01);
            position.set("adc1", parser.nextDouble());
            position.set("sat", parser.nextInt());
        }
        return position;
    }

    private Position decodeCell(DeviceSession deviceSession, String sentence) {
        Parser parser = new Parser(PATTERN_CELL, sentence);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.getLastLocation(position, null);
        int cid = parser.nextInt();
        int lac = parser.nextInt();
        int mcc = parser.nextInt();
        int mnc = parser.nextInt();
        position.setNetwork(new Network(CellTower.from(mcc, mnc, lac, cid)));
        return position;
    }

    private Position decodeObd(DeviceSession deviceSession, String sentence) {
        Parser parser = new Parser(PATTERN_OBD, sentence);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.getLastLocation(position, null);
        position.set("battery", parser.nextDouble());
        position.set("rpm", parser.nextInt());
        position.set("obdSpeed", parser.nextInt());
        position.set("throttle", parser.nextDouble());
        position.set("engineLoad", parser.nextDouble());
        position.set("coolantTemp", parser.nextInt());
        position.set("fuel", parser.nextDouble());
        position.set("fuelConsumption", parser.nextDouble());
        position.set("hours", parser.nextInt());
        return position;
    }
}

