/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jmx.impl;

import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.graalvm.visualvm.core.VisualVM;
import org.graalvm.visualvm.core.ui.actions.ActionUtils;
import org.graalvm.visualvm.core.ui.actions.SingleDataSourceAction;
import org.graalvm.visualvm.jmx.impl.JmxApplication;
import org.graalvm.visualvm.jmx.impl.JmxHeartbeat;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public final class ConnectDisconnectAction
extends SingleDataSourceAction<JmxApplication>
implements Presenter.Popup {
    private static ConnectDisconnectAction INSTANCE;
    private int currentState = -1;
    private boolean currentAutoConnect;

    public static synchronized ConnectDisconnectAction instance() {
        if (INSTANCE == null) {
            INSTANCE = new ConnectDisconnectAction();
        }
        return INSTANCE;
    }

    protected void actionPerformed(final JmxApplication app, ActionEvent actionEvent) {
        final int state = this.currentState;
        VisualVM.getInstance().runTask(new Runnable(){

            @Override
            public void run() {
                if (state == 1) {
                    app.disconnect();
                } else {
                    JmxHeartbeat.scheduleImmediately(app);
                }
            }
        });
    }

    protected boolean isEnabled(JmxApplication app) {
        return true;
    }

    public JMenuItem getPopupPresenter() {
        JmxApplication app = (JmxApplication)ActionUtils.getSelectedDataSource((Class)this.getScope());
        this.currentState = app.getState();
        this.currentAutoConnect = !app.isHeartbeatDisabled();
        JMenuItem presenter = new JMenuItem((Action)((Object)this));
        if (this.currentState == 1) {
            Mnemonics.setLocalizedText((AbstractButton)presenter, (String)NbBundle.getMessage(ConnectDisconnectAction.class, (String)"LBL_Disconnect"));
        } else {
            Mnemonics.setLocalizedText((AbstractButton)presenter, (String)NbBundle.getMessage(ConnectDisconnectAction.class, (String)"LBL_Connect"));
        }
        presenter.setEnabled(this.currentState == 1 || !this.currentAutoConnect);
        return presenter;
    }

    private ConnectDisconnectAction() {
        super(JmxApplication.class);
    }
}

