/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter.json;

import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.util.Assert;

public class SpringHandlerInstantiator
extends HandlerInstantiator {
    private final AutowireCapableBeanFactory beanFactory;

    public SpringHandlerInstantiator(AutowireCapableBeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        this.beanFactory = beanFactory;
    }

    public JsonSerializer<?> serializerInstance(SerializationConfig config, Annotated annotated, Class<?> keyDeserClass) {
        return (JsonSerializer)this.beanFactory.createBean(keyDeserClass);
    }

    public JsonDeserializer<?> deserializerInstance(DeserializationConfig config, Annotated annotated, Class<?> deserClass) {
        return (JsonDeserializer)this.beanFactory.createBean(deserClass);
    }

    public KeyDeserializer keyDeserializerInstance(DeserializationConfig config, Annotated annotated, Class<?> serClass) {
        return (KeyDeserializer)this.beanFactory.createBean(serClass);
    }

    public TypeResolverBuilder<?> typeResolverBuilderInstance(MapperConfig<?> config, Annotated annotated, Class<?> resolverClass) {
        return (TypeResolverBuilder)this.beanFactory.createBean(resolverClass);
    }

    public TypeIdResolver typeIdResolverInstance(MapperConfig<?> config, Annotated annotated, Class<?> resolverClass) {
        return (TypeIdResolver)this.beanFactory.createBean(resolverClass);
    }
}

