/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.profile.output;

import au.com.bytecode.opencsv.CSVWriter;
import ca.sqlpower.architect.ddl.GenericDDLGenerator;
import ca.sqlpower.architect.profile.ColumnProfileResult;
import ca.sqlpower.architect.profile.ProfileResult;
import ca.sqlpower.architect.profile.TableProfileResult;
import ca.sqlpower.architect.profile.output.ProfileColumn;
import ca.sqlpower.architect.profile.output.ProfileFormat;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.swingui.table.DateTableCellRenderer;
import ca.sqlpower.swingui.table.DecimalTableCellRenderer;
import ca.sqlpower.swingui.table.PercentTableCellRenderer;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.Format;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ProfileCSVFormat
implements ProfileFormat {
    @Override
    public void format(OutputStream nout, List<ProfileResult> profileResult) throws Exception {
        PrintWriter out = new PrintWriter(nout);
        ProfileColumn[] columns = ProfileColumn.values();
        String[] columnNames = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            columnNames[i] = columns[i].toString();
        }
        CSVWriter csvWriter = new CSVWriter((Writer)out);
        csvWriter.writeNext(columnNames);
        GenericDDLGenerator gddl = new GenericDDLGenerator();
        Format dateFormat = new DateTableCellRenderer().getFormat();
        Format decFormat = new DecimalTableCellRenderer().getFormat();
        Format pctFormat = new PercentTableCellRenderer().getFormat();
        for (ProfileResult result : profileResult) {
            if (!(result instanceof ColumnProfileResult)) continue;
            SQLColumn c = (SQLColumn)result.getProfiledObject();
            SQLTable t = c.getParent();
            TableProfileResult tpr = ((ColumnProfileResult)result).getParent();
            ArrayList<String> commonData = new ArrayList<String>();
            block23: for (ProfileColumn pc : columns) {
                switch (pc) {
                    case DATABASE: {
                        commonData.add(t.getParentDatabase().getName());
                        continue block23;
                    }
                    case CATALOG: {
                        commonData.add(t.getCatalog() != null ? t.getCatalog().getName() : "");
                        continue block23;
                    }
                    case SCHEMA: {
                        commonData.add(t.getSchema() != null ? t.getSchema().getName() : "");
                        continue block23;
                    }
                    case TABLE: {
                        commonData.add(t.getName());
                        continue block23;
                    }
                    case COLUMN: {
                        commonData.add(c.getName());
                        continue block23;
                    }
                    case RUNDATE: {
                        Date date = new Date(tpr.getCreateStartTime());
                        commonData.add(dateFormat.format(date));
                        continue block23;
                    }
                    case RECORD_COUNT: {
                        commonData.add(Integer.toString(tpr.getRowCount()));
                        continue block23;
                    }
                    case DATA_TYPE: {
                        commonData.add(gddl.columnType(c));
                        continue block23;
                    }
                    case NULL_COUNT: {
                        commonData.add(Integer.toString(((ColumnProfileResult)result).getNullCount()));
                        continue block23;
                    }
                    case PERCENT_NULL: {
                        if (tpr.getRowCount() == 0) {
                            commonData.add("n/a");
                            continue block23;
                        }
                        commonData.add(pctFormat.format((double)((ColumnProfileResult)result).getNullCount() / (double)tpr.getRowCount()));
                        continue block23;
                    }
                    case UNIQUE_COUNT: {
                        commonData.add(Integer.toString(((ColumnProfileResult)result).getDistinctValueCount()));
                        continue block23;
                    }
                    case PERCENT_UNIQUE: {
                        if (tpr.getRowCount() == 0) {
                            commonData.add("n/a");
                            continue block23;
                        }
                        commonData.add(pctFormat.format((double)((ColumnProfileResult)result).getDistinctValueCount() / (double)tpr.getRowCount()));
                        continue block23;
                    }
                    case MIN_LENGTH: {
                        commonData.add(Integer.toString(((ColumnProfileResult)result).getMinLength()));
                        continue block23;
                    }
                    case MAX_LENGTH: {
                        commonData.add(Integer.toString(((ColumnProfileResult)result).getMaxLength()));
                        continue block23;
                    }
                    case AVERAGE_LENGTH: {
                        commonData.add(decFormat.format(((ColumnProfileResult)result).getAvgLength()));
                        continue block23;
                    }
                    case MIN_VALUE: {
                        Object minValue = ((ColumnProfileResult)result).getMinValue();
                        if (minValue == null) {
                            commonData.add("");
                            continue block23;
                        }
                        commonData.add(minValue.toString());
                        continue block23;
                    }
                    case MAX_VALUE: {
                        Object maxValue = ((ColumnProfileResult)result).getMaxValue();
                        if (maxValue == null) {
                            commonData.add("");
                            continue block23;
                        }
                        commonData.add(maxValue.toString());
                        continue block23;
                    }
                    case AVERAGE_VALUE: {
                        Object value = ((ColumnProfileResult)result).getAvgValue();
                        String formattedValue = value == null ? "" : (value instanceof Number ? decFormat.format(value) : value.toString());
                        commonData.add(formattedValue);
                        continue block23;
                    }
                    case TOP_VALUE: {
                        commonData.add("");
                        continue block23;
                    }
                    default: {
                        throw new IllegalStateException("Need code to handle this column!");
                    }
                }
            }
            csvWriter.writeNext(commonData.toArray(new String[commonData.size()]));
        }
        csvWriter.close();
        out.close();
    }
}

