/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ddl.DDLGenerator;
import ca.sqlpower.architect.ddl.DDLUtils;
import ca.sqlpower.architect.ddl.GenericDDLGenerator;
import ca.sqlpower.architect.ddl.LiquibaseDDLGenerator;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.DDLGeneratorListCellRenderer;
import ca.sqlpower.architect.swingui.FormLayout;
import ca.sqlpower.architect.swingui.LiquibaseOptionsPanel;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.sql.DataSourceCollection;
import ca.sqlpower.sql.DatabaseListChangeEvent;
import ca.sqlpower.sql.DatabaseListChangeListener;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.swingui.DataEntryPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class DDLExportPanel
implements DataEntryPanel {
    private static final Logger logger = Logger.getLogger(DDLExportPanel.class);
    private JPanel panel = new JPanel();
    private LiquibaseOptionsPanel lbOptions;
    private final ArchitectSwingSession session;
    private JComboBox targetDB;
    private JButton newTargetDB;
    private JComboBox dbType;
    private JCheckBox liquibaseCheckbox;
    private JLabel catalogLabel;
    private JTextField catalogField;
    private JLabel schemaLabel;
    private JTextField schemaField;
    private final DatabaseListChangeListener databaseListChangeListener = new DatabaseListChangeListener(){

        public void databaseRemoved(DatabaseListChangeEvent e) {
            DDLExportPanel.this.targetDB.removeItem(e.getDataSource());
        }

        public void databaseAdded(DatabaseListChangeEvent e) {
            DDLExportPanel.this.targetDB.addItem(e.getDataSource());
        }
    };
    private DataSourceCollection<JDBCDataSource> plDotIni;

    public DDLExportPanel(ArchitectSwingSession session) {
        this.session = session;
        this.setup();
        this.panel.setVisible(true);
    }

    private void setup() {
        this.panel.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel(new FormLayout());
        JPanel panelProperties = new JPanel(new FormLayout());
        panelProperties.add(new JLabel(Messages.getString("DDLExportPanel.createInLabel")));
        this.targetDB = new JComboBox();
        panelProperties.add(this.targetDB);
        this.targetDB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String generatorClass;
                JDBCDataSource dataSource = (JDBCDataSource)DDLExportPanel.this.targetDB.getSelectedItem();
                if (dataSource != null && (generatorClass = dataSource.getParentType().getDDLGeneratorClass()) != null) {
                    try {
                        DDLExportPanel.this.dbType.setSelectedItem(Class.forName(generatorClass, true, DDLExportPanel.class.getClassLoader()));
                    }
                    catch (ClassNotFoundException ex) {
                        logger.error((Object)"Error when finding the DDLGenerator class for the selected database!", (Throwable)ex);
                    }
                }
            }
        });
        this.targetDB.setPrototypeDisplayValue(Messages.getString("DDLExportPanel.targetDatabase"));
        ASUtils.setupTargetDBComboBox(this.session, this.targetDB);
        this.newTargetDB = new JButton(Messages.getString("DDLExportPanel.propertiesButton"));
        this.newTargetDB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ASUtils.showTargetDbcsDialog(DDLExportPanel.this.session.getArchitectFrame(), DDLExportPanel.this.session, DDLExportPanel.this.targetDB);
            }
        });
        panelProperties.add(new JLabel(Messages.getString("DDLExportPanel.generateDDLForDbType")));
        DDLGenerator ddlg = this.session.getDDLGenerator();
        this.plDotIni = this.session.getDataSources();
        this.plDotIni.addDatabaseListChangeListener(this.databaseListChangeListener);
        Vector<Class<? extends DDLGenerator>> ddlTypes = DDLUtils.getDDLTypes(this.plDotIni);
        if (!ddlTypes.contains(ddlg.getClass())) {
            ddlTypes.add(ddlg.getClass());
        }
        this.dbType = new JComboBox<Class<? extends DDLGenerator>>(ddlTypes);
        panelProperties.add(this.dbType);
        this.dbType.setRenderer(new DDLGeneratorListCellRenderer());
        this.dbType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DDLExportPanel.this.setUpCatalogAndSchemaFields();
            }
        });
        this.catalogLabel = new JLabel(Messages.getString("DDLExportPanel.targetCatalog"));
        panelProperties.add(this.catalogLabel);
        this.catalogField = new JTextField(ddlg.getTargetCatalog());
        panelProperties.add(this.catalogField);
        this.schemaLabel = new JLabel(Messages.getString("DDLExportPanel.targetSchema"));
        panelProperties.add(this.schemaLabel);
        this.schemaField = new JTextField(ddlg.getTargetSchema());
        panelProperties.add(this.schemaField);
        mainPanel.add(panelProperties);
        mainPanel.add(this.newTargetDB);
        this.liquibaseCheckbox = new JCheckBox(Messages.getString("DDLExportPanel.liqubaseScript"));
        mainPanel.add(this.liquibaseCheckbox);
        mainPanel.add(new JPanel());
        this.liquibaseCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DDLExportPanel.this.setUpCatalogAndSchemaFields();
                DDLExportPanel.this.dbType.setEnabled(!DDLExportPanel.this.liquibaseCheckbox.isSelected());
                DDLExportPanel.this.targetDB.setEnabled(!DDLExportPanel.this.liquibaseCheckbox.isSelected());
                DDLExportPanel.this.newTargetDB.setEnabled(!DDLExportPanel.this.liquibaseCheckbox.isSelected());
                DDLExportPanel.this.toggleLiquibaseOptions(DDLExportPanel.this.liquibaseCheckbox.isSelected());
            }
        });
        this.panel.add((Component)mainPanel, "Center");
        this.lbOptions = new LiquibaseOptionsPanel();
        this.lbOptions.restoreSettings(this.session.getLiquibaseSettings());
        this.panel.add((Component)this.lbOptions.getPanel(), "South");
        if (ddlg instanceof LiquibaseDDLGenerator) {
            this.liquibaseCheckbox.setSelected(true);
            this.lbOptions.getPanel().setVisible(true);
        } else {
            this.dbType.setSelectedItem(ddlg.getClass());
            this.lbOptions.getPanel().setVisible(false);
        }
        this.setUpCatalogAndSchemaFields();
    }

    private void toggleLiquibaseOptions(boolean visible) {
        this.lbOptions.getPanel().setVisible(visible);
        Window w = SwingUtilities.getWindowAncestor(this.panel);
        if (w != null) {
            w.pack();
        }
    }

    private void setUpCatalogAndSchemaFields() {
        Class<? extends DDLGenerator> selectedGeneratorClass = null;
        try {
            selectedGeneratorClass = this.getSelectedGeneratorClass();
            DDLGenerator newGen = selectedGeneratorClass.newInstance();
            if (newGen.getCatalogTerm() != null) {
                this.catalogLabel.setText(newGen.getCatalogTerm());
                this.catalogLabel.setEnabled(true);
                this.catalogField.setEnabled(true);
            } else {
                this.catalogLabel.setText(Messages.getString("DDLExportPanel.noCatalog"));
                this.catalogLabel.setEnabled(false);
                this.catalogField.setText(null);
                this.catalogField.setEnabled(false);
            }
            if (newGen.getSchemaTerm() != null) {
                this.schemaLabel.setText(newGen.getSchemaTerm());
                this.schemaLabel.setEnabled(true);
                this.schemaField.setEnabled(true);
            } else {
                this.schemaLabel.setText(Messages.getString("DDLExportPanel.noSchema"));
                this.schemaLabel.setEnabled(false);
                this.schemaField.setText(null);
                this.schemaField.setEnabled(false);
            }
        }
        catch (Exception ex) {
            String message = Messages.getString("DDLExportPanel.couldNotCreateDdlGenerator");
            if (selectedGeneratorClass != null) {
                message = message + ":\n" + selectedGeneratorClass.getName();
            }
            logger.error((Object)message, (Throwable)ex);
            ASUtils.showExceptionDialogNoReport(this.panel, message, ex);
        }
    }

    private Class<? extends DDLGenerator> getSelectedGeneratorClass() {
        if (this.liquibaseCheckbox.isSelected()) {
            return LiquibaseDDLGenerator.class;
        }
        return (Class)this.dbType.getSelectedItem();
    }

    public DDLGenerator getGenerator() {
        Class<? extends DDLGenerator> genClass = this.getSelectedGeneratorClass();
        try {
            DDLGenerator gen = genClass.newInstance();
            if (gen instanceof LiquibaseDDLGenerator) {
                ((LiquibaseDDLGenerator)gen).applySettings(this.lbOptions.getLiquibaseSettings());
            }
            return gen;
        }
        catch (Exception ex) {
            logger.error((Object)"Problem creating user-selected DDL generator", (Throwable)ex);
            throw new RuntimeException(Messages.getString("DDLExportPanel.couldNotCreateDdlGenerator"), ex);
        }
    }

    public boolean applyChanges() {
        this.disconnect();
        DDLGenerator ddlg = this.session.getDDLGenerator();
        Class<? extends DDLGenerator> selectedGeneratorClass = this.getSelectedGeneratorClass();
        if (ddlg.getClass() != selectedGeneratorClass) {
            try {
                ddlg = selectedGeneratorClass.newInstance();
                this.session.setDDLGenerator(ddlg);
            }
            catch (Exception ex) {
                logger.error((Object)"Problem creating user-selected DDL generator", (Throwable)ex);
                throw new RuntimeException(Messages.getString("DDLExportPanel.couldNotCreateDdlGenerator"), ex);
            }
        }
        this.session.setLiquibaseSettings(this.lbOptions.getLiquibaseSettings());
        if (selectedGeneratorClass == GenericDDLGenerator.class) {
            ddlg.setAllowConnection(true);
        } else {
            ddlg.setAllowConnection(false);
        }
        if (this.catalogField.isEnabled() && this.catalogField.getText() != null && this.catalogField.getText().trim().length() > 0) {
            ddlg.setTargetCatalog(this.catalogField.getText().trim());
        }
        if (this.schemaField.isEnabled() && this.schemaField.getText() != null && this.schemaField.getText().trim().length() > 0) {
            ddlg.setTargetSchema(this.schemaField.getText().trim());
        }
        return true;
    }

    public void discardChanges() {
        this.disconnect();
    }

    private void disconnect() {
        this.plDotIni.removeDatabaseListChangeListener(this.databaseListChangeListener);
    }

    public JTextField getSchemaField() {
        return this.schemaField;
    }

    public void setSchemaField(JTextField schemaField) {
        this.schemaField = schemaField;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public JDBCDataSource getTargetDB() {
        return (JDBCDataSource)this.targetDB.getSelectedItem();
    }

    public boolean hasUnsavedChanges() {
        return true;
    }
}

