/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.event.SwingPropertyChangeSupport;

public abstract class AbstractAction
implements Action,
Cloneable,
Serializable {
    private static final long serialVersionUID = -6803159439231523484L;
    protected boolean enabled = true;
    protected SwingPropertyChangeSupport changeSupport = new SwingPropertyChangeSupport(this);
    private transient HashMap store = new HashMap();

    public AbstractAction() {
    }

    public AbstractAction(String name) {
        this.putValue("Name", name);
    }

    public AbstractAction(String name, Icon icon) {
        this.putValue("Name", name);
        this.putValue("SmallIcon", icon);
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractAction copy = (AbstractAction)super.clone();
        copy.store = (HashMap)this.store.clone();
        return copy;
    }

    public Object getValue(String key) {
        return this.store.get(key);
    }

    public void putValue(String key, Object value) {
        Object old = this.getValue(key);
        if (old == null && value != null || old != null && !old.equals(value)) {
            this.store.put(key, value);
            this.firePropertyChange(key, old, value);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.enabled) {
            this.enabled = enabled;
            this.firePropertyChange("enabled", !this.enabled, this.enabled);
        }
    }

    public Object[] getKeys() {
        return this.store.keySet().toArray();
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    private void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.changeSupport.getPropertyChangeListeners();
    }
}

