/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;
import java.util.EventObject;
import javax.swing.CellEditor;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;

public abstract class AbstractCellEditor
implements CellEditor,
Serializable {
    private static final long serialVersionUID = -1048006551406220959L;
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = new ChangeEvent(this);

    public boolean isCellEditable(EventObject event) {
        return true;
    }

    public boolean shouldSelectCell(EventObject event) {
        return true;
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public void addCellEditorListener(CellEditorListener listener) {
        this.listenerList.add(CellEditorListener.class, listener);
    }

    public void removeCellEditorListener(CellEditorListener listener) {
        this.listenerList.remove(CellEditorListener.class, listener);
    }

    public CellEditorListener[] getCellEditorListeners() {
        return (CellEditorListener[])this.listenerList.getListeners(CellEditorListener.class);
    }

    protected void fireEditingStopped() {
        CellEditorListener[] listeners = this.getCellEditorListeners();
        int index = 0;
        while (index < listeners.length) {
            listeners[index].editingStopped(this.changeEvent);
            ++index;
        }
    }

    protected void fireEditingCanceled() {
        CellEditorListener[] listeners = this.getCellEditorListeners();
        int index = 0;
        while (index < listeners.length) {
            listeners[index].editingCanceled(this.changeEvent);
            ++index;
        }
    }
}

