/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import gnu.java.lang.CPStringBuilder;
import java.io.Serializable;
import javax.swing.text.TabStop;

public class TabSet
implements Serializable {
    private static final long serialVersionUID = 2367703481999080593L;
    TabStop[] tabs;

    public TabSet(TabStop[] t) {
        this.tabs = t != null ? (TabStop[])t.clone() : new TabStop[0];
    }

    public TabStop getTab(int i) {
        if (i < 0 || i >= this.tabs.length) {
            throw new IllegalArgumentException("Index out of bounds.");
        }
        return this.tabs[i];
    }

    public TabStop getTabAfter(float location) {
        int idx = this.getTabIndexAfter(location);
        if (idx == -1) {
            return null;
        }
        return this.tabs[idx];
    }

    public int getTabCount() {
        return this.tabs.length;
    }

    public int getTabIndex(TabStop tab) {
        int i = 0;
        while (i < this.tabs.length) {
            if (this.tabs[i] == tab) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getTabIndexAfter(float location) {
        int i = 0;
        while (i < this.tabs.length) {
            if (location <= this.tabs[i].getPosition()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TabSet)) {
            return false;
        }
        TabSet that = (TabSet)obj;
        int tabCount = this.getTabCount();
        if (tabCount != that.getTabCount()) {
            return false;
        }
        int i = 0;
        while (i < tabCount) {
            if (!this.getTab(i).equals(that.getTab(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int result = 193;
        int tabs = this.getTabCount();
        int i = 0;
        while (i < tabs) {
            TabStop t = this.getTab(i);
            if (t != null) {
                result = 37 * result + t.hashCode();
            }
            ++i;
        }
        return result;
    }

    public String toString() {
        CPStringBuilder sb = new CPStringBuilder();
        sb.append("[ ");
        int i = 0;
        while (i < this.tabs.length) {
            if (i != 0) {
                sb.append(" - ");
            }
            sb.append(this.tabs[i].toString());
            ++i;
        }
        sb.append(" ]");
        return sb.toString();
    }
}

