"""Generated message classes for sqladmin version v1beta4.

Creates and configures Cloud SQL instances, which provide fully-managed MySQL
databases.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import message_types as _message_types
from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding


package = 'sqladmin'


class AclEntry(_messages.Message):
  """An entry for an Access Control list.

  Fields:
    expirationTime: The time when this access control entry expires in RFC
      3339 format, for example 2012-11-15T16:19:00.094Z.
    kind: This is always sql#aclEntry.
    name: An optional label to identify this entry.
    value: The whitelisted value for the access control list.
  """

  expirationTime = _message_types.DateTimeField(1)
  kind = _messages.StringField(2, default=u'sql#aclEntry')
  name = _messages.StringField(3)
  value = _messages.StringField(4)


class BackupConfiguration(_messages.Message):
  """Database instance backup configuration.

  Fields:
    binaryLogEnabled: Whether binary log is enabled. If backup configuration
      is disabled, binary log must be disabled as well.
    enabled: Whether this configuration is enabled.
    kind: This is always sql#backupConfiguration.
    startTime: Start time for the daily backup configuration in UTC timezone
      in the 24 hour format - HH:MM.
  """

  binaryLogEnabled = _messages.BooleanField(1)
  enabled = _messages.BooleanField(2)
  kind = _messages.StringField(3, default=u'sql#backupConfiguration')
  startTime = _messages.StringField(4)


class BackupRun(_messages.Message):
  """A database instance backup run resource.

  Fields:
    description: The description of this run, only applicable to on-demand
      backups.
    endTime: The time the backup operation completed in UTC timezone in RFC
      3339 format, for example 2012-11-15T16:19:00.094Z.
    enqueuedTime: The time the run was enqueued in UTC timezone in RFC 3339
      format, for example 2012-11-15T16:19:00.094Z.
    error: Information about why the backup operation failed. This is only
      present if the run has the FAILED status.
    id: A unique identifier for this backup run. Note that this is unique only
      within the scope of a particular Cloud SQL instance.
    instance: Name of the database instance.
    kind: This is always sql#backupRun.
    selfLink: The URI of this resource.
    startTime: The time the backup operation actually started in UTC timezone
      in RFC 3339 format, for example 2012-11-15T16:19:00.094Z.
    status: The status of this run.
    type: The type of this run; can be either "AUTOMATED" or "ON_DEMAND".
    windowStartTime: The start time of the backup window during which this the
      backup was attempted in RFC 3339 format, for example
      2012-11-15T16:19:00.094Z.
  """

  description = _messages.StringField(1)
  endTime = _message_types.DateTimeField(2)
  enqueuedTime = _message_types.DateTimeField(3)
  error = _messages.MessageField('OperationError', 4)
  id = _messages.IntegerField(5)
  instance = _messages.StringField(6)
  kind = _messages.StringField(7, default=u'sql#backupRun')
  selfLink = _messages.StringField(8)
  startTime = _message_types.DateTimeField(9)
  status = _messages.StringField(10)
  type = _messages.StringField(11)
  windowStartTime = _message_types.DateTimeField(12)


class BackupRunsListResponse(_messages.Message):
  """Backup run list results.

  Fields:
    items: A list of backup runs in reverse chronological order of the
      enqueued time.
    kind: This is always sql#backupRunsList.
    nextPageToken: The continuation token, used to page through large result
      sets. Provide this value in a subsequent request to return the next page
      of results.
  """

  items = _messages.MessageField('BackupRun', 1, repeated=True)
  kind = _messages.StringField(2, default=u'sql#backupRunsList')
  nextPageToken = _messages.StringField(3)


class BinLogCoordinates(_messages.Message):
  """Binary log coordinates.

  Fields:
    binLogFileName: Name of the binary log file for a Cloud SQL instance.
    binLogPosition: Position (offset) within the binary log file.
    kind: This is always sql#binLogCoordinates.
  """

  binLogFileName = _messages.StringField(1)
  binLogPosition = _messages.IntegerField(2)
  kind = _messages.StringField(3, default=u'sql#binLogCoordinates')


class CloneContext(_messages.Message):
  """Database instance clone context.

  Fields:
    binLogCoordinates: Binary log coordinates, if specified, indentify the the
      position up to which the source instance should be cloned. If not
      specified, the source instance is cloned up to the most recent binary
      log coordintes.
    destinationInstanceName: Name of the Cloud SQL instance to be created as a
      clone.
    kind: This is always sql#cloneContext.
  """

  binLogCoordinates = _messages.MessageField('BinLogCoordinates', 1)
  destinationInstanceName = _messages.StringField(2)
  kind = _messages.StringField(3, default=u'sql#cloneContext')


class Database(_messages.Message):
  """A database resource inside a Cloud SQL instance.

  Fields:
    charset: The MySQL charset value.
    collation: The MySQL collation value.
    etag: HTTP 1.1 Entity tag for the resource.
    instance: The name of the Cloud SQL instance. This does not include the
      project ID.
    kind: This is always sql#database.
    name: The name of the database in the Cloud SQL instance. This does not
      include the project ID or instance name.
    project: The project ID of the project containing the Cloud SQL database.
      The Google apps domain is prefixed if applicable.
    selfLink: The URI of this resource.
  """

  charset = _messages.StringField(1)
  collation = _messages.StringField(2)
  etag = _messages.StringField(3)
  instance = _messages.StringField(4)
  kind = _messages.StringField(5, default=u'sql#database')
  name = _messages.StringField(6)
  project = _messages.StringField(7)
  selfLink = _messages.StringField(8)


class DatabaseFlags(_messages.Message):
  """MySQL flags for Cloud SQL instances.

  Fields:
    name: The name of the flag. These flags are passed at instance startup, so
      include both MySQL server options and MySQL system variables. Flags
      should be specified with underscores, not hyphens. For more information,
      see Configuring MySQL Flags in the Google Cloud SQL documentation, as
      well as the official MySQL documentation for server options and system
      variables.
    value: The value of the flag. Booleans should be set to on for true and
      off for false. This field must be omitted if the flag doesn't take a
      value.
  """

  name = _messages.StringField(1)
  value = _messages.StringField(2)


class DatabaseInstance(_messages.Message):
  """A Cloud SQL instance resource.

  Messages:
    FailoverReplicaValue: The name and status of the failover replica. This
      property is applicable only to Second Generation instances.

  Fields:
    backendType: FIRST_GEN: Basic Cloud SQL instance that runs in a Google-
      managed container. SECOND_GEN: A newer Cloud SQL backend that runs in a
      Compute Engine VM. EXTERNAL: A MySQL server that is not managed by
      Google.
    connectionName: Connection name of the Cloud SQL instance used in
      connection strings.
    currentDiskSize: The current disk usage of the instance in bytes. This
      property has been deprecated. Users should use the
      "cloudsql.googleapis.com/database/disk/bytes_used" metric in Cloud
      Monitoring API instead. Please see https://groups.google.com/d/msg
      /google-cloud-sql-announce/I_7-F9EBhT0/BtvFtdFeAgAJ for details.
    databaseVersion: The database engine type and version. The databaseVersion
      field can not be changed after instance creation. MySQL Second
      Generation instances: MYSQL_5_7 (default) or MYSQL_5_6. PostgreSQL
      instances: POSTGRES_9_6 MySQL First Generation instances: MYSQL_5_6
      (default) or MYSQL_5_5
    etag: HTTP 1.1 Entity tag for the resource.
    failoverReplica: The name and status of the failover replica. This
      property is applicable only to Second Generation instances.
    instanceType: The instance type. This can be one of the following.
      CLOUD_SQL_INSTANCE: A Cloud SQL instance that is not replicating from a
      master. ON_PREMISES_INSTANCE: An instance running on the customer's
      premises. READ_REPLICA_INSTANCE: A Cloud SQL instance configured as a
      read-replica.
    ipAddresses: The assigned IP addresses for the instance.
    ipv6Address: The IPv6 address assigned to the instance. This property is
      applicable only to First Generation instances.
    kind: This is always sql#instance.
    masterInstanceName: The name of the instance which will act as master in
      the replication setup.
    maxDiskSize: The maximum disk size of the instance in bytes.
    name: Name of the Cloud SQL instance. This does not include the project
      ID.
    onPremisesConfiguration: Configuration specific to on-premises instances.
    project: The project ID of the project containing the Cloud SQL instance.
      The Google apps domain is prefixed if applicable.
    region: The geographical region. Can be us-central (FIRST_GEN instances
      only), us-central1 (SECOND_GEN instances only), asia-east1 or europe-
      west1. Defaults to us-central or us-central1 depending on the instance
      type (First Generation or Second Generation). The region can not be
      changed after instance creation.
    replicaConfiguration: Configuration specific to read-replicas replicating
      from on-premises masters.
    replicaNames: The replicas of the instance.
    selfLink: The URI of this resource.
    serverCaCert: SSL configuration.
    serviceAccountEmailAddress: The service account email address assigned to
      the instance. This property is applicable only to Second Generation
      instances.
    settings: The user settings.
    state: The current serving state of the Cloud SQL instance. This can be
      one of the following. RUNNABLE: The instance is running, or is ready to
      run when accessed. SUSPENDED: The instance is not available, for example
      due to problems with billing. PENDING_CREATE: The instance is being
      created. MAINTENANCE: The instance is down for maintenance. FAILED: The
      instance creation failed. UNKNOWN_STATE: The state of the instance is
      unknown.
    suspensionReason: If the instance state is SUSPENDED, the reason for the
      suspension.
  """

  class FailoverReplicaValue(_messages.Message):
    """The name and status of the failover replica. This property is
    applicable only to Second Generation instances.

    Fields:
      available: The availability status of the failover replica. A false
        status indicates that the failover replica is out of sync. The master
        can only failover to the falover replica when the status is true.
      name: The name of the failover replica. If specified at instance
        creation, a failover replica is created for the instance. The name
        doesn't include the project ID. This property is applicable only to
        Second Generation instances.
    """

    available = _messages.BooleanField(1)
    name = _messages.StringField(2)

  backendType = _messages.StringField(1)
  connectionName = _messages.StringField(2)
  currentDiskSize = _messages.IntegerField(3)
  databaseVersion = _messages.StringField(4)
  etag = _messages.StringField(5)
  failoverReplica = _messages.MessageField('FailoverReplicaValue', 6)
  instanceType = _messages.StringField(7)
  ipAddresses = _messages.MessageField('IpMapping', 8, repeated=True)
  ipv6Address = _messages.StringField(9)
  kind = _messages.StringField(10, default=u'sql#instance')
  masterInstanceName = _messages.StringField(11)
  maxDiskSize = _messages.IntegerField(12)
  name = _messages.StringField(13)
  onPremisesConfiguration = _messages.MessageField('OnPremisesConfiguration', 14)
  project = _messages.StringField(15)
  region = _messages.StringField(16)
  replicaConfiguration = _messages.MessageField('ReplicaConfiguration', 17)
  replicaNames = _messages.StringField(18, repeated=True)
  selfLink = _messages.StringField(19)
  serverCaCert = _messages.MessageField('SslCert', 20)
  serviceAccountEmailAddress = _messages.StringField(21)
  settings = _messages.MessageField('Settings', 22)
  state = _messages.StringField(23)
  suspensionReason = _messages.StringField(24, repeated=True)


class DatabasesListResponse(_messages.Message):
  """Database list response.

  Fields:
    items: List of database resources in the instance.
    kind: This is always sql#databasesList.
  """

  items = _messages.MessageField('Database', 1, repeated=True)
  kind = _messages.StringField(2, default=u'sql#databasesList')


class ExportContext(_messages.Message):
  """Database instance export context.

  Messages:
    CsvExportOptionsValue: Options for exporting data as CSV.
    SqlExportOptionsValue: Options for exporting data as SQL statements.

  Fields:
    csvExportOptions: Options for exporting data as CSV.
    databases: Databases (for example, guestbook) from which the export is
      made. If fileType is SQL and no database is specified, all databases are
      exported. If fileType is CSV, you can optionally specify at most one
      database to export. If csvExportOptions.selectQuery also specifies the
      database, this field will be ignored.
    fileType: The file type for the specified uri. SQL: The file contains SQL
      statements. CSV: The file contains CSV data.
    kind: This is always sql#exportContext.
    sqlExportOptions: Options for exporting data as SQL statements.
    uri: The path to the file in Google Cloud Storage where the export will be
      stored. The URI is in the form gs://bucketName/fileName. If the file
      already exists, the operation fails. If fileType is SQL and the filename
      ends with .gz, the contents are compressed.
  """

  class CsvExportOptionsValue(_messages.Message):
    """Options for exporting data as CSV.

    Fields:
      selectQuery: The select query used to extract the data.
    """

    selectQuery = _messages.StringField(1)

  class SqlExportOptionsValue(_messages.Message):
    """Options for exporting data as SQL statements.

    Fields:
      schemaOnly: Export only schemas.
      tables: Tables to export, or that were exported, from the specified
        database. If you specify tables, specify one and only one database.
    """

    schemaOnly = _messages.BooleanField(1)
    tables = _messages.StringField(2, repeated=True)

  csvExportOptions = _messages.MessageField('CsvExportOptionsValue', 1)
  databases = _messages.StringField(2, repeated=True)
  fileType = _messages.StringField(3)
  kind = _messages.StringField(4, default=u'sql#exportContext')
  sqlExportOptions = _messages.MessageField('SqlExportOptionsValue', 5)
  uri = _messages.StringField(6)


class FailoverContext(_messages.Message):
  """Database instance failover context.

  Fields:
    kind: This is always sql#failoverContext.
    settingsVersion: The current settings version of this instance. Request
      will be rejected if this version doesn't match the current settings
      version.
  """

  kind = _messages.StringField(1, default=u'sql#failoverContext')
  settingsVersion = _messages.IntegerField(2)


class Flag(_messages.Message):
  """A Google Cloud SQL service flag resource.

  Fields:
    allowedStringValues: For STRING flags, a list of strings that the value
      can be set to.
    appliesTo: The database version this flag applies to. Can be MYSQL_5_5,
      MYSQL_5_6, or MYSQL_5_7. MYSQL_5_7 is applicable only to Second
      Generation instances.
    kind: This is always sql#flag.
    maxValue: For INTEGER flags, the maximum allowed value.
    minValue: For INTEGER flags, the minimum allowed value.
    name: This is the name of the flag. Flag names always use underscores, not
      hyphens, e.g. max_allowed_packet
    requiresRestart: Indicates whether changing this flag will trigger a
      database restart. Only applicable to Second Generation instances.
    type: The type of the flag. Flags are typed to being BOOLEAN, STRING,
      INTEGER or NONE. NONE is used for flags which do not take a value, such
      as skip_grant_tables.
  """

  allowedStringValues = _messages.StringField(1, repeated=True)
  appliesTo = _messages.StringField(2, repeated=True)
  kind = _messages.StringField(3, default=u'sql#flag')
  maxValue = _messages.IntegerField(4)
  minValue = _messages.IntegerField(5)
  name = _messages.StringField(6)
  requiresRestart = _messages.BooleanField(7)
  type = _messages.StringField(8)


class FlagsListResponse(_messages.Message):
  """Flags list response.

  Fields:
    items: List of flags.
    kind: This is always sql#flagsList.
  """

  items = _messages.MessageField('Flag', 1, repeated=True)
  kind = _messages.StringField(2, default=u'sql#flagsList')


class ImportContext(_messages.Message):
  """Database instance import context.

  Messages:
    CsvImportOptionsValue: Options for importing data as CSV.

  Fields:
    csvImportOptions: Options for importing data as CSV.
    database: The database (for example, guestbook) to which the import is
      made. If fileType is SQL and no database is specified, it is assumed
      that the database is specified in the file to be imported. If fileType
      is CSV, it must be specified.
    fileType: The file type for the specified uri. SQL: The file contains SQL
      statements. CSV: The file contains CSV data.
    importUser: The PostgreSQL user for this import operation. Defaults to
      cloudsqlsuperuser. Used only for PostgreSQL instances.
    kind: This is always sql#importContext.
    uri: A path to the file in Google Cloud Storage from which the import is
      made. The URI is in the form gs://bucketName/fileName. Compressed gzip
      files (.gz) are supported when fileType is SQL.
  """

  class CsvImportOptionsValue(_messages.Message):
    """Options for importing data as CSV.

    Fields:
      columns: The columns to which CSV data is imported. If not specified,
        all columns of the database table are loaded with CSV data.
      table: The table to which CSV data is imported.
    """

    columns = _messages.StringField(1, repeated=True)
    table = _messages.StringField(2)

  csvImportOptions = _messages.MessageField('CsvImportOptionsValue', 1)
  database = _messages.StringField(2)
  fileType = _messages.StringField(3)
  importUser = _messages.StringField(4)
  kind = _messages.StringField(5, default=u'sql#importContext')
  uri = _messages.StringField(6)


class InstancesCloneRequest(_messages.Message):
  """Database instance clone request.

  Fields:
    cloneContext: Contains details about the clone operation.
  """

  cloneContext = _messages.MessageField('CloneContext', 1)


class InstancesExportRequest(_messages.Message):
  """Database instance export request.

  Fields:
    exportContext: Contains details about the export operation.
  """

  exportContext = _messages.MessageField('ExportContext', 1)


class InstancesFailoverRequest(_messages.Message):
  """Instance failover request.

  Fields:
    failoverContext: Failover Context.
  """

  failoverContext = _messages.MessageField('FailoverContext', 1)


class InstancesImportRequest(_messages.Message):
  """Database instance import request.

  Fields:
    importContext: Contains details about the import operation.
  """

  importContext = _messages.MessageField('ImportContext', 1)


class InstancesListResponse(_messages.Message):
  """Database instances list response.

  Fields:
    items: List of database instance resources.
    kind: This is always sql#instancesList.
    nextPageToken: The continuation token, used to page through large result
      sets. Provide this value in a subsequent request to return the next page
      of results.
  """

  items = _messages.MessageField('DatabaseInstance', 1, repeated=True)
  kind = _messages.StringField(2, default=u'sql#instancesList')
  nextPageToken = _messages.StringField(3)


class InstancesRestoreBackupRequest(_messages.Message):
  """Database instance restore backup request.

  Fields:
    restoreBackupContext: Parameters required to perform the restore backup
      operation.
  """

  restoreBackupContext = _messages.MessageField('RestoreBackupContext', 1)


class InstancesTruncateLogRequest(_messages.Message):
  """Instance truncate log request.

  Fields:
    truncateLogContext: Contains details about the truncate log operation.
  """

  truncateLogContext = _messages.MessageField('TruncateLogContext', 1)


class IpConfiguration(_messages.Message):
  """IP Management configuration.

  Fields:
    authorizedNetworks: The list of external networks that are allowed to
      connect to the instance using the IP. In CIDR notation, also known as
      'slash' notation (e.g. 192.168.100.0/24).
    ipv4Enabled: Whether the instance should be assigned an IP address or not.
    requireSsl: Whether the mysqld should default to 'REQUIRE X509' for users
      connecting over IP.
  """

  authorizedNetworks = _messages.MessageField('AclEntry', 1, repeated=True)
  ipv4Enabled = _messages.BooleanField(2)
  requireSsl = _messages.BooleanField(3)


class IpMapping(_messages.Message):
  """Database instance IP Mapping.

  Fields:
    ipAddress: The IP address assigned.
    timeToRetire: The due time for this IP to be retired in RFC 3339 format,
      for example 2012-11-15T16:19:00.094Z. This field is only available when
      the IP is scheduled to be retired.
    type: The type of this IP address. A PRIMARY address is an address that
      can accept incoming connections. An OUTGOING address is the source
      address of connections originating from the instance, if supported.
  """

  ipAddress = _messages.StringField(1)
  timeToRetire = _message_types.DateTimeField(2)
  type = _messages.StringField(3)


class LocationPreference(_messages.Message):
  """Preferred location. This specifies where a Cloud SQL instance should
  preferably be located, either in a specific Compute Engine zone, or co-
  located with an App Engine application. Note that if the preferred location
  is not available, the instance will be located as close as possible within
  the region. Only one location may be specified.

  Fields:
    followGaeApplication: The AppEngine application to follow, it must be in
      the same region as the Cloud SQL instance.
    kind: This is always sql#locationPreference.
    zone: The preferred Compute Engine zone (e.g. us-centra1-a, us-central1-b,
      etc.).
  """

  followGaeApplication = _messages.StringField(1)
  kind = _messages.StringField(2, default=u'sql#locationPreference')
  zone = _messages.StringField(3)


class MaintenanceWindow(_messages.Message):
  """Maintenance window. This specifies when a v2 Cloud SQL instance should
  preferably be restarted for system maintenance puruposes.

  Fields:
    day: day of week (1-7), starting on Monday.
    hour: hour of day - 0 to 23.
    kind: This is always sql#maintenanceWindow.
    updateTrack: A string attribute.
  """

  day = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  hour = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  kind = _messages.StringField(3, default=u'sql#maintenanceWindow')
  updateTrack = _messages.StringField(4)


class MySqlReplicaConfiguration(_messages.Message):
  """Read-replica configuration specific to MySQL databases.

  Fields:
    caCertificate: PEM representation of the trusted CA's x509 certificate.
    clientCertificate: PEM representation of the slave's x509 certificate.
    clientKey: PEM representation of the slave's private key. The
      corresponsing public key is encoded in the client's certificate.
    connectRetryInterval: Seconds to wait between connect retries. MySQL's
      default is 60 seconds.
    dumpFilePath: Path to a SQL dump file in Google Cloud Storage from which
      the slave instance is to be created. The URI is in the form
      gs://bucketName/fileName. Compressed gzip files (.gz) are also
      supported. Dumps should have the binlog co-ordinates from which
      replication should begin. This can be accomplished by setting --master-
      data to 1 when using mysqldump.
    kind: This is always sql#mysqlReplicaConfiguration.
    masterHeartbeatPeriod: Interval in milliseconds between replication
      heartbeats.
    password: The password for the replication connection.
    sslCipher: A list of permissible ciphers to use for SSL encryption.
    username: The username for the replication connection.
    verifyServerCertificate: Whether or not to check the master's Common Name
      value in the certificate that it sends during the SSL handshake.
  """

  caCertificate = _messages.StringField(1)
  clientCertificate = _messages.StringField(2)
  clientKey = _messages.StringField(3)
  connectRetryInterval = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  dumpFilePath = _messages.StringField(5)
  kind = _messages.StringField(6, default=u'sql#mysqlReplicaConfiguration')
  masterHeartbeatPeriod = _messages.IntegerField(7)
  password = _messages.StringField(8)
  sslCipher = _messages.StringField(9)
  username = _messages.StringField(10)
  verifyServerCertificate = _messages.BooleanField(11)


class OnPremisesConfiguration(_messages.Message):
  """On-premises instance configuration.

  Fields:
    hostPort: The host and port of the on-premises instance in host:port
      format
    kind: This is always sql#onPremisesConfiguration.
  """

  hostPort = _messages.StringField(1)
  kind = _messages.StringField(2, default=u'sql#onPremisesConfiguration')


class Operation(_messages.Message):
  """An Operations resource contains information about database instance
  operations such as create, delete, and restart. Operations resources are
  created in response to operations that were initiated; you never create them
  directly.

  Fields:
    endTime: The time this operation finished in UTC timezone in RFC 3339
      format, for example 2012-11-15T16:19:00.094Z.
    error: If errors occurred during processing of this operation, this field
      will be populated.
    exportContext: The context for export operation, if applicable.
    importContext: The context for import operation, if applicable.
    insertTime: The time this operation was enqueued in UTC timezone in RFC
      3339 format, for example 2012-11-15T16:19:00.094Z.
    kind: This is always sql#operation.
    name: An identifier that uniquely identifies the operation. You can use
      this identifier to retrieve the Operations resource that has information
      about the operation.
    operationType: The type of the operation. Valid values are CREATE, DELETE,
      UPDATE, RESTART, IMPORT, EXPORT, BACKUP_VOLUME, RESTORE_VOLUME,
      CREATE_USER, DELETE_USER, CREATE_DATABASE, DELETE_DATABASE .
    selfLink: The URI of this resource.
    startTime: The time this operation actually started in UTC timezone in RFC
      3339 format, for example 2012-11-15T16:19:00.094Z.
    status: The status of an operation. Valid values are PENDING, RUNNING,
      DONE, UNKNOWN.
    targetId: Name of the database instance related to this operation.
    targetLink: A string attribute.
    targetProject: The project ID of the target instance related to this
      operation.
    user: The email address of the user who initiated this operation.
  """

  endTime = _message_types.DateTimeField(1)
  error = _messages.MessageField('OperationErrors', 2)
  exportContext = _messages.MessageField('ExportContext', 3)
  importContext = _messages.MessageField('ImportContext', 4)
  insertTime = _message_types.DateTimeField(5)
  kind = _messages.StringField(6, default=u'sql#operation')
  name = _messages.StringField(7)
  operationType = _messages.StringField(8)
  selfLink = _messages.StringField(9)
  startTime = _message_types.DateTimeField(10)
  status = _messages.StringField(11)
  targetId = _messages.StringField(12)
  targetLink = _messages.StringField(13)
  targetProject = _messages.StringField(14)
  user = _messages.StringField(15)


class OperationError(_messages.Message):
  """Database instance operation error.

  Fields:
    code: Identifies the specific error that occurred.
    kind: This is always sql#operationError.
    message: Additional information about the error encountered.
  """

  code = _messages.StringField(1)
  kind = _messages.StringField(2, default=u'sql#operationError')
  message = _messages.StringField(3)


class OperationErrors(_messages.Message):
  """Database instance operation errors list wrapper.

  Fields:
    errors: The list of errors encountered while processing this operation.
    kind: This is always sql#operationErrors.
  """

  errors = _messages.MessageField('OperationError', 1, repeated=True)
  kind = _messages.StringField(2, default=u'sql#operationErrors')


class OperationsListResponse(_messages.Message):
  """Database instance list operations response.

  Fields:
    items: List of operation resources.
    kind: This is always sql#operationsList.
    nextPageToken: The continuation token, used to page through large result
      sets. Provide this value in a subsequent request to return the next page
      of results.
  """

  items = _messages.MessageField('Operation', 1, repeated=True)
  kind = _messages.StringField(2, default=u'sql#operationsList')
  nextPageToken = _messages.StringField(3)


class ReplicaConfiguration(_messages.Message):
  """Read-replica configuration for connecting to the master.

  Fields:
    failoverTarget: Specifies if the replica is the failover target. If the
      field is set to true the replica will be designated as a failover
      replica. In case the master instance fails, the replica instance will be
      promoted as the new master instance. Only one replica can be specified
      as failover target, and the replica has to be in different zone with the
      master instance.
    kind: This is always sql#replicaConfiguration.
    mysqlReplicaConfiguration: MySQL specific configuration when replicating
      from a MySQL on-premises master. Replication configuration information
      such as the username, password, certificates, and keys are not stored in
      the instance metadata. The configuration information is used only to set
      up the replication connection and is stored by MySQL in a file named
      master.info in the data directory.
  """

  failoverTarget = _messages.BooleanField(1)
  kind = _messages.StringField(2, default=u'sql#replicaConfiguration')
  mysqlReplicaConfiguration = _messages.MessageField('MySqlReplicaConfiguration', 3)


class RestoreBackupContext(_messages.Message):
  """Database instance restore from backup context.

  Fields:
    backupRunId: The ID of the backup run to restore from.
    instanceId: The ID of the instance that the backup was taken from.
    kind: This is always sql#restoreBackupContext.
  """

  backupRunId = _messages.IntegerField(1)
  instanceId = _messages.StringField(2)
  kind = _messages.StringField(3, default=u'sql#restoreBackupContext')


class Settings(_messages.Message):
  """Database instance settings.

  Messages:
    UserLabelsValue: User-provided labels, represented as a dictionary where
      each label is a single key value pair.

  Fields:
    activationPolicy: The activation policy specifies when the instance is
      activated; it is applicable only when the instance state is RUNNABLE.
      The activation policy cannot be updated together with other settings for
      Second Generation instances. Valid values: ALWAYS: The instance is on;
      it is not deactivated by inactivity. NEVER: The instance is off; it is
      not activated, even if a connection request arrives. ON_DEMAND: The
      instance responds to incoming requests, and turns itself off when not in
      use. Instances with PER_USE pricing turn off after 15 minutes of
      inactivity. Instances with PER_PACKAGE pricing turn off after 12 hours
      of inactivity.
    authorizedGaeApplications: The App Engine app IDs that can access this
      instance. This property is only applicable to First Generation
      instances.
    availabilityType: Reserved for future use.
    backupConfiguration: The daily backup configuration for the instance.
    crashSafeReplicationEnabled: Configuration specific to read replica
      instances. Indicates whether database flags for crash-safe replication
      are enabled. This property is only applicable to First Generation
      instances.
    dataDiskSizeGb: The size of data disk, in GB. The data disk size minimum
      is 10GB. Applies only to Second Generation instances.
    dataDiskType: The type of data disk. Only supported for Second Generation
      instances. The default type is PD_SSD. Applies only to Second Generation
      instances.
    databaseFlags: The database flags passed to the instance at startup.
    databaseReplicationEnabled: Configuration specific to read replica
      instances. Indicates whether replication is enabled or not.
    ipConfiguration: The settings for IP Management. This allows to enable or
      disable the instance IP and manage which external networks can connect
      to the instance. The IPv4 address cannot be disabled for Second
      Generation instances.
    kind: This is always sql#settings.
    locationPreference: The location preference settings. This allows the
      instance to be located as near as possible to either an App Engine app
      or GCE zone for better performance. App Engine co-location is only
      applicable to First Generation instances.
    maintenanceWindow: The maintenance window for this instance. This
      specifies when the instance may be restarted for maintenance purposes.
      Applies only to Second Generation instances.
    pricingPlan: The pricing plan for this instance. This can be either
      PER_USE or PACKAGE. Only PER_USE is supported for Second Generation
      instances.
    replicationType: The type of replication this instance uses. This can be
      either ASYNCHRONOUS or SYNCHRONOUS. This property is only applicable to
      First Generation instances.
    settingsVersion: The version of instance settings. This is a required
      field for update method to make sure concurrent updates are handled
      properly. During update, use the most recent settingsVersion value for
      this instance and do not try to update this value.
    storageAutoResize: Configuration to increase storage size automatically.
      The default value is true. Applies only to Second Generation instances.
    storageAutoResizeLimit: The maximum size to which storage capacity can be
      automatically increased. The default value is 0, which specifies that
      there is no limit. Applies only to Second Generation instances.
    tier: The tier of service for this instance, for example D1, D2. For more
      information, see pricing.
    userLabels: User-provided labels, represented as a dictionary where each
      label is a single key value pair.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class UserLabelsValue(_messages.Message):
    """User-provided labels, represented as a dictionary where each label is a
    single key value pair.

    Messages:
      AdditionalProperty: An additional property for a UserLabelsValue object.

    Fields:
      additionalProperties: An individual label entry, composed of a key and a
        value.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a UserLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  activationPolicy = _messages.StringField(1)
  authorizedGaeApplications = _messages.StringField(2, repeated=True)
  availabilityType = _messages.StringField(3)
  backupConfiguration = _messages.MessageField('BackupConfiguration', 4)
  crashSafeReplicationEnabled = _messages.BooleanField(5)
  dataDiskSizeGb = _messages.IntegerField(6)
  dataDiskType = _messages.StringField(7)
  databaseFlags = _messages.MessageField('DatabaseFlags', 8, repeated=True)
  databaseReplicationEnabled = _messages.BooleanField(9)
  ipConfiguration = _messages.MessageField('IpConfiguration', 10)
  kind = _messages.StringField(11, default=u'sql#settings')
  locationPreference = _messages.MessageField('LocationPreference', 12)
  maintenanceWindow = _messages.MessageField('MaintenanceWindow', 13)
  pricingPlan = _messages.StringField(14)
  replicationType = _messages.StringField(15)
  settingsVersion = _messages.IntegerField(16)
  storageAutoResize = _messages.BooleanField(17)
  storageAutoResizeLimit = _messages.IntegerField(18)
  tier = _messages.StringField(19)
  userLabels = _messages.MessageField('UserLabelsValue', 20)


class SqlBackupRunsDeleteRequest(_messages.Message):
  """A SqlBackupRunsDeleteRequest object.

  Fields:
    id: The ID of the Backup Run to delete. To find a Backup Run ID, use the
      list method.
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  id = _messages.IntegerField(1, required=True)
  instance = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)


class SqlBackupRunsGetRequest(_messages.Message):
  """A SqlBackupRunsGetRequest object.

  Fields:
    id: The ID of this Backup Run.
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  id = _messages.IntegerField(1, required=True)
  instance = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)


class SqlBackupRunsInsertRequest(_messages.Message):
  """A SqlBackupRunsInsertRequest object.

  Fields:
    backupRun: A BackupRun resource to be passed as the request body.
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  backupRun = _messages.MessageField('BackupRun', 1)
  instance = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)


class SqlBackupRunsListRequest(_messages.Message):
  """A SqlBackupRunsListRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    maxResults: Maximum number of backup runs per response.
    pageToken: A previously-returned page token representing part of the
      larger set of results to view.
    project: Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  project = _messages.StringField(4, required=True)


class SqlDatabasesDeleteRequest(_messages.Message):
  """A SqlDatabasesDeleteRequest object.

  Fields:
    database: Name of the database to be deleted in the instance.
    instance: Database instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  database = _messages.StringField(1, required=True)
  instance = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)


class SqlDatabasesGetRequest(_messages.Message):
  """A SqlDatabasesGetRequest object.

  Fields:
    database: Name of the database in the instance.
    instance: Database instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  database = _messages.StringField(1, required=True)
  instance = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)


class SqlDatabasesListRequest(_messages.Message):
  """A SqlDatabasesListRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project for which to list Cloud SQL instances.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlDatabasesPatchRequest(_messages.Message):
  """A SqlDatabasesPatchRequest object.

  Fields:
    database: Name of the database to be updated in the instance.
    databaseResource: A Database resource to be passed as the request body.
    instance: Database instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  database = _messages.StringField(1, required=True)
  databaseResource = _messages.MessageField('Database', 2)
  instance = _messages.StringField(3, required=True)
  project = _messages.StringField(4, required=True)


class SqlDatabasesUpdateRequest(_messages.Message):
  """A SqlDatabasesUpdateRequest object.

  Fields:
    database: Name of the database to be updated in the instance.
    databaseResource: A Database resource to be passed as the request body.
    instance: Database instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  database = _messages.StringField(1, required=True)
  databaseResource = _messages.MessageField('Database', 2)
  instance = _messages.StringField(3, required=True)
  project = _messages.StringField(4, required=True)


class SqlFlagsListRequest(_messages.Message):
  """A SqlFlagsListRequest object.

  Fields:
    databaseVersion: Database version for flag retrieval. Flags are specific
      to the database version.
  """

  databaseVersion = _messages.StringField(1)


class SqlInstancesCloneRequest(_messages.Message):
  """A SqlInstancesCloneRequest object.

  Fields:
    instance: The ID of the Cloud SQL instance to be cloned (source). This
      does not include the project ID.
    instancesCloneRequest: A InstancesCloneRequest resource to be passed as
      the request body.
    project: Project ID of the source as well as the clone Cloud SQL instance.
  """

  instance = _messages.StringField(1, required=True)
  instancesCloneRequest = _messages.MessageField('InstancesCloneRequest', 2)
  project = _messages.StringField(3, required=True)


class SqlInstancesDeleteRequest(_messages.Message):
  """A SqlInstancesDeleteRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance to be
      deleted.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlInstancesExportRequest(_messages.Message):
  """A SqlInstancesExportRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    instancesExportRequest: A InstancesExportRequest resource to be passed as
      the request body.
    project: Project ID of the project that contains the instance to be
      exported.
  """

  instance = _messages.StringField(1, required=True)
  instancesExportRequest = _messages.MessageField('InstancesExportRequest', 2)
  project = _messages.StringField(3, required=True)


class SqlInstancesFailoverRequest(_messages.Message):
  """A SqlInstancesFailoverRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    instancesFailoverRequest: A InstancesFailoverRequest resource to be passed
      as the request body.
    project: ID of the project that contains the read replica.
  """

  instance = _messages.StringField(1, required=True)
  instancesFailoverRequest = _messages.MessageField('InstancesFailoverRequest', 2)
  project = _messages.StringField(3, required=True)


class SqlInstancesGetRequest(_messages.Message):
  """A SqlInstancesGetRequest object.

  Fields:
    instance: Database instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlInstancesImportRequest(_messages.Message):
  """A SqlInstancesImportRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    instancesImportRequest: A InstancesImportRequest resource to be passed as
      the request body.
    project: Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  instancesImportRequest = _messages.MessageField('InstancesImportRequest', 2)
  project = _messages.StringField(3, required=True)


class SqlInstancesListRequest(_messages.Message):
  """A SqlInstancesListRequest object.

  Fields:
    filter: An expression for filtering the results of the request, such as by
      name or label.
    maxResults: The maximum number of results to return per response.
    pageToken: A previously-returned page token representing part of the
      larger set of results to view.
    project: Project ID of the project for which to list Cloud SQL instances.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32)
  pageToken = _messages.StringField(3)
  project = _messages.StringField(4, required=True)


class SqlInstancesPatchRequest(_messages.Message):
  """A SqlInstancesPatchRequest object.

  Fields:
    databaseInstance: A DatabaseInstance resource to be passed as the request
      body.
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  databaseInstance = _messages.MessageField('DatabaseInstance', 1)
  instance = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)


class SqlInstancesPromoteReplicaRequest(_messages.Message):
  """A SqlInstancesPromoteReplicaRequest object.

  Fields:
    instance: Cloud SQL read replica instance name.
    project: ID of the project that contains the read replica.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlInstancesResetSslConfigRequest(_messages.Message):
  """A SqlInstancesResetSslConfigRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlInstancesRestartRequest(_messages.Message):
  """A SqlInstancesRestartRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance to be
      restarted.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlInstancesRestoreBackupRequest(_messages.Message):
  """A SqlInstancesRestoreBackupRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    instancesRestoreBackupRequest: A InstancesRestoreBackupRequest resource to
      be passed as the request body.
    project: Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  instancesRestoreBackupRequest = _messages.MessageField('InstancesRestoreBackupRequest', 2)
  project = _messages.StringField(3, required=True)


class SqlInstancesStartReplicaRequest(_messages.Message):
  """A SqlInstancesStartReplicaRequest object.

  Fields:
    instance: Cloud SQL read replica instance name.
    project: ID of the project that contains the read replica.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlInstancesStopReplicaRequest(_messages.Message):
  """A SqlInstancesStopReplicaRequest object.

  Fields:
    instance: Cloud SQL read replica instance name.
    project: ID of the project that contains the read replica.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlInstancesTruncateLogRequest(_messages.Message):
  """A SqlInstancesTruncateLogRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    instancesTruncateLogRequest: A InstancesTruncateLogRequest resource to be
      passed as the request body.
    project: Project ID of the Cloud SQL project.
  """

  instance = _messages.StringField(1, required=True)
  instancesTruncateLogRequest = _messages.MessageField('InstancesTruncateLogRequest', 2)
  project = _messages.StringField(3, required=True)


class SqlInstancesUpdateRequest(_messages.Message):
  """A SqlInstancesUpdateRequest object.

  Fields:
    databaseInstance: A DatabaseInstance resource to be passed as the request
      body.
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  databaseInstance = _messages.MessageField('DatabaseInstance', 1)
  instance = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)


class SqlOperationsGetRequest(_messages.Message):
  """A SqlOperationsGetRequest object.

  Fields:
    operation: Instance operation ID.
    project: Project ID of the project that contains the instance.
  """

  operation = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlOperationsListRequest(_messages.Message):
  """A SqlOperationsListRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    maxResults: Maximum number of operations per response.
    pageToken: A previously-returned page token representing part of the
      larger set of results to view.
    project: Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32)
  pageToken = _messages.StringField(3)
  project = _messages.StringField(4, required=True)


class SqlSslCertsCreateEphemeralRequest(_messages.Message):
  """A SqlSslCertsCreateEphemeralRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the Cloud SQL project.
    sslCertsCreateEphemeralRequest: A SslCertsCreateEphemeralRequest resource
      to be passed as the request body.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  sslCertsCreateEphemeralRequest = _messages.MessageField('SslCertsCreateEphemeralRequest', 3)


class SqlSslCertsDeleteRequest(_messages.Message):
  """A SqlSslCertsDeleteRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance to be
      deleted.
    sha1Fingerprint: Sha1 FingerPrint.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  sha1Fingerprint = _messages.StringField(3, required=True)


class SqlSslCertsGetRequest(_messages.Message):
  """A SqlSslCertsGetRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
    sha1Fingerprint: Sha1 FingerPrint.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  sha1Fingerprint = _messages.StringField(3, required=True)


class SqlSslCertsInsertRequest(_messages.Message):
  """A SqlSslCertsInsertRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project to which the newly created Cloud SQL
      instances should belong.
    sslCertsInsertRequest: A SslCertsInsertRequest resource to be passed as
      the request body.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  sslCertsInsertRequest = _messages.MessageField('SslCertsInsertRequest', 3)


class SqlSslCertsListRequest(_messages.Message):
  """A SqlSslCertsListRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project for which to list Cloud SQL instances.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlTiersListRequest(_messages.Message):
  """A SqlTiersListRequest object.

  Fields:
    project: Project ID of the project for which to list tiers.
  """

  project = _messages.StringField(1, required=True)


class SqlUsersDeleteRequest(_messages.Message):
  """A SqlUsersDeleteRequest object.

  Fields:
    host: Host of the user in the instance.
    instance: Database instance ID. This does not include the project ID.
    name: Name of the user in the instance.
    project: Project ID of the project that contains the instance.
  """

  host = _messages.StringField(1, required=True)
  instance = _messages.StringField(2, required=True)
  name = _messages.StringField(3, required=True)
  project = _messages.StringField(4, required=True)


class SqlUsersListRequest(_messages.Message):
  """A SqlUsersListRequest object.

  Fields:
    instance: Database instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlUsersUpdateRequest(_messages.Message):
  """A SqlUsersUpdateRequest object.

  Fields:
    host: Host of the user in the instance.
    instance: Database instance ID. This does not include the project ID.
    name: Name of the user in the instance.
    project: Project ID of the project that contains the instance.
    user: A User resource to be passed as the request body.
  """

  host = _messages.StringField(1, required=True)
  instance = _messages.StringField(2, required=True)
  name = _messages.StringField(3, required=True)
  project = _messages.StringField(4, required=True)
  user = _messages.MessageField('User', 5)


class SslCert(_messages.Message):
  """SslCerts Resource

  Fields:
    cert: PEM representation.
    certSerialNumber: Serial number, as extracted from the certificate.
    commonName: User supplied name. Constrained to [a-zA-Z.-_ ]+.
    createTime: The time when the certificate was created in RFC 3339 format,
      for example 2012-11-15T16:19:00.094Z
    expirationTime: The time when the certificate expires in RFC 3339 format,
      for example 2012-11-15T16:19:00.094Z.
    instance: Name of the database instance.
    kind: This is always sql#sslCert.
    selfLink: The URI of this resource.
    sha1Fingerprint: Sha1 Fingerprint.
  """

  cert = _messages.StringField(1)
  certSerialNumber = _messages.StringField(2)
  commonName = _messages.StringField(3)
  createTime = _message_types.DateTimeField(4)
  expirationTime = _message_types.DateTimeField(5)
  instance = _messages.StringField(6)
  kind = _messages.StringField(7, default=u'sql#sslCert')
  selfLink = _messages.StringField(8)
  sha1Fingerprint = _messages.StringField(9)


class SslCertDetail(_messages.Message):
  """SslCertDetail.

  Fields:
    certInfo: The public information about the cert.
    certPrivateKey: The private key for the client cert, in pem format. Keep
      private in order to protect your security.
  """

  certInfo = _messages.MessageField('SslCert', 1)
  certPrivateKey = _messages.StringField(2)


class SslCertsCreateEphemeralRequest(_messages.Message):
  """SslCerts create ephemeral certificate request.

  Fields:
    public_key: PEM encoded public key to include in the signed certificate.
  """

  public_key = _messages.StringField(1)


class SslCertsInsertRequest(_messages.Message):
  """SslCerts insert request.

  Fields:
    commonName: User supplied name. Must be a distinct name from the other
      certificates for this instance. New certificates will not be usable
      until the instance is restarted.
  """

  commonName = _messages.StringField(1)


class SslCertsInsertResponse(_messages.Message):
  """SslCert insert response.

  Fields:
    clientCert: The new client certificate and private key. The new
      certificate will not work until the instance is restarted for First
      Generation instances.
    kind: This is always sql#sslCertsInsert.
    operation: The operation to track the ssl certs insert request.
    serverCaCert: The server Certificate Authority's certificate. If this is
      missing you can force a new one to be generated by calling
      resetSslConfig method on instances resource.
  """

  clientCert = _messages.MessageField('SslCertDetail', 1)
  kind = _messages.StringField(2, default=u'sql#sslCertsInsert')
  operation = _messages.MessageField('Operation', 3)
  serverCaCert = _messages.MessageField('SslCert', 4)


class SslCertsListResponse(_messages.Message):
  """SslCerts list response.

  Fields:
    items: List of client certificates for the instance.
    kind: This is always sql#sslCertsList.
  """

  items = _messages.MessageField('SslCert', 1, repeated=True)
  kind = _messages.StringField(2, default=u'sql#sslCertsList')


class StandardQueryParameters(_messages.Message):
  """Query parameters accepted by all methods.

  Enums:
    AltValueValuesEnum: Data format for the response.

  Fields:
    alt: Data format for the response.
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters. Overrides userIp if both are provided.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    userIp: IP address of the site where the request originates. Use this if
      you want to enforce per-user limits.
  """

  class AltValueValuesEnum(_messages.Enum):
    """Data format for the response.

    Values:
      json: Responses with Content-Type of application/json
    """
    json = 0

  alt = _messages.EnumField('AltValueValuesEnum', 1, default=u'json')
  fields = _messages.StringField(2)
  key = _messages.StringField(3)
  oauth_token = _messages.StringField(4)
  prettyPrint = _messages.BooleanField(5, default=True)
  quotaUser = _messages.StringField(6)
  trace = _messages.StringField(7)
  userIp = _messages.StringField(8)


class Tier(_messages.Message):
  """A Google Cloud SQL service tier resource.

  Fields:
    DiskQuota: The maximum disk size of this tier in bytes.
    RAM: The maximum RAM usage of this tier in bytes.
    kind: This is always sql#tier.
    region: The applicable regions for this tier.
    tier: An identifier for the service tier, for example D1, D2 etc. For
      related information, see Pricing.
  """

  DiskQuota = _messages.IntegerField(1)
  RAM = _messages.IntegerField(2)
  kind = _messages.StringField(3, default=u'sql#tier')
  region = _messages.StringField(4, repeated=True)
  tier = _messages.StringField(5)


class TiersListResponse(_messages.Message):
  """Tiers list response.

  Fields:
    items: List of tiers.
    kind: This is always sql#tiersList.
  """

  items = _messages.MessageField('Tier', 1, repeated=True)
  kind = _messages.StringField(2, default=u'sql#tiersList')


class TruncateLogContext(_messages.Message):
  """Database Instance truncate log context.

  Fields:
    kind: This is always sql#truncateLogContext.
    logType: The type of log to truncate. Valid values are MYSQL_GENERAL_TABLE
      and MYSQL_SLOW_TABLE.
  """

  kind = _messages.StringField(1, default=u'sql#truncateLogContext')
  logType = _messages.StringField(2)


class User(_messages.Message):
  """A Cloud SQL user resource.

  Fields:
    etag: HTTP 1.1 Entity tag for the resource.
    host: The host name from which the user can connect. For insert
      operations, host defaults to an empty string. For update operations,
      host is specified as part of the request URL. The host name cannot be
      updated after insertion.
    instance: The name of the Cloud SQL instance. This does not include the
      project ID. Can be omitted for update since it is already specified on
      the URL.
    kind: This is always sql#user.
    name: The name of the user in the Cloud SQL instance. Can be omitted for
      update since it is already specified on the URL.
    password: The password for the user.
    project: The project ID of the project containing the Cloud SQL database.
      The Google apps domain is prefixed if applicable. Can be omitted for
      update since it is already specified on the URL.
  """

  etag = _messages.StringField(1)
  host = _messages.StringField(2)
  instance = _messages.StringField(3)
  kind = _messages.StringField(4, default=u'sql#user')
  name = _messages.StringField(5)
  password = _messages.StringField(6)
  project = _messages.StringField(7)


class UsersListResponse(_messages.Message):
  """User list response.

  Fields:
    items: List of user resources in the instance.
    kind: This is always sql#usersList.
    nextPageToken: An identifier that uniquely identifies the operation. You
      can use this identifier to retrieve the Operations resource that has
      information about the operation.
  """

  items = _messages.MessageField('User', 1, repeated=True)
  kind = _messages.StringField(2, default=u'sql#usersList')
  nextPageToken = _messages.StringField(3)


