/*
 * Decompiled with CFR 0.152.
 */
package com.jrjackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jrjackson.JrJacksonBase;
import com.jrjackson.JrParse;
import com.jrjackson.RubyBigDecimalValueConverter;
import com.jrjackson.RubyBigIntValueConverter;
import com.jrjackson.RubyConverter;
import com.jrjackson.RubyFloatValueConverter;
import com.jrjackson.RubyHandler;
import com.jrjackson.RubyIntValueConverter;
import com.jrjackson.RubyJacksonModule;
import com.jrjackson.RubyNameConverter;
import com.jrjackson.RubyStringNameConverter;
import com.jrjackson.RubySymbolNameConverter;
import com.jrjackson.RubyUtils;
import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyModule(name={"JrJacksonRuby"})
public class JrJacksonRuby
extends JrJacksonBase {
    public JrJacksonRuby(Ruby ruby, RubyClass metaclass) {
        super(ruby, metaclass);
    }

    @JRubyMethod(module=true, name={"parse_sym", "load_sym"}, required=2)
    public static Object parse_sym(ThreadContext context, IRubyObject self, IRubyObject arg, IRubyObject opts) throws JsonProcessingException, IOException, RaiseException {
        return JrJacksonRuby.__parse(context, arg, new RubySymbolNameConverter(), new RubyBigIntValueConverter(), new RubyBigDecimalValueConverter());
    }

    @JRubyMethod(module=true, name={"parse", "load"}, required=2)
    public static Object parse(ThreadContext context, IRubyObject self, IRubyObject arg, IRubyObject opts) throws JsonProcessingException, IOException, RaiseException {
        RubyHash options;
        RubyNameConverter konv = new RubyStringNameConverter();
        RubyConverter ikonv = new RubyBigIntValueConverter();
        RubyConverter dkonv = new RubyBigDecimalValueConverter();
        if (opts != context.nil && (options = opts.convertToHash()).size() > 0) {
            if (JrJacksonRuby.flagged(options, RubyUtils.rubySymbol(context.runtime, "symbolize_keys"))) {
                konv = new RubySymbolNameConverter();
            }
            if (!JrJacksonRuby.flagged(options, RubyUtils.rubySymbol(context.runtime, "use_bigdecimal"), true)) {
                dkonv = new RubyFloatValueConverter();
            }
            if (JrJacksonRuby.flagged(options, RubyUtils.rubySymbol(context.runtime, "use_smallint"))) {
                ikonv = new RubyIntValueConverter();
            }
        }
        return JrJacksonRuby.__parse(context, arg, konv, ikonv, dkonv);
    }

    private static Object __parse(ThreadContext context, IRubyObject arg, RubyNameConverter keykonv, RubyConverter intconv, RubyConverter decimalconv) throws JsonProcessingException, IOException, RaiseException {
        JsonParser jp;
        RubyHandler handler = new RubyHandler(context, keykonv, intconv, decimalconv);
        JrParse parse = new JrParse(handler);
        ObjectMapper mapper = RubyJacksonModule.rawBigNumberMapper();
        JsonFactory jf = mapper.getFactory().disable(JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW);
        try {
            jp = JrJacksonRuby.buildParser(context, jf, arg);
        }
        catch (IOException e) {
            throw context.runtime.newIOError(e.getLocalizedMessage());
        }
        parse.deserialize(jp);
        jp.close();
        return handler.getResult();
    }
}

