/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * sign(-1.5) => -1.0
 * sign(-0.75) => -1.0
 * sign(0.0) => 0.0
 * sign(0.75) => 1.0
 * sign(1.5) => 1.0
 */
#version 120

void main()
{
  float[distance(sign(-1.5), -1.0) <= 9.9999997e-06 ? 1 : -1] array0;
  float[distance(sign(-0.75), -1.0) <= 9.9999997e-06 ? 1 : -1] array1;
  float[distance(sign(0.0), 0.0) <= 0.0 ? 1 : -1] array2;
  float[distance(sign(0.75), 1.0) <= 9.9999997e-06 ? 1 : -1] array3;
  float[distance(sign(1.5), 1.0) <= 9.9999997e-06 ? 1 : -1] array4;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length());
}
