/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * mod(vec2(-1.9, -1.9), vec2(-2.0, -0.66666669)) => vec2(-1.9, -0.5666666)
 * mod(vec2(-1.9, -1.9), vec2(0.66666669, 2.0)) => vec2(0.10000008, 0.10000002)
 * mod(vec2(-0.63333333, -0.63333333), vec2(-2.0, -0.66666669)) => vec2(-0.63333333, -0.63333333)
 * mod(vec2(-0.63333333, -0.63333333), vec2(0.66666669, 2.0)) => vec2(0.033333361, 1.3666667)
 * mod(vec2(0.63333333, 0.63333333), vec2(-2.0, -0.66666669)) => vec2(-1.3666667, -0.033333361)
 * mod(vec2(0.63333333, 0.63333333), vec2(0.66666669, 2.0)) => vec2(0.63333333, 0.63333333)
 * mod(vec2(1.9, 1.9), vec2(-2.0, -0.66666669)) => vec2(-0.10000002, -0.10000008)
 * mod(vec2(1.9, 1.9), vec2(0.66666669, 2.0)) => vec2(0.5666666, 1.9)
 */
#version 150

void main()
{
  float[distance(mod(vec2(-1.9, -1.9), vec2(-2.0, -0.66666669)), vec2(-1.9, -0.5666666)) <= 1.9827028e-05 ? 1 : -1] array0;
  float[distance(mod(vec2(-1.9, -1.9), vec2(0.66666669, 2.0)), vec2(0.10000008, 0.10000002)) <= 1.4142144e-06 ? 1 : -1] array1;
  float[distance(mod(vec2(-0.63333333, -0.63333333), vec2(-2.0, -0.66666669)), vec2(-0.63333333, -0.63333333)) <= 8.9566856e-06 ? 1 : -1] array2;
  float[distance(mod(vec2(-0.63333333, -0.63333333), vec2(0.66666669, 2.0)), vec2(0.033333361, 1.3666667)) <= 1.367073e-05 ? 1 : -1] array3;
  float[distance(mod(vec2(0.63333333, 0.63333333), vec2(-2.0, -0.66666669)), vec2(-1.3666667, -0.033333361)) <= 1.367073e-05 ? 1 : -1] array4;
  float[distance(mod(vec2(0.63333333, 0.63333333), vec2(0.66666669, 2.0)), vec2(0.63333333, 0.63333333)) <= 8.9566856e-06 ? 1 : -1] array5;
  float[distance(mod(vec2(1.9, 1.9), vec2(-2.0, -0.66666669)), vec2(-0.10000002, -0.10000008)) <= 1.4142144e-06 ? 1 : -1] array6;
  float[distance(mod(vec2(1.9, 1.9), vec2(0.66666669, 2.0)), vec2(0.5666666, 1.9)) <= 1.9827028e-05 ? 1 : -1] array7;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
