/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionToolProvider;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionEP;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolsRegistrarCore;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.impl.ComponentManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class InspectionToolRegistrar
implements Supplier<List<InspectionToolWrapper>> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.InspectionToolRegistrar");
    private final List<Supplier<InspectionToolWrapper>> myInspectionToolFactories = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myInspectionComponentsLoaded;

    private synchronized void ensureInitialized() {
        if (this.myInspectionComponentsLoaded) {
            return;
        }
        this.myInspectionComponentsLoaded = true;
        THashSet providers = new THashSet();
        providers.addAll(((ComponentManagerImpl)ApplicationManager.getApplication()).getComponentInstancesOfType(InspectionToolProvider.class));
        ContainerUtil.addAll((Collection)providers, (Object[])InspectionToolProvider.EXTENSION_POINT_NAME.getExtensions());
        ArrayList<Supplier<InspectionToolWrapper>> factories = new ArrayList<Supplier<InspectionToolWrapper>>();
        InspectionToolRegistrar.registerTools((Collection<InspectionToolProvider>)providers, factories);
        boolean isInternal = ApplicationManager.getApplication().isInternal();
        THashMap shortNames = new THashMap();
        for (LocalInspectionEP localInspectionEP : (LocalInspectionEP[])LocalInspectionEP.LOCAL_INSPECTION.getExtensions()) {
            InspectionToolRegistrar.checkForDuplicateShortName((InspectionEP)localInspectionEP, (Map<String, InspectionEP>)shortNames);
            if (!isInternal && localInspectionEP.isInternal) continue;
            factories.add(() -> new LocalInspectionToolWrapper(ep));
        }
        for (LocalInspectionEP localInspectionEP : (InspectionEP[])InspectionEP.GLOBAL_INSPECTION.getExtensions()) {
            InspectionToolRegistrar.checkForDuplicateShortName((InspectionEP)localInspectionEP, (Map<String, InspectionEP>)shortNames);
            if (!isInternal && localInspectionEP.isInternal) continue;
            factories.add(() -> InspectionToolRegistrar.lambda$ensureInitialized$1((InspectionEP)localInspectionEP));
        }
        this.myInspectionToolFactories.addAll(factories);
    }

    private static void checkForDuplicateShortName(InspectionEP ep, Map<String, InspectionEP> shortNames) {
        String shortName = ep.getShortName();
        InspectionEP duplicate = shortNames.put(shortName, ep);
        if (duplicate != null) {
            PluginDescriptor descriptor2 = ep.getPluginDescriptor();
            LOG.error((Throwable)new PluginException("Short name '" + shortName + "' is not unique\nclass '" + ep.instantiateTool().getClass().getCanonicalName() + "' in " + descriptor2 + "\nand\nclass'" + duplicate.instantiateTool().getClass().getCanonicalName() + "' in " + duplicate.getPluginDescriptor() + "\nconflict", descriptor2.getPluginId()));
        }
    }

    @NotNull
    public static InspectionToolWrapper wrapTool(@NotNull InspectionProfileEntry profileEntry) {
        if (profileEntry == null) {
            InspectionToolRegistrar.$$$reportNull$$$0(0);
        }
        if (profileEntry instanceof LocalInspectionTool) {
            LocalInspectionToolWrapper localInspectionToolWrapper = new LocalInspectionToolWrapper((LocalInspectionTool)profileEntry);
            if (localInspectionToolWrapper == null) {
                InspectionToolRegistrar.$$$reportNull$$$0(1);
            }
            return localInspectionToolWrapper;
        }
        if (profileEntry instanceof GlobalInspectionTool) {
            GlobalInspectionToolWrapper globalInspectionToolWrapper = new GlobalInspectionToolWrapper((GlobalInspectionTool)profileEntry);
            if (globalInspectionToolWrapper == null) {
                InspectionToolRegistrar.$$$reportNull$$$0(2);
            }
            return globalInspectionToolWrapper;
        }
        throw new RuntimeException("unknown inspection class: " + profileEntry + "; " + profileEntry.getClass());
    }

    private static void registerTools(@NotNull Collection<InspectionToolProvider> providers, @NotNull List<Supplier<InspectionToolWrapper>> factories) {
        if (providers == null) {
            InspectionToolRegistrar.$$$reportNull$$$0(3);
        }
        if (factories == null) {
            InspectionToolRegistrar.$$$reportNull$$$0(4);
        }
        for (InspectionToolProvider provider : providers) {
            for (Class aClass : provider.getInspectionClasses()) {
                factories.add(() -> {
                    InspectionProfileEntry entry = (InspectionProfileEntry)InspectionToolsRegistrarCore.instantiateTool((Class)aClass);
                    return entry == null ? null : InspectionToolRegistrar.wrapTool(entry);
                });
            }
        }
    }

    public static InspectionToolRegistrar getInstance() {
        return (InspectionToolRegistrar)ServiceManager.getService(InspectionToolRegistrar.class);
    }

    @Override
    @NotNull
    public List<InspectionToolWrapper> get() {
        List<InspectionToolWrapper> list2 = this.createTools();
        if (list2 == null) {
            InspectionToolRegistrar.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @NotNull
    public List<InspectionToolWrapper> createTools() {
        this.ensureInitialized();
        ArrayList<InspectionToolWrapper> tools = new ArrayList<InspectionToolWrapper>(this.myInspectionToolFactories.size());
        for (Supplier<InspectionToolWrapper> factory : this.myInspectionToolFactories) {
            ProgressManager.checkCanceled();
            InspectionToolWrapper toolWrapper = factory.get();
            if (toolWrapper == null || InspectionToolRegistrar.checkTool(toolWrapper) != null) continue;
            tools.add(toolWrapper);
        }
        ArrayList<InspectionToolWrapper> arrayList = tools;
        if (arrayList == null) {
            InspectionToolRegistrar.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static String checkTool(@NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            InspectionToolRegistrar.$$$reportNull$$$0(7);
        }
        if (!(toolWrapper instanceof LocalInspectionToolWrapper)) {
            return null;
        }
        String message = null;
        try {
            String id = toolWrapper.getID();
            if (id == null || !LocalInspectionTool.isValidID((String)id)) {
                message = InspectionsBundle.message((String)"inspection.disabled.wrong.id", (Object[])new Object[]{toolWrapper.getShortName(), id, "[a-zA-Z_0-9.-]+"});
            }
        }
        catch (Throwable t) {
            message = InspectionsBundle.message((String)"inspection.disabled.error", (Object[])new Object[]{toolWrapper.getShortName(), t.getMessage()});
        }
        if (message != null) {
            LOG.error(message);
        }
        return message;
    }

    private static /* synthetic */ InspectionToolWrapper lambda$ensureInitialized$1(InspectionEP ep) {
        return new GlobalInspectionToolWrapper(ep);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileEntry";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/InspectionToolRegistrar";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factories";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/InspectionToolRegistrar";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapTool";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTools";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrapTool";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerTools";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkTool";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

