/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.IncorrectOperationException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class RemoveExtraClosingTagIntentionAction
implements LocalQuickFix,
IntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = XmlErrorMessages.message("remove.extra.closing.tag.quickfix", new Object[0]);
        if (string == null) {
            RemoveExtraClosingTagIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getName();
        if (string == null) {
            RemoveExtraClosingTagIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        PsiElement psiElement;
        if (project == null) {
            RemoveExtraClosingTagIntentionAction.$$$reportNull$$$0(2);
        }
        return (psiElement = file2.findElementAt(editor.getCaretModel().getOffset())) instanceof XmlToken && (psiElement.getParent() instanceof XmlTag || psiElement.getParent() instanceof PsiErrorElement);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            RemoveExtraClosingTagIntentionAction.$$$reportNull$$$0(3);
        }
        RemoveExtraClosingTagIntentionAction.doFix(Objects.requireNonNull(file2.findElementAt(editor.getCaretModel().getOffset())).getParent());
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static void doFix(@NotNull PsiElement tagElement) throws IncorrectOperationException {
        if (tagElement == null) {
            RemoveExtraClosingTagIntentionAction.$$$reportNull$$$0(4);
        }
        if (tagElement instanceof PsiErrorElement) {
            tagElement.delete();
        } else {
            Document document;
            ASTNode endTagStart;
            ASTNode astNode = tagElement.getNode();
            if (astNode != null && (endTagStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(astNode)) != null && (document = PsiDocumentManager.getInstance((Project)tagElement.getProject()).getDocument(tagElement.getContainingFile())) != null) {
                document.deleteString(endTagStart.getStartOffset(), tagElement.getLastChild().getTextRange().getEndOffset());
            }
        }
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiElement element;
        if (project == null) {
            RemoveExtraClosingTagIntentionAction.$$$reportNull$$$0(5);
        }
        if (descriptor2 == null) {
            RemoveExtraClosingTagIntentionAction.$$$reportNull$$$0(6);
        }
        if (!((element = descriptor2.getPsiElement()) instanceof XmlToken)) {
            return;
        }
        RemoveExtraClosingTagIntentionAction.doFix(element.getParent());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/htmlInspections/RemoveExtraClosingTagIntentionAction";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/htmlInspections/RemoveExtraClosingTagIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

