/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GroupedLogMessage
extends AbstractMessage {
    private final List<AbstractMessage> myMessages;

    public GroupedLogMessage(List<AbstractMessage> messages) {
        this.myMessages = messages;
    }

    public List<AbstractMessage> getMessages() {
        return this.myMessages;
    }

    @Override
    public String getThrowableText() {
        StringBuilder result2 = new StringBuilder();
        for (AbstractMessage each : this.myMessages) {
            result2.append(each.getThrowableText()).append("\n\n\n");
        }
        return result2.toString();
    }

    @Override
    public void setRead(boolean aReadFlag) {
        for (AbstractMessage message : this.myMessages) {
            message.setRead(aReadFlag);
        }
        super.setRead(aReadFlag);
    }

    @Override
    public Throwable getThrowable() {
        return this.myMessages.get(0).getThrowable();
    }

    @Override
    public String getMessage() {
        return this.myMessages.get(0).getMessage();
    }

    @Override
    public void setAssigneeId(Integer assigneeId) {
        for (AbstractMessage message : this.myMessages) {
            message.setAssigneeId(assigneeId);
        }
        super.setAssigneeId(assigneeId);
    }

    @Override
    @NotNull
    public List<Attachment> getAllAttachments() {
        List list2 = ContainerUtil.concat(this.getMessages(), message -> message.getAllAttachments());
        if (list2 == null) {
            GroupedLogMessage.$$$reportNull$$$0(0);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/GroupedLogMessage", "getAllAttachments"));
    }
}

