/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.scratch.ScratchesNamedScope;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.ChangeListsScopesProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.scope.ProjectFilesScope;
import com.intellij.psi.search.scope.ProjectProductionScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopeChooserUtils {
    private static final String CURRENT_FILE_SCOPE_NAME = IdeBundle.message((String)"scope.current.file", (Object[])new Object[0]);
    private static final String OPEN_FILES_SCOPE_NAME = IdeBundle.message((String)"scope.open.files", (Object[])new Object[0]);

    private ScopeChooserUtils() {
    }

    @NotNull
    public static GlobalSearchScope findScopeByName(@NotNull Project project, @Nullable String scopeName) {
        NamedScope namedScope;
        if (project == null) {
            ScopeChooserUtils.$$$reportNull$$$0(0);
        }
        NamedScope namedScope2 = namedScope = scopeName == null ? null : ChangeListsScopesProvider.getInstance(project).getCustomScope(scopeName);
        if (namedScope == null) {
            namedScope = NamedScopesHolder.getScope((Project)project, (String)scopeName);
        }
        if (namedScope == null && OPEN_FILES_SCOPE_NAME.equals(scopeName)) {
            GlobalSearchScope globalSearchScope = ScopeChooserUtils.intersectWithContentScope(project, GlobalSearchScopes.openFilesScope((Project)project));
            if (globalSearchScope == null) {
                ScopeChooserUtils.$$$reportNull$$$0(1);
            }
            return globalSearchScope;
        }
        if (namedScope == null && CURRENT_FILE_SCOPE_NAME.equals(scopeName)) {
            Object[] array = FileEditorManager.getInstance((Project)project).getSelectedFiles();
            List files = ContainerUtil.createMaybeSingletonList((Object)ArrayUtil.getFirstElement((Object[])array));
            GlobalSearchScope scope = GlobalSearchScope.filesScope((Project)project, (Collection)files, (String)CURRENT_FILE_SCOPE_NAME);
            GlobalSearchScope globalSearchScope = ScopeChooserUtils.intersectWithContentScope(project, scope);
            if (globalSearchScope == null) {
                ScopeChooserUtils.$$$reportNull$$$0(2);
            }
            return globalSearchScope;
        }
        if (namedScope == null) {
            namedScope = new ProjectFilesScope();
        }
        GlobalSearchScope scope = GlobalSearchScopesCore.filterScope((Project)project, (NamedScope)namedScope);
        if (namedScope instanceof ProjectFilesScope || namedScope instanceof ProjectProductionScope || namedScope instanceof ScratchesNamedScope) {
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                ScopeChooserUtils.$$$reportNull$$$0(3);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = ScopeChooserUtils.intersectWithContentScope(project, scope);
        if (globalSearchScope == null) {
            ScopeChooserUtils.$$$reportNull$$$0(4);
        }
        return globalSearchScope;
    }

    @NotNull
    private static GlobalSearchScope intersectWithContentScope(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            ScopeChooserUtils.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            ScopeChooserUtils.$$$reportNull$$$0(6);
        }
        GlobalSearchScope globalSearchScope = scope.intersectWith(ProjectScope.getContentScope((Project)project));
        if (globalSearchScope == null) {
            ScopeChooserUtils.$$$reportNull$$$0(7);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/scopeChooser/ScopeChooserUtils";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/scopeChooser/ScopeChooserUtils";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findScopeByName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectWithContentScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findScopeByName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "intersectWithContentScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

