/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.codeinsight;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class JsonCompletionContributor
extends CompletionContributor {
    private static final PsiElementPattern.Capture<PsiElement> AFTER_COLON_IN_PROPERTY = (PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf(new String[]{":"})).withSuperParent(2, JsonProperty.class)).andNot((ElementPattern)PlatformPatterns.psiElement().withParent(JsonStringLiteral.class));
    private static final PsiElementPattern.Capture<PsiElement> AFTER_COMMA_OR_BRACKET_IN_ARRAY = (PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf(new String[]{"[", ","})).withSuperParent(2, JsonArray.class)).andNot((ElementPattern)PlatformPatterns.psiElement().withParent(JsonStringLiteral.class));

    public JsonCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)AFTER_COLON_IN_PROPERTY, MyKeywordsCompletionProvider.INSTANCE);
        this.extend(CompletionType.BASIC, (ElementPattern)AFTER_COMMA_OR_BRACKET_IN_ARRAY, MyKeywordsCompletionProvider.INSTANCE);
    }

    private static class MyKeywordsCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private static final MyKeywordsCompletionProvider INSTANCE = new MyKeywordsCompletionProvider();
        private static final String[] KEYWORDS = new String[]{"null", "true", "false"};

        private MyKeywordsCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result2) {
            if (parameters == null) {
                MyKeywordsCompletionProvider.$$$reportNull$$$0(0);
            }
            if (result2 == null) {
                MyKeywordsCompletionProvider.$$$reportNull$$$0(1);
            }
            for (String keyword : KEYWORDS) {
                result2.addElement((LookupElement)LookupElementBuilder.create((String)keyword).bold());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/json/codeinsight/JsonCompletionContributor$MyKeywordsCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

