/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.codeinsight;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.json.JsonBundle;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JsonDuplicatePropertyKeysInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = JsonBundle.message("inspection.duplicate.keys.name", new Object[0]);
        if (string == null) {
            JsonDuplicatePropertyKeysInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            JsonDuplicatePropertyKeysInspection.$$$reportNull$$$0(1);
        }
        JsonElementVisitor jsonElementVisitor = new JsonElementVisitor(){

            @Override
            public void visitObject(@NotNull JsonObject o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                MultiMap keys = new MultiMap();
                for (JsonProperty property : o.getPropertyList()) {
                    keys.putValue((Object)property.getName(), (Object)property.getNameElement());
                }
                for (Map.Entry entry : keys.entrySet()) {
                    Collection sameNamedKeys = (Collection)entry.getValue();
                    if (sameNamedKeys.size() <= 1) continue;
                    for (PsiElement element : sameNamedKeys) {
                        holder.registerProblem(element, JsonBundle.message("inspection.duplicate.keys.msg.duplicate.keys", entry.getKey()), new LocalQuickFix[0]);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/json/codeinsight/JsonDuplicatePropertyKeysInspection$1", "visitObject"));
            }
        };
        if (jsonElementVisitor == null) {
            JsonDuplicatePropertyKeysInspection.$$$reportNull$$$0(2);
        }
        return jsonElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/codeinsight/JsonDuplicatePropertyKeysInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/codeinsight/JsonDuplicatePropertyKeysInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

