/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.registry.Registry;

public class RegistryValueCommand
extends AbstractCommand {
    public static final String PREFIX = "%set";

    public RegistryValueCommand(String text, int line) {
        super(text, line);
    }

    @Override
    protected ActionCallback _execute(PlaybackContext context) {
        String[] keyValue = this.getText().substring(PREFIX.length()).trim().split("=");
        if (keyValue.length != 2) {
            context.error("Expected expresstion: %set key=value", this.getLine());
            return ActionCallback.REJECTED;
        }
        String key = keyValue[0];
        String value = keyValue[1];
        context.storeRegistryValue(key);
        Registry.get((String)key).setValue(value);
        return ActionCallback.DONE;
    }
}

