/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkout;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.checkout.CheckoutListener;
import com.intellij.openapi.vcs.checkout.VcsAwareCheckoutListener;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeCheckoutListener
implements CheckoutProvider.Listener {
    private final Project myProject;
    private boolean myFoundProject = false;
    private File myFirstDirectory;
    private VcsKey myVcsKey;

    public CompositeCheckoutListener(Project project) {
        this.myProject = project;
    }

    public void directoryCheckedOut(File directory2, VcsKey vcs) {
        this.myVcsKey = vcs;
        if (!this.myFoundProject && directory2.isDirectory()) {
            if (this.myFirstDirectory == null) {
                this.myFirstDirectory = directory2;
            }
            this.notifyCheckoutListeners(directory2, false);
        }
    }

    private void notifyCheckoutListeners(File directory2, boolean checkoutCompleted) {
        Project project;
        CheckoutListener[] listeners;
        ExtensionPointName epName = checkoutCompleted ? CheckoutListener.COMPLETED_EP_NAME : CheckoutListener.EP_NAME;
        for (CheckoutListener listener2 : listeners = (CheckoutListener[])Extensions.getExtensions((ExtensionPointName)epName)) {
            this.myFoundProject = listener2.processCheckedOutDirectory(this.myProject, directory2);
            if (this.myFoundProject) break;
        }
        if (!checkoutCompleted) {
            VcsAwareCheckoutListener extension;
            boolean processingCompleted;
            VcsAwareCheckoutListener[] vcsAwareExtensions;
            VcsAwareCheckoutListener[] vcsAwareCheckoutListenerArray = vcsAwareExtensions = (VcsAwareCheckoutListener[])Extensions.getExtensions((ExtensionPointName)VcsAwareCheckoutListener.EP_NAME);
            int n = vcsAwareCheckoutListenerArray.length;
            for (int i = 0; i < n && !(processingCompleted = (extension = vcsAwareCheckoutListenerArray[i]).processCheckedOutDirectory(this.myProject, directory2, this.myVcsKey)); ++i) {
            }
        }
        if ((project = CompositeCheckoutListener.findProjectByBaseDirLocation(directory2)) != null) {
            for (CheckoutListener listener3 : listeners) {
                listener3.processOpenedProject(project);
            }
        }
    }

    public void checkoutCompleted() {
        if (!this.myFoundProject && this.myFirstDirectory != null) {
            this.notifyCheckoutListeners(this.myFirstDirectory, true);
        }
    }

    @Nullable
    static Project findProjectByBaseDirLocation(@NotNull File directory2) {
        if (directory2 == null) {
            CompositeCheckoutListener.$$$reportNull$$$0(0);
        }
        return (Project)ContainerUtil.find((Object[])ProjectManager.getInstance().getOpenProjects(), project -> {
            VirtualFile baseDir;
            if (directory2 == null) {
                CompositeCheckoutListener.$$$reportNull$$$0(1);
            }
            return (baseDir = project.getBaseDir()) != null && FileUtil.filesEqual((File)VfsUtilCore.virtualToIoFile((VirtualFile)baseDir), (File)directory2);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "directory";
        objectArray2[1] = "com/intellij/openapi/vcs/checkout/CompositeCheckoutListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findProjectByBaseDirLocation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$findProjectByBaseDirLocation$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

