/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.VirtualFilePointerImpl;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FilePointerPartNode {
    private static final FilePointerPartNode[] EMPTY_ARRAY = new FilePointerPartNode[0];
    @NotNull
    String part;
    @NotNull
    FilePointerPartNode[] children;
    FilePointerPartNode parent;
    private Object leaves;
    volatile Pair<VirtualFile, String> myFileAndUrl;
    volatile long myLastUpdated;
    volatile int useCount;
    int pointersUnder;
    private static final VirtualFileManager ourFileManager = VirtualFileManager.getInstance();
    private static final boolean UNIT_TEST = ApplicationManager.getApplication().isUnitTestMode();

    FilePointerPartNode(@NotNull String part, FilePointerPartNode parent, Pair<VirtualFile, String> fileAndUrl, int pointersToStore) {
        if (part == null) {
            FilePointerPartNode.$$$reportNull$$$0(0);
        }
        this.myLastUpdated = -1L;
        this.part = part;
        this.parent = parent;
        this.children = EMPTY_ARRAY;
        this.myFileAndUrl = fileAndUrl;
        this.pointersUnder = pointersToStore;
    }

    public String toString() {
        return this.part + (this.children.length == 0 ? "" : " -> " + this.children.length);
    }

    private int position(@Nullable VirtualFile parent, @Nullable CharSequence parentName, boolean separator, @NotNull CharSequence childName, int childStart, int childEnd, @NotNull FilePointerPartNode[] outNode, @Nullable List<FilePointerPartNode> outDirs) {
        int index;
        int partStart;
        if (childName == null) {
            FilePointerPartNode.$$$reportNull$$$0(1);
        }
        if (outNode == null) {
            FilePointerPartNode.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            partStart = 0;
            outNode[0] = this;
        } else {
            boolean gSeparator;
            VirtualFile gParent;
            CharSequence gParentName = (gParent = parent.getParent()) == null ? null : gParent.getNameSequence();
            partStart = this.position(gParent, gParentName, gSeparator = gParentName != null && !StringUtil.equals((CharSequence)gParentName, (CharSequence)"/"), parentName, 0, parentName.length(), outNode, outDirs);
            if (partStart == -1) {
                return -1;
            }
        }
        FilePointerPartNode found = outNode[0];
        boolean childSeparator = false;
        if (separator) {
            if (partStart == found.part.length()) {
                childSeparator = true;
            } else {
                int sepIndex = FilePointerPartNode.indexOfFirstDifferentChar("/", 0, found.part, partStart);
                if (sepIndex != 1) {
                    return -1;
                }
                ++partStart;
            }
        }
        if ((index = FilePointerPartNode.indexOfFirstDifferentChar(childName, childStart, found.part, partStart)) == childEnd) {
            this.addRecursiveDirectoryPtr(outDirs);
            return partStart + childEnd - childStart;
        }
        if (partStart + index - childStart == found.part.length()) {
            for (FilePointerPartNode child : found.children) {
                int childPos = child.position(null, null, childSeparator, childName, index, childEnd, outNode, null);
                if (childPos == -1) continue;
                this.addRecursiveDirectoryPtr(outDirs);
                return childPos;
            }
        }
        return -1;
    }

    private void addRecursiveDirectoryPtr(@Nullable List<FilePointerPartNode> dirs) {
        if (dirs != null && this.hasRecursiveDirectoryPointer() && (dirs.isEmpty() || dirs.get(dirs.size() - 1) != this)) {
            dirs.add(this);
        }
    }

    void addRelevantPointersFrom(@Nullable VirtualFile parent, boolean separator, @NotNull CharSequence childName, @NotNull List<FilePointerPartNode> out) {
        if (childName == null) {
            FilePointerPartNode.$$$reportNull$$$0(3);
        }
        if (out == null) {
            FilePointerPartNode.$$$reportNull$$$0(4);
        }
        CharSequence parentName = parent == null ? null : parent.getNameSequence();
        FilePointerPartNode[] outNode = new FilePointerPartNode[1];
        int position = this.position(parent, parentName, separator, childName, 0, childName.length(), outNode, out);
        if (position != -1) {
            FilePointerPartNode node = outNode[0];
            FilePointerPartNode.addAllPointersUnder(node, out);
        }
    }

    private boolean hasRecursiveDirectoryPointer() {
        VirtualFilePointerImpl[] leaves;
        if (this.leaves == null) {
            return false;
        }
        if (this.leaves instanceof VirtualFilePointer) {
            return ((VirtualFilePointer)this.leaves).isRecursive();
        }
        for (VirtualFilePointerImpl leaf : leaves = (VirtualFilePointerImpl[])this.leaves) {
            if (!leaf.isRecursive()) continue;
            return true;
        }
        return false;
    }

    private static void addAllPointersUnder(@NotNull FilePointerPartNode node, @NotNull List<FilePointerPartNode> out) {
        if (node == null) {
            FilePointerPartNode.$$$reportNull$$$0(5);
        }
        if (out == null) {
            FilePointerPartNode.$$$reportNull$$$0(6);
        }
        if (node.leaves != null) {
            out.add(node);
        }
        for (FilePointerPartNode child : node.children) {
            FilePointerPartNode.addAllPointersUnder(child, out);
        }
    }

    void checkConsistency() {
        if (UNIT_TEST && !ApplicationInfoImpl.isInStressTest()) {
            this.doCheckConsistency(false);
        }
    }

    private void doCheckConsistency(boolean dotDotOccurred) {
        boolean hasFile;
        dotDotOccurred |= this.part.contains("..");
        int childSum = 0;
        for (FilePointerPartNode child : this.children) {
            childSum += child.pointersUnder;
            child.doCheckConsistency(dotDotOccurred);
            assert (child.parent == this);
        }
        childSum += this.leavesNumber();
        assert (this.useCount == 0 == (this.leaves == null)) : this.useCount + " - " + (this.leaves instanceof VirtualFilePointerImpl ? this.leaves : Arrays.toString((Object[])((VirtualFilePointerImpl[])this.leaves)));
        assert (this.pointersUnder == childSum) : "expected: " + this.pointersUnder + "; actual: " + childSum;
        Pair<VirtualFile, String> fileAndUrl = this.myFileAndUrl;
        if (fileAndUrl != null && fileAndUrl.second != null) {
            String url = (String)fileAndUrl.second;
            assert (FilePointerPartNode.endsWith(url, this.part)) : "part is: '" + this.part + "' but url is: '" + url + "'";
        }
        boolean bl = hasFile = fileAndUrl != null && fileAndUrl.first != null;
        assert (!hasFile || !dotDotOccurred) : "Path is not canonical: '" + this.getUrl() + "'; my part: '" + this.part + "'";
    }

    @NotNull
    FilePointerPartNode findPointerOrCreate(@NotNull String path, int start, @NotNull Pair<VirtualFile, String> fileAndUrl, int pointersToStore) {
        FilePointerPartNode[] filePointerPartNodeArray;
        String pathRest;
        int index;
        if (path == null) {
            FilePointerPartNode.$$$reportNull$$$0(7);
        }
        if (fileAndUrl == null) {
            FilePointerPartNode.$$$reportNull$$$0(8);
        }
        if ((index = this.indexOfFirstDifferentChar(path, start)) == path.length() && index - start == this.part.length()) {
            if (this.leaves == null) {
                this.pointersUnder += pointersToStore;
            }
            FilePointerPartNode filePointerPartNode = this;
            if (filePointerPartNode == null) {
                FilePointerPartNode.$$$reportNull$$$0(9);
            }
            return filePointerPartNode;
        }
        if (index - start == this.part.length()) {
            for (FilePointerPartNode child : this.children) {
                int i = child.indexOfFirstDifferentChar(path, index);
                if (i == index || i <= index + 1 && path.charAt(index) == '/' && index != 0) continue;
                FilePointerPartNode node = child.findPointerOrCreate(path, index, fileAndUrl, pointersToStore);
                if (node.leaves == null) {
                    this.pointersUnder += pointersToStore;
                }
                FilePointerPartNode filePointerPartNode = node;
                if (filePointerPartNode == null) {
                    FilePointerPartNode.$$$reportNull$$$0(10);
                }
                return filePointerPartNode;
            }
            String pathRest2 = path.substring(index);
            FilePointerPartNode newNode = new FilePointerPartNode(pathRest2, this, fileAndUrl, pointersToStore);
            this.children = (FilePointerPartNode[])ArrayUtil.append((Object[])this.children, (Object)newNode);
            this.pointersUnder += pointersToStore;
            FilePointerPartNode filePointerPartNode = newNode;
            if (filePointerPartNode == null) {
                FilePointerPartNode.$$$reportNull$$$0(11);
            }
            return filePointerPartNode;
        }
        if (index > start + 1 && index != path.length() && path.charAt(index - 1) == '/') {
            --index;
        }
        FilePointerPartNode newNode = (pathRest = path.substring(index)).isEmpty() ? this : new FilePointerPartNode(pathRest, this, fileAndUrl, pointersToStore);
        String commonPredecessor = StringUtil.first((String)this.part, (int)(index - start), (boolean)false);
        FilePointerPartNode splittedAway = new FilePointerPartNode(this.part.substring(index - start), this, this.myFileAndUrl, this.pointersUnder);
        splittedAway.children = this.children;
        for (FilePointerPartNode child : this.children) {
            child.parent = splittedAway;
        }
        splittedAway.useCount = this.useCount;
        splittedAway.associate(this.leaves, this.myFileAndUrl);
        this.useCount = 0;
        this.part = commonPredecessor;
        if (newNode == this) {
            FilePointerPartNode[] filePointerPartNodeArray2 = new FilePointerPartNode[1];
            filePointerPartNodeArray = filePointerPartNodeArray2;
            filePointerPartNodeArray2[0] = splittedAway;
        } else {
            FilePointerPartNode[] filePointerPartNodeArray3 = new FilePointerPartNode[2];
            filePointerPartNodeArray3[0] = splittedAway;
            filePointerPartNodeArray = filePointerPartNodeArray3;
            filePointerPartNodeArray3[1] = newNode;
        }
        this.children = filePointerPartNodeArray;
        this.pointersUnder += pointersToStore;
        this.associate(null, null);
        FilePointerPartNode filePointerPartNode = newNode;
        if (filePointerPartNode == null) {
            FilePointerPartNode.$$$reportNull$$$0(12);
        }
        return filePointerPartNode;
    }

    @NotNull
    FilePointerPartNode remove() {
        int pointersNumber = this.leavesNumber();
        assert (this.leaves != null) : this.toString();
        this.associate(null, null);
        this.useCount = 0;
        this.myLastUpdated = -1L;
        FilePointerPartNode node = this;
        while (node.parent != null) {
            node.pointersUnder -= pointersNumber;
            node = node.parent;
        }
        if ((node.pointersUnder -= pointersNumber) == 0) {
            node.children = EMPTY_ARRAY;
        }
        FilePointerPartNode filePointerPartNode = node;
        if (filePointerPartNode == null) {
            FilePointerPartNode.$$$reportNull$$$0(13);
        }
        return filePointerPartNode;
    }

    private int indexOfFirstDifferentChar(@NotNull CharSequence path, int start) {
        if (path == null) {
            FilePointerPartNode.$$$reportNull$$$0(14);
        }
        return FilePointerPartNode.indexOfFirstDifferentChar(path, start, this.part, 0);
    }

    private static boolean endsWith(@NotNull String string, @NotNull String end) {
        if (string == null) {
            FilePointerPartNode.$$$reportNull$$$0(15);
        }
        if (end == null) {
            FilePointerPartNode.$$$reportNull$$$0(16);
        }
        return FilePointerPartNode.indexOfFirstDifferentChar(string, string.length() - end.length(), end, 0) == string.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable(value="null means this node's myFileAndUrl became invalid (e.g. after splitting into two other nodes)")
    Pair<VirtualFile, String> update() {
        Pair result2;
        boolean fileIsValid;
        long lastUpdated = this.myLastUpdated;
        Pair fileAndUrl = this.myFileAndUrl;
        if (fileAndUrl == null) {
            return null;
        }
        long fsModCount = ManagingFS.getInstance().getStructureModificationCount();
        if (lastUpdated == fsModCount) {
            return fileAndUrl;
        }
        VirtualFile file2 = (VirtualFile)fileAndUrl.first;
        String url = (String)fileAndUrl.second;
        boolean changed = false;
        if (url == null) {
            url = file2.getUrl();
            if (!file2.isValid()) {
                file2 = null;
            }
            changed = true;
        }
        boolean bl = fileIsValid = file2 != null && file2.isValid();
        if (file2 != null && !fileIsValid) {
            file2 = null;
            changed = true;
        }
        if (file2 == null) {
            file2 = ourFileManager.findFileByUrl(url);
            boolean bl2 = fileIsValid = file2 != null && file2.isValid();
            if (file2 != null) {
                changed = true;
            }
        }
        if (file2 != null) {
            if (fileIsValid) {
                url = file2.getUrl();
                changed |= !url.equals(fileAndUrl.second);
            } else {
                file2 = null;
                changed = true;
            }
        }
        if (changed) {
            result2 = Pair.create((Object)file2, (Object)url);
            VirtualFilePointerManager virtualFilePointerManager = VirtualFilePointerManager.getInstance();
            synchronized (virtualFilePointerManager) {
                Pair<VirtualFile, String> storedFileAndUrl = this.myFileAndUrl;
                if (storedFileAndUrl == null || storedFileAndUrl != fileAndUrl) {
                    return null;
                }
                this.myFileAndUrl = result2;
            }
        } else {
            result2 = fileAndUrl;
        }
        this.myLastUpdated = fsModCount;
        return result2;
    }

    private static int indexOfFirstDifferentChar(@NotNull CharSequence s1, int start1, @NotNull String s2, int start2) {
        if (s1 == null) {
            FilePointerPartNode.$$$reportNull$$$0(17);
        }
        if (s2 == null) {
            FilePointerPartNode.$$$reportNull$$$0(18);
        }
        boolean ignoreCase = !SystemInfo.isFileSystemCaseSensitive;
        int len1 = s1.length();
        int len2 = s2.length();
        while (start1 < len1 && start2 < len2) {
            char c2;
            char c1 = s1.charAt(start1);
            if (!StringUtil.charsMatch((char)c1, (char)(c2 = s2.charAt(start2)), (boolean)ignoreCase)) {
                return start1;
            }
            ++start1;
            ++start2;
        }
        return start1;
    }

    void associate(Object leaves, Pair<VirtualFile, String> fileAndUrl) {
        this.leaves = leaves;
        this.myFileAndUrl = fileAndUrl;
        if (leaves != null) {
            if (leaves instanceof VirtualFilePointerImpl) {
                ((VirtualFilePointerImpl)((Object)leaves)).myNode = this;
            } else {
                for (VirtualFilePointerImpl pointer : (VirtualFilePointerImpl[])leaves) {
                    pointer.myNode = this;
                }
            }
        }
        this.myLastUpdated = -1L;
    }

    int incrementUsageCount(int delta) {
        return this.useCount += delta;
    }

    int numberOfPointersUnder() {
        return this.pointersUnder;
    }

    VirtualFilePointerImpl getAnyPointer() {
        Object leaves = this.leaves;
        return leaves == null ? null : (leaves instanceof VirtualFilePointerImpl ? (VirtualFilePointerImpl)((Object)leaves) : ((VirtualFilePointerImpl[])leaves)[0]);
    }

    private String getUrl() {
        return this.parent == null ? this.part : this.parent.getUrl() + this.part;
    }

    private int leavesNumber() {
        Object leaves = this.leaves;
        return leaves == null ? 0 : (leaves instanceof VirtualFilePointerImpl ? 1 : ((VirtualFilePointerImpl[])leaves).length);
    }

    void addAllPointersTo(@NotNull Collection<? super VirtualFilePointerImpl> outList) {
        Object leaves;
        if (outList == null) {
            FilePointerPartNode.$$$reportNull$$$0(19);
        }
        if ((leaves = this.leaves) == null) {
            return;
        }
        if (leaves instanceof VirtualFilePointerImpl) {
            outList.add((VirtualFilePointerImpl)((Object)leaves));
        } else {
            ContainerUtil.addAll(outList, (Object[])((VirtualFilePointerImpl[])leaves));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outNode";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileAndUrl";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/FilePointerPartNode";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/FilePointerPartNode";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findPointerOrCreate";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "remove";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "position";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addRelevantPointersFrom";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addAllPointersUnder";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findPointerOrCreate";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 14: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "indexOfFirstDifferentChar";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "endsWith";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addAllPointersTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

