/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.docking.impl;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.impl.DockableEditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FrameWrapper;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.MutualMap;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.IdeRootPaneNorthExtension;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.VerticalBox;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockContainerFactory;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.DockableContent;
import com.intellij.ui.docking.DragSession;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DockManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class DockManagerImpl
extends DockManager
implements PersistentStateComponent<Element> {
    private final Project myProject;
    private final Map<String, DockContainerFactory> myFactories = new HashMap<String, DockContainerFactory>();
    private final Set<DockContainer> myContainers = new HashSet<DockContainer>();
    private final MutualMap<DockContainer, DockWindow> myWindows = new MutualMap();
    private MyDragSession myCurrentDragSession;
    private final BusyObject.Impl myBusyObject = new BusyObject.Impl(){

        public boolean isReady() {
            return DockManagerImpl.this.myCurrentDragSession == null;
        }
    };
    private int myWindowIdCounter = 1;
    private Element myLoadedState;

    public DockManagerImpl(Project project) {
        this.myProject = project;
    }

    public void register(final DockContainer container) {
        this.myContainers.add(container);
        Disposer.register((Disposable)container, (Disposable)new Disposable(){

            public void dispose() {
                DockManagerImpl.this.myContainers.remove(container);
            }
        });
    }

    public void register(final String id, DockContainerFactory factory) {
        this.myFactories.put(id, factory);
        Disposer.register((Disposable)factory, (Disposable)new Disposable(){

            public void dispose() {
                DockManagerImpl.this.myFactories.remove(id);
            }
        });
        this.readStateFor(id);
    }

    public void readState() {
        for (String id : this.myFactories.keySet()) {
            this.readStateFor(id);
        }
    }

    public Set<DockContainer> getContainers() {
        return Collections.unmodifiableSet(ContainerUtil.newHashSet(this.myContainers));
    }

    public IdeFrame getIdeFrame(DockContainer container) {
        Component parent = UIUtil.findUltimateParent((Component)container.getContainerComponent());
        if (parent instanceof IdeFrame) {
            return (IdeFrame)parent;
        }
        return null;
    }

    public String getDimensionKeyForFocus(@NotNull String key) {
        Component owner;
        if (key == null) {
            DockManagerImpl.$$$reportNull$$$0(0);
        }
        if ((owner = IdeFocusManager.getInstance((Project)this.myProject).getFocusOwner()) == null) {
            return key;
        }
        DockWindow wnd = (DockWindow)this.myWindows.getValue((Object)this.getContainerFor(owner));
        return wnd != null ? key + "#" + wnd.myId : key;
    }

    public DockContainer getContainerFor(Component c) {
        if (c == null) {
            return null;
        }
        for (DockContainer eachContainer : this.myContainers) {
            if (!SwingUtilities.isDescendingFrom(c, eachContainer.getContainerComponent())) continue;
            return eachContainer;
        }
        Component parent = UIUtil.findUltimateParent((Component)c);
        if (parent == null) {
            return null;
        }
        for (DockContainer eachContainer : this.myContainers) {
            if (parent != UIUtil.findUltimateParent((Component)eachContainer.getContainerComponent())) continue;
            return eachContainer;
        }
        return null;
    }

    public DragSession createDragSession(MouseEvent mouseEvent, @NotNull DockableContent content) {
        if (content == null) {
            DockManagerImpl.$$$reportNull$$$0(1);
        }
        this.stopCurrentDragSession();
        for (DockContainer each : this.myContainers) {
            DockWindow window;
            if (!each.isEmpty() || !each.isDisposeWhenEmpty() || (window = (DockWindow)this.myWindows.getValue((Object)each)) == null) continue;
            window.setTransparent(true);
        }
        this.myCurrentDragSession = new MyDragSession(mouseEvent, content);
        return this.myCurrentDragSession;
    }

    public void stopCurrentDragSession() {
        if (this.myCurrentDragSession != null) {
            this.myCurrentDragSession.cancelSession();
            this.myCurrentDragSession = null;
            this.myBusyObject.onReady();
            for (DockContainer each : this.myContainers) {
                DockWindow window;
                if (each.isEmpty() || (window = (DockWindow)this.myWindows.getValue((Object)each)) == null) continue;
                window.setTransparent(false);
            }
        }
    }

    private ActionCallback getReady() {
        return this.myBusyObject.getReady((Object)this);
    }

    @Nullable
    private DockContainer findContainerFor(RelativePoint point, @NotNull DockableContent content) {
        RelativeRectangle rec;
        if (content == null) {
            DockManagerImpl.$$$reportNull$$$0(2);
        }
        for (DockContainer each : this.myContainers) {
            rec = each.getAcceptArea();
            if (!rec.contains(point) || !each.getContentResponse(content, point).canAccept()) continue;
            return each;
        }
        for (DockContainer each : this.myContainers) {
            rec = each.getAcceptAreaFallback();
            if (!rec.contains(point) || !each.getContentResponse(content, point).canAccept()) continue;
            return each;
        }
        return null;
    }

    private DockContainerFactory getFactory(String type) {
        assert (this.myFactories.containsKey(type)) : "No factory for content type=" + type;
        return this.myFactories.get(type);
    }

    public void createNewDockContainerFor(DockableContent content, RelativePoint point) {
        DockContainer container = this.getFactory(content.getDockContainerType()).createContainer(content);
        this.register(container);
        DockWindow window = this.createWindowFor(null, container);
        Dimension size = content.getPreferredSize();
        Point showPoint = point.getScreenPoint();
        showPoint.x -= size.width / 2;
        showPoint.y -= size.height / 2;
        Rectangle target2 = new Rectangle(showPoint, size);
        ScreenUtil.moveRectangleToFitTheScreen((Rectangle)target2);
        ScreenUtil.cropRectangleToFitTheScreen((Rectangle)target2);
        window.setLocation(target2.getLocation());
        window.myDockContentUiContainer.setPreferredSize(target2.getSize());
        window.show(false);
        window.getFrame().pack();
        container.add(content, new RelativePoint(target2.getLocation()));
        SwingUtilities.invokeLater(() -> window.myUiContainer.setPreferredSize(null));
    }

    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> createNewDockContainerFor(@NotNull VirtualFile file2, @NotNull FileEditorManagerImpl fileEditorManager) {
        if (file2 == null) {
            DockManagerImpl.$$$reportNull$$$0(3);
        }
        if (fileEditorManager == null) {
            DockManagerImpl.$$$reportNull$$$0(4);
        }
        DockContainer container = this.getFactory("file-editors").createContainer(null);
        this.register(container);
        DockWindow window = this.createWindowFor(null, container);
        window.show(true);
        EditorWindow editorWindow = ((DockableEditorTabbedContainer)container).getSplitters().getOrCreateCurrentWindow(file2);
        Pair<FileEditor[], FileEditorProvider[]> result2 = fileEditorManager.openFileImpl2(editorWindow, file2, true);
        container.add((DockableContent)EditorTabbedContainer.createDockableEditor(this.myProject, null, file2, new Presentation(file2.getName()), editorWindow), null);
        SwingUtilities.invokeLater(() -> window.myUiContainer.setPreferredSize(null));
        Pair<FileEditor[], FileEditorProvider[]> pair = result2;
        if (pair == null) {
            DockManagerImpl.$$$reportNull$$$0(5);
        }
        return pair;
    }

    private DockWindow createWindowFor(@Nullable String id, DockContainer container) {
        String windowId = id != null ? id : String.valueOf(this.myWindowIdCounter++);
        DockWindow window = new DockWindow(windowId, this.myProject, container, container instanceof DockContainer.Dialog);
        window.setDimensionKey("dock-window-" + windowId);
        this.myWindows.put((Object)container, (Object)window);
        return window;
    }

    public Element getState() {
        Element root = new Element("DockManager");
        for (DockContainer each : this.myContainers) {
            DockWindow eachWindow = (DockWindow)this.myWindows.getValue((Object)each);
            if (eachWindow == null || !(each instanceof DockContainer.Persistent)) continue;
            DockContainer.Persistent eachContainer = (DockContainer.Persistent)each;
            Element eachWindowElement = new Element("window");
            eachWindowElement.setAttribute("id", eachWindow.myId);
            Element content = new Element("content");
            content.setAttribute("type", eachContainer.getDockContainerType());
            content.addContent(eachContainer.getState());
            eachWindowElement.addContent(content);
            root.addContent(eachWindowElement);
        }
        return root;
    }

    public void loadState(Element state2) {
        this.myLoadedState = state2;
    }

    private void readStateFor(String type) {
        if (this.myLoadedState == null) {
            return;
        }
        List windows = this.myLoadedState.getChildren("window");
        for (Object window1 : windows) {
            DockContainerFactory factory;
            String eachType;
            Element eachWindow = (Element)window1;
            if (eachWindow == null) continue;
            String eachId = eachWindow.getAttributeValue("id");
            Element eachContent = eachWindow.getChild("content");
            if (eachContent == null || (eachType = eachContent.getAttributeValue("type")) == null || !type.equals(eachType) || !this.myFactories.containsKey(eachType) || !((factory = this.myFactories.get(eachType)) instanceof DockContainerFactory.Persistent)) continue;
            DockContainerFactory.Persistent persistentFactory = (DockContainerFactory.Persistent)factory;
            DockContainer container = persistentFactory.loadContainerFrom(eachContent);
            this.register(container);
            DockWindow window = this.createWindowFor(eachId, container);
            UIUtil.invokeLaterIfNeeded(() -> window.show());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditorManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/docking/impl/DockManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/docking/impl/DockManagerImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewDockContainerFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDimensionKeyForFocus";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createDragSession";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findContainerFor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createNewDockContainerFor";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DockWindow
    extends FrameWrapper
    implements IdeEventQueue.EventDispatcher {
        private final String myId;
        private final DockContainer myContainer;
        private final VerticalBox myNorthPanel;
        private final Map<String, IdeRootPaneNorthExtension> myNorthExtensions;
        private final NonOpaquePanel myUiContainer;
        private final NonOpaquePanel myDockContentUiContainer;

        private DockWindow(String id, Project project, DockContainer container, boolean dialog2) {
            super(project, null, dialog2);
            this.myNorthPanel = new VerticalBox();
            this.myNorthExtensions = new LinkedHashMap<String, IdeRootPaneNorthExtension>();
            this.myId = id;
            this.myContainer = container;
            this.setProject(project);
            if (!(container instanceof DockContainer.Dialog)) {
                this.setStatusBar(WindowManager.getInstance().getStatusBar(project).createChild());
            }
            this.myUiContainer = new NonOpaquePanel((LayoutManager)new BorderLayout());
            NonOpaquePanel center = new NonOpaquePanel((LayoutManager)new BorderLayout(0, 2));
            if (UIUtil.isUnderAquaLookAndFeel()) {
                center.setOpaque(true);
                center.setBackground(JBTabsImpl.MAC_AQUA_BG_COLOR);
            }
            center.add((Component)this.myNorthPanel, (Object)"North");
            this.myDockContentUiContainer = new NonOpaquePanel((LayoutManager)new BorderLayout());
            this.myDockContentUiContainer.add((Component)this.myContainer.getContainerComponent(), (Object)"Center");
            center.add((Component)this.myDockContentUiContainer, (Object)"Center");
            this.myUiContainer.add((Component)center, (Object)"Center");
            if (this.myStatusBar != null) {
                this.myUiContainer.add((Component)this.myStatusBar.getComponent(), (Object)"South");
            }
            this.setComponent((JComponent)this.myUiContainer);
            this.addDisposable((Disposable)container);
            IdeEventQueue.getInstance().addPostprocessor(this, this);
            this.myContainer.addListener((DockContainer.Listener)new DockContainer.Listener.Adapter(){

                public void contentRemoved(Object key) {
                    DockManagerImpl.this.getReady().doWhenDone(() -> {
                        if (DockWindow.this.myContainer.isEmpty()) {
                            DockWindow.this.close();
                        }
                    });
                }
            }, (Disposable)this);
            project.getMessageBus().connect((Disposable)this).subscribe(UISettingsListener.TOPIC, uiSettings -> this.updateNorthPanel());
            this.updateNorthPanel();
        }

        @Override
        protected IdeRootPaneNorthExtension getNorthExtension(String key) {
            return this.myNorthExtensions.get(key);
        }

        private void updateNorthPanel() {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            this.myNorthPanel.setVisible(UISettings.getInstance().getShowNavigationBar() && !(this.myContainer instanceof DockContainer.Dialog) && !UISettings.getInstance().getPresentationMode());
            IdeRootPaneNorthExtension[] extensions = (IdeRootPaneNorthExtension[])Extensions.getArea((AreaInstance)DockManagerImpl.this.myProject).getExtensionPoint(IdeRootPaneNorthExtension.EP_NAME).getExtensions();
            HashSet<String> processedKeys = new HashSet<String>();
            for (IdeRootPaneNorthExtension each : extensions) {
                processedKeys.add(each.getKey());
                if (this.myNorthExtensions.containsKey(each.getKey())) continue;
                IdeRootPaneNorthExtension toInstall = each.copy();
                this.myNorthExtensions.put(toInstall.getKey(), toInstall);
                this.myNorthPanel.add((Component)toInstall.getComponent());
            }
            Iterator<String> existing = this.myNorthExtensions.keySet().iterator();
            while (existing.hasNext()) {
                String each = existing.next();
                if (processedKeys.contains(each)) continue;
                IdeRootPaneNorthExtension toRemove2 = this.myNorthExtensions.get(each);
                this.myNorthPanel.remove((Component)toRemove2.getComponent());
                existing.remove();
                Disposer.dispose((Disposable)toRemove2);
            }
            this.myNorthPanel.revalidate();
            this.myNorthPanel.repaint();
        }

        public void setTransparent(boolean transparent) {
            if (transparent) {
                WindowManagerEx.getInstanceEx().setAlphaModeEnabled(this.getFrame(), true);
                WindowManagerEx.getInstanceEx().setAlphaModeRatio(this.getFrame(), 0.5f);
            } else {
                WindowManagerEx.getInstanceEx().setAlphaModeEnabled(this.getFrame(), true);
                WindowManagerEx.getInstanceEx().setAlphaModeRatio(this.getFrame(), 0.0f);
            }
        }

        @Override
        public void dispose() {
            super.dispose();
            DockManagerImpl.this.myWindows.remove((Object)this.myContainer);
            for (IdeRootPaneNorthExtension each : this.myNorthExtensions.values()) {
                Disposer.dispose((Disposable)each);
            }
            this.myNorthExtensions.clear();
        }

        @Override
        public boolean dispatch(@NotNull AWTEvent e) {
            if (e == null) {
                DockWindow.$$$reportNull$$$0(0);
            }
            if (e instanceof KeyEvent && DockManagerImpl.this.myCurrentDragSession != null) {
                DockManagerImpl.this.stopCurrentDragSession();
            }
            return false;
        }

        @Override
        protected JFrame createJFrame(IdeFrame parent) {
            JFrame frame = super.createJFrame(parent);
            this.installListeners(frame);
            return frame;
        }

        @Override
        protected JDialog createJDialog(IdeFrame parent) {
            JDialog frame = super.createJDialog(parent);
            this.installListeners(frame);
            return frame;
        }

        private void installListeners(Window frame) {
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    DockWindow.this.myContainer.closeAll();
                }
            });
            UiNotifyConnector connector = new UiNotifyConnector((Component)((RootPaneContainer)((Object)frame)).getContentPane(), (Activatable)this.myContainer);
            Disposer.register((Disposable)this.myContainer, (Disposable)connector);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/docking/impl/DockManagerImpl$DockWindow", "dispatch"));
        }
    }

    private class MyDragSession
    implements DragSession {
        private final JWindow myWindow;
        private Image myDragImage;
        private final Image myDefaultDragImage;
        @NotNull
        private final DockableContent myContent;
        private DockContainer myCurrentOverContainer;
        private final JLabel myImageContainer;

        private MyDragSession(@NotNull MouseEvent me, DockableContent content) {
            if (content == null) {
                MyDragSession.$$$reportNull$$$0(0);
            }
            this.myWindow = new JWindow();
            this.myContent = content;
            Image previewImage = content.getPreviewImage();
            double requiredSize = 220.0;
            double width = previewImage.getWidth(null);
            double height = previewImage.getHeight(null);
            double ratio = width > height ? requiredSize / width : requiredSize / height;
            BufferedImage buffer = UIUtil.createImage((Component)this.myWindow, (int)((int)width), (int)((int)height), (int)2);
            buffer.createGraphics().drawImage(previewImage, 0, 0, (int)width, (int)height, null);
            this.myDragImage = this.myDefaultDragImage = buffer.getScaledInstance((int)(width * ratio), (int)(height * ratio), 4);
            this.myWindow.getContentPane().setLayout(new BorderLayout());
            this.myImageContainer = new JLabel(new ImageIcon(this.myDragImage));
            this.myImageContainer.setBorder(new LineBorder(Color.lightGray));
            this.myWindow.getContentPane().add((Component)this.myImageContainer, "Center");
            this.setLocationFrom(me);
            this.myWindow.setVisible(true);
            WindowManagerEx.getInstanceEx().setAlphaModeEnabled(this.myWindow, true);
            WindowManagerEx.getInstanceEx().setAlphaModeRatio(this.myWindow, 0.1f);
            this.myWindow.getRootPane().putClientProperty("Window.shadow", Boolean.FALSE);
        }

        private void setLocationFrom(MouseEvent me) {
            Point showPoint = me.getPoint();
            SwingUtilities.convertPointToScreen(showPoint, me.getComponent());
            showPoint.x -= this.myDragImage.getWidth(null) / 2;
            showPoint.y += 10;
            this.myWindow.setBounds(new Rectangle(showPoint, new Dimension(this.myDragImage.getWidth(null), this.myDragImage.getHeight(null))));
        }

        @NotNull
        public DockContainer.ContentResponse getResponse(MouseEvent e) {
            RelativePoint point = new RelativePoint(e);
            for (DockContainer each : DockManagerImpl.this.myContainers) {
                DockContainer.ContentResponse response;
                RelativeRectangle rec = each.getAcceptArea();
                if (!rec.contains(point) || !(response = each.getContentResponse(this.myContent, point)).canAccept()) continue;
                DockContainer.ContentResponse contentResponse = response;
                if (contentResponse == null) {
                    MyDragSession.$$$reportNull$$$0(1);
                }
                return contentResponse;
            }
            DockContainer.ContentResponse contentResponse = DockContainer.ContentResponse.DENY;
            if (contentResponse == null) {
                MyDragSession.$$$reportNull$$$0(2);
            }
            return contentResponse;
        }

        public void process(MouseEvent e) {
            RelativePoint point = new RelativePoint(e);
            Image img = null;
            if (e.getID() == 506) {
                DockContainer over = DockManagerImpl.this.findContainerFor(point, this.myContent);
                if (this.myCurrentOverContainer != null && this.myCurrentOverContainer != over) {
                    this.myCurrentOverContainer.resetDropOver(this.myContent);
                    this.myCurrentOverContainer = null;
                }
                if (this.myCurrentOverContainer == null && over != null) {
                    this.myCurrentOverContainer = over;
                    img = this.myCurrentOverContainer.startDropOver(this.myContent, point);
                }
                if (this.myCurrentOverContainer != null) {
                    img = this.myCurrentOverContainer.processDropOver(this.myContent, point);
                }
                if (img == null) {
                    img = this.myDefaultDragImage;
                }
                if (img != this.myDragImage) {
                    this.myDragImage = img;
                    this.myImageContainer.setIcon(new ImageIcon(this.myDragImage));
                    this.myWindow.pack();
                }
                this.setLocationFrom(e);
            } else if (e.getID() == 502) {
                if (this.myCurrentOverContainer == null) {
                    DockManagerImpl.this.createNewDockContainerFor(this.myContent, point);
                    DockManagerImpl.this.stopCurrentDragSession();
                } else {
                    this.myCurrentOverContainer.add(this.myContent, point);
                    DockManagerImpl.this.stopCurrentDragSession();
                }
            }
        }

        public void cancel() {
            DockManagerImpl.this.stopCurrentDragSession();
        }

        private void cancelSession() {
            this.myWindow.dispose();
            if (this.myCurrentOverContainer != null) {
                this.myCurrentOverContainer.resetDropOver(this.myContent);
                this.myCurrentOverContainer = null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/docking/impl/DockManagerImpl$MyDragSession";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/docking/impl/DockManagerImpl$MyDragSession";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResponse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

