/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.typing;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.jetbrains.python.PyCustomType;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.functionTypeComments.psi.PyFunctionTypeAnnotation;
import com.jetbrains.python.codeInsight.functionTypeComments.psi.PyFunctionTypeAnnotationFile;
import com.jetbrains.python.codeInsight.functionTypeComments.psi.PyParameterTypeList;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAnnotationOwner;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDoubleStarExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStarExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.stubs.PyClassElementType;
import com.jetbrains.python.psi.impl.stubs.PyTypingAliasStubType;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.stubs.PyClassStub;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyCallableTypeImpl;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyGenericType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.PyTypeProviderBase;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTypingTypeProvider
extends PyTypeProviderBase {
    private static final Object RECURSION_KEY = new Object();
    public static final String TYPING = "typing";
    public static final String GENERATOR = "typing.Generator";
    public static final String ASYNC_GENERATOR = "typing.AsyncGenerator";
    public static final String COROUTINE = "typing.Coroutine";
    public static final String NAMEDTUPLE = "typing.NamedTuple";
    public static final String GENERIC = "typing.Generic";
    public static final String PROTOCOL = "typing.Protocol";
    public static final String TYPE = "typing.Type";
    public static final String ANY = "typing.Any";
    private static final String CALLABLE = "typing.Callable";
    public static final String NAMEDTUPLE_SIMPLE = "NamedTuple";
    public static final String SUPPORTS_INT_SIMPLE = "SupportsInt";
    public static final String SUPPORTS_FLOAT_SIMPLE = "SupportsFloat";
    public static final String SUPPORTS_COMPLEX_SIMPLE = "SupportsComplex";
    public static final String SUPPORTS_BYTES_SIMPLE = "SupportsBytes";
    public static final String SUPPORTS_ABS_SIMPLE = "SupportsAbs";
    public static final String SUPPORTS_ROUND_SIMPLE = "SupportsRound";
    private static final String PY2_FILE_TYPE = "typing.BinaryIO";
    private static final String PY3_BINARY_FILE_TYPE = "typing.BinaryIO";
    private static final String PY3_TEXT_FILE_TYPE = "typing.TextIO";
    public static final Pattern TYPE_COMMENT_PATTERN = Pattern.compile("# *type: *(.*)");
    private static final ImmutableMap<String, String> COLLECTION_CLASSES = ImmutableMap.builder().put((Object)"typing.List", (Object)"list").put((Object)"typing.Dict", (Object)"dict").put((Object)"typing.Set", (Object)"set").put((Object)"typing.FrozenSet", (Object)"frozenset").put((Object)"typing.Tuple", (Object)"tuple").build();
    public static final ImmutableMap<String, String> TYPING_COLLECTION_CLASSES = ImmutableMap.builder().put((Object)"list", (Object)"List").put((Object)"dict", (Object)"Dict").put((Object)"set", (Object)"Set").put((Object)"frozenset", (Object)"FrozenSet").build();
    private static final ImmutableSet<String> GENERIC_CLASSES = ImmutableSet.builder().add((Object)"typing.Generic").add((Object)"typing.AbstractGeneric").add((Object)"typing.Protocol").build();
    private static final ImmutableSet<String> OPAQUE_NAMES = ImmutableSet.builder().add((Object)"typing.overload").add((Object)"typing.Any").add((Object)"typing.TypeVar").add((Object)"typing.Generic").add((Object)"typing.Tuple").add((Object)"typing.Callable").add((Object)"typing.Type").add((Object)"typing.no_type_check").add((Object)"typing.Union").add((Object)"typing.Optional").add((Object)"typing.List").add((Object)"typing.Dict").add((Object)"typing.DefaultDict").add((Object)"typing.Set").build();

    @Override
    @Nullable
    public PyType getReferenceExpressionType(@NotNull PyReferenceExpression referenceExpression, @NotNull TypeEvalContext context) {
        if (referenceExpression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(1);
        }
        if ("Generic".equals(referenceExpression.getName()) && PyTypingTypeProvider.resolveToQualifiedNames(referenceExpression, context).contains(GENERIC)) {
            return PyTypingTypeProvider.createTypingGenericType();
        }
        if ("Protocol".equals(referenceExpression.getName()) && PyTypingTypeProvider.resolveToQualifiedNames(referenceExpression, context).contains(PROTOCOL)) {
            return PyTypingTypeProvider.createTypingProtocolType();
        }
        return null;
    }

    @Override
    @Nullable
    public Ref<PyType> getParameterType(@NotNull PyNamedParameter param, @NotNull PyFunction func, @NotNull TypeEvalContext context) {
        PyNoneLiteralExpression noneExpr;
        Ref<PyType> typeFromAnnotation;
        if (param == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(2);
        }
        if (func == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(3);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(4);
        }
        if ((typeFromAnnotation = PyTypingTypeProvider.getParameterTypeFromAnnotation(param, context)) != null) {
            return typeFromAnnotation;
        }
        Ref<PyType> typeFromTypeComment = PyTypingTypeProvider.getParameterTypeFromTypeComment(param, context);
        if (typeFromTypeComment != null) {
            return typeFromTypeComment;
        }
        PyFunctionTypeAnnotation annotation = PyTypingTypeProvider.getFunctionTypeAnnotation(func);
        if (annotation == null) {
            return null;
        }
        PyParameterTypeList list2 = annotation.getParameterTypeList();
        List<PyExpression> paramTypes = list2.getParameterTypes();
        if (paramTypes.size() == 1 && (noneExpr = PyUtil.as(paramTypes.get(0), PyNoneLiteralExpression.class)) != null && noneExpr.isEllipsis()) {
            return Ref.create();
        }
        int startOffset = PyTypingTypeProvider.omitFirstParamInTypeComment(func, annotation) ? 1 : 0;
        List<PyParameter> funcParams = Arrays.asList(func.getParameterList().getParameters());
        int i = funcParams.indexOf(param) - startOffset;
        if (i >= 0 && i < paramTypes.size()) {
            return PyTypingTypeProvider.getParameterTypeFromFunctionComment(paramTypes.get(i), context);
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getParameterTypeFromFunctionComment(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
        PyExpression inner;
        PyExpression inner2;
        PyStarExpression starExpr;
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(5);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(6);
        }
        if ((starExpr = PyUtil.as(expression, PyStarExpression.class)) != null && (inner2 = starExpr.getExpression()) != null) {
            return Ref.create((Object)PyTypeUtil.toPositionalContainerType((PsiElement)expression, (PyType)Ref.deref(PyTypingTypeProvider.getType(inner2, new Context(context)))));
        }
        PyDoubleStarExpression doubleStarExpr = PyUtil.as(expression, PyDoubleStarExpression.class);
        if (doubleStarExpr != null && (inner = doubleStarExpr.getExpression()) != null) {
            return Ref.create((Object)PyTypeUtil.toKeywordContainerType((PsiElement)expression, (PyType)Ref.deref(PyTypingTypeProvider.getType(inner, new Context(context)))));
        }
        return PyTypingTypeProvider.getType(expression, new Context(context));
    }

    @Nullable
    private static Ref<PyType> getParameterTypeFromTypeComment(@NotNull PyNamedParameter parameter, @NotNull TypeEvalContext context) {
        String typeComment;
        if (parameter == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(7);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(8);
        }
        if ((typeComment = parameter.getTypeCommentAnnotation()) != null) {
            PyType type = (PyType)Ref.deref(PyTypingTypeProvider.getStringBasedType(typeComment, (PsiElement)parameter, context));
            if (parameter.isPositionalContainer()) {
                return Ref.create((Object)PyTypeUtil.toPositionalContainerType(parameter, type));
            }
            if (parameter.isKeywordContainer()) {
                return Ref.create((Object)PyTypeUtil.toKeywordContainerType(parameter, type));
            }
            return Ref.create((Object)type);
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getParameterTypeFromAnnotation(@NotNull PyNamedParameter parameter, @NotNull TypeEvalContext context) {
        Ref annotationValueTypeRef;
        if (parameter == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(9);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(10);
        }
        if ((annotationValueTypeRef = (Ref)Optional.ofNullable(PyTypingTypeProvider.getAnnotationValue(parameter, context)).map(text -> {
            if (context == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(114);
            }
            return PyTypingTypeProvider.getType(text, new Context(context));
        }).orElse(null)) != null) {
            PyType annotationValueType = (PyType)annotationValueTypeRef.get();
            if (parameter.isPositionalContainer()) {
                return Ref.create((Object)PyTypeUtil.toPositionalContainerType(parameter, annotationValueType));
            }
            if (parameter.isKeywordContainer()) {
                return Ref.create((Object)PyTypeUtil.toKeywordContainerType(parameter, annotationValueType));
            }
            if ("None".equals(parameter.getDefaultValueText())) {
                return Ref.create((Object)PyUnionType.union(annotationValueType, PyNoneType.INSTANCE));
            }
            return Ref.create((Object)annotationValueType);
        }
        return null;
    }

    @NotNull
    private static PyType createTypingGenericType() {
        PyCustomType pyCustomType = new PyCustomType(GENERIC, null, false, new PyClassLikeType[0]);
        if (pyCustomType == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(11);
        }
        return pyCustomType;
    }

    @NotNull
    private static PyType createTypingProtocolType() {
        PyCustomType pyCustomType = new PyCustomType(PROTOCOL, null, false, new PyClassLikeType[0]);
        if (pyCustomType == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(12);
        }
        return pyCustomType;
    }

    private static boolean omitFirstParamInTypeComment(@NotNull PyFunction func, @NotNull PyFunctionTypeAnnotation annotation) {
        if (func == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(13);
        }
        if (annotation == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(14);
        }
        return func.getContainingClass() != null && func.getModifier() != PyFunction.Modifier.STATICMETHOD && annotation.getParameterTypeList().getParameterTypes().size() < func.getParameterList().getParameters().length;
    }

    @Override
    @Nullable
    public Ref<PyType> getReturnType(@NotNull PyCallable callable, @NotNull TypeEvalContext context) {
        Ref<PyType> typeRef;
        PyFunction function;
        PyExpression value;
        if (callable == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(15);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(16);
        }
        if (callable instanceof PyFunction && (value = PyTypingTypeProvider.getReturnTypeAnnotation(function = (PyFunction)callable, context)) != null && (typeRef = PyTypingTypeProvider.getType(value, new Context(context))) != null) {
            return Ref.create((Object)PyTypingTypeProvider.toAsyncIfNeeded(function, (PyType)typeRef.get()));
        }
        return null;
    }

    @Nullable
    private static PyExpression getReturnTypeAnnotation(@NotNull PyFunction function, TypeEvalContext context) {
        PyExpression returnAnnotation;
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(17);
        }
        if ((returnAnnotation = PyTypingTypeProvider.getAnnotationValue(function, context)) != null) {
            return returnAnnotation;
        }
        PyFunctionTypeAnnotation functionAnnotation = PyTypingTypeProvider.getFunctionTypeAnnotation(function);
        if (functionAnnotation != null) {
            return functionAnnotation.getReturnType();
        }
        return null;
    }

    @Nullable
    private static PyFunctionTypeAnnotation getFunctionTypeAnnotation(@NotNull PyFunction function) {
        String comment;
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(18);
        }
        if ((comment = function.getTypeCommentAnnotation()) == null) {
            return null;
        }
        PyFunctionTypeAnnotationFile file2 = (PyFunctionTypeAnnotationFile)CachedValuesManager.getCachedValue((PsiElement)function, () -> {
            if (function == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(113);
            }
            return CachedValueProvider.Result.create((Object)new PyFunctionTypeAnnotationFile(function.getTypeCommentAnnotation(), function), (Object[])new Object[]{function});
        });
        return file2.getAnnotation();
    }

    @Override
    @Nullable
    public Ref<PyType> getCallType(@NotNull PyFunction function, @Nullable PyCallSiteExpression callSite, @NotNull TypeEvalContext context) {
        String functionQName;
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(19);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(20);
        }
        if ("typing.cast".equals(functionQName = function.getQualifiedName())) {
            return Optional.ofNullable(PyUtil.as(callSite, PyCallExpression.class)).map(PyCallExpression::getArguments).filter(args -> ((PyExpression[])args).length > 0).map(args -> {
                if (context == null) {
                    PyTypingTypeProvider.$$$reportNull$$$0(112);
                }
                return PyTypingTypeProvider.getType(args[0], new Context(context));
            }).orElse(null);
        }
        if (callSite instanceof PyCallExpression && "open".equals(functionQName)) {
            return PyTypingTypeProvider.getOpenFunctionCallType(function, (PyCallExpression)callSite, LanguageLevel.forElement((PsiElement)callSite), context);
        }
        return null;
    }

    @Override
    public PyType getReferenceType(@NotNull PsiElement referenceTarget, TypeEvalContext context, @Nullable PsiElement anchor) {
        if (referenceTarget == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(21);
        }
        if (referenceTarget instanceof PyTargetExpression) {
            PyTargetExpression target2 = (PyTargetExpression)referenceTarget;
            if (GENERIC.equals(target2.getQualifiedName())) {
                return PyTypingTypeProvider.createTypingGenericType();
            }
            if (PROTOCOL.equals(target2.getQualifiedName())) {
                return PyTypingTypeProvider.createTypingProtocolType();
            }
            Ref<PyType> annotatedType = PyTypingTypeProvider.getTypeFromTargetExpressionAnnotation(target2, context);
            if (annotatedType != null) {
                return (PyType)annotatedType.get();
            }
            String name = target2.getReferencedName();
            ScopeOwner scopeOwner = ScopeUtil.getScopeOwner(target2);
            if (name == null || scopeOwner == null) {
                return null;
            }
            PyClass pyClass = target2.getContainingClass();
            if (target2.isQualified()) {
                if (pyClass != null && scopeOwner instanceof PyFunction) {
                    PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(context);
                    boolean isInstanceAttribute = false;
                    isInstanceAttribute = context.maySwitchToAST(target2) ? ((StreamEx)StreamEx.of(PyUtil.multiResolveTopPriority((PsiElement)target2.getQualifier(), resolveContext)).select(PyParameter.class).filter(PyParameter::isSelf)).anyMatch(p -> PsiTreeUtil.getParentOfType((PsiElement)p, PyFunction.class) == scopeOwner) : PyUtil.isInstanceAttribute(target2);
                    if (!isInstanceAttribute) {
                        return null;
                    }
                    PyClassTypeImpl classType = new PyClassTypeImpl(pyClass, true);
                    List<? extends RatedResolveResult> classAttrs = classType.resolveMember(name, target2, AccessDirection.READ, resolveContext, true);
                    if (classAttrs == null) {
                        return null;
                    }
                    Ref combined = (Ref)((StreamEx)StreamEx.of(classAttrs).map(RatedResolveResult::getElement).select(PyTargetExpression.class).filter(x -> ScopeUtil.getScopeOwner(x) instanceof PyClass)).map(x -> PyTypingTypeProvider.getTypeFromTargetExpressionAnnotation(x, context)).collect(PyTypeUtil.toUnionFromRef());
                    return (PyType)Ref.deref((Ref)combined);
                }
            } else {
                StreamEx candidates = null;
                if (context.maySwitchToAST(target2)) {
                    Scope scope = ControlFlowCache.getScope(scopeOwner);
                    candidates = StreamEx.of(scope.getNamedElements(name, false)).select(PyTargetExpression.class);
                } else if (scopeOwner instanceof PyFile) {
                    candidates = (StreamEx)StreamEx.of(((PyFile)scopeOwner).getTopLevelAttributes()).filter(t -> name.equals(t.getName()));
                } else if (scopeOwner instanceof PyClass) {
                    candidates = (StreamEx)StreamEx.of(((PyClass)scopeOwner).getClassAttributes()).filter(t -> name.equals(t.getName()));
                }
                if (candidates != null) {
                    return candidates.map(x -> PyTypingTypeProvider.getTypeFromTargetExpressionAnnotation(x, context)).nonNull().findFirst().map(Ref::get).orElse(null);
                }
            }
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getTypeFromTargetExpressionAnnotation(@NotNull PyTargetExpression target2, @NotNull TypeEvalContext context) {
        Ref<PyType> fromTypeComment;
        PyExpression annotation;
        if (target2 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(22);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(23);
        }
        if ((annotation = PyTypingTypeProvider.getAnnotationValue(target2, context)) != null) {
            return PyTypingTypeProvider.getType(annotation, new Context(context));
        }
        String comment = target2.getTypeCommentAnnotation();
        if (comment != null && (fromTypeComment = PyTypingTypeProvider.getVariableTypeCommentType(comment, target2, new Context(context))) != null) {
            PyTupleExpression tupleExpr;
            PyType type = (PyType)Ref.deref(fromTypeComment);
            if (type instanceof PyTupleType && (tupleExpr = (PyTupleExpression)PsiTreeUtil.getParentOfType((PsiElement)target2, PyTupleExpression.class)) != null) {
                return Ref.create((Object)PyTypeChecker.getTargetTypeFromTupleAssignment(target2, tupleExpr, (PyTupleType)type));
            }
            return fromTypeComment;
        }
        return null;
    }

    @Nullable
    public static String getTypeCommentValue(@NotNull String text) {
        Matcher m;
        if (text == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(24);
        }
        if ((m = TYPE_COMMENT_PATTERN.matcher(text)).matches()) {
            return m.group(1);
        }
        return null;
    }

    @Override
    @Nullable
    public PyType getGenericType(@NotNull PyClass cls, @NotNull TypeEvalContext context) {
        List<PyType> genericTypes;
        if (cls == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(25);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(26);
        }
        if ((genericTypes = PyTypingTypeProvider.collectGenericTypes(cls, new Context(context))).isEmpty()) {
            return null;
        }
        return new PyCollectionTypeImpl(cls, false, genericTypes);
    }

    @Override
    @NotNull
    public Map<PyType, PyType> getGenericSubstitutions(@NotNull PyClass cls, @NotNull TypeEvalContext context) {
        Context ctx;
        if (cls == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(27);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(28);
        }
        if (!PyTypingTypeProvider.isGeneric(cls, ctx = new Context(context))) {
            Map<PyType, PyType> map2 = Collections.emptyMap();
            if (map2 == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(29);
            }
            return map2;
        }
        HashMap results = new HashMap();
        for (Map.Entry<PyClass, PySubscriptionExpression> e : PyTypingTypeProvider.getResolvedSuperClassesAndTypeParameters(cls, context).entrySet()) {
            PySubscriptionExpression subscriptionExpr = e.getValue();
            PyClass superClass = e.getKey();
            Map superSubstitutions = (Map)RecursionManager.doPreventingRecursion((Object)RECURSION_KEY, (boolean)false, () -> {
                if (context == null) {
                    PyTypingTypeProvider.$$$reportNull$$$0(111);
                }
                return this.getGenericSubstitutions(superClass, context);
            });
            if (superSubstitutions != null) {
                results.putAll(superSubstitutions);
            }
            if (superClass == null) continue;
            List<PyType> superGenerics = PyTypingTypeProvider.collectGenericTypes(superClass, ctx);
            List<Object> indices = subscriptionExpr != null ? PyTypingTypeProvider.getSubscriptionIndices(subscriptionExpr) : Collections.emptyList();
            for (int i = 0; i < superGenerics.size(); ++i) {
                PyType actualType;
                PyExpression expr = (PyExpression)ContainerUtil.getOrElse(indices, (int)i, null);
                PyType superGeneric = superGenerics.get(i);
                Ref<PyType> typeRef = expr != null ? PyTypingTypeProvider.getType(expr, ctx) : null;
                PyType pyType = actualType = typeRef != null ? (PyType)typeRef.get() : null;
                if (superGeneric.equals(actualType)) continue;
                results.put(superGeneric, actualType);
            }
        }
        HashMap hashMap = results;
        if (hashMap == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(30);
        }
        return hashMap;
    }

    @NotNull
    private static Map<PyClass, PySubscriptionExpression> getResolvedSuperClassesAndTypeParameters(@NotNull PyClass pyClass, @NotNull TypeEvalContext context) {
        if (pyClass == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(31);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(32);
        }
        LinkedHashMap<PyClass, PySubscriptionExpression> results = new LinkedHashMap<PyClass, PySubscriptionExpression>();
        PyClassStub classStub = (PyClassStub)pyClass.getStub();
        if (context.maySwitchToAST((PsiElement)pyClass)) {
            for (PyExpression e : pyClass.getSuperClassExpressions()) {
                PyClass superClass;
                PySubscriptionExpression subscriptionExpr = PyUtil.as(e, PySubscriptionExpression.class);
                PyExpression superExpr = subscriptionExpr != null ? subscriptionExpr.getOperand() : e;
                PyType superType = context.getType(superExpr);
                PyClassType superClassType = PyUtil.as(superType, PyClassType.class);
                PyClass pyClass2 = superClass = superClassType != null ? superClassType.getPyClass() : null;
                if (superClass == null) continue;
                results.put(superClass, subscriptionExpr);
            }
            LinkedHashMap<PyClass, PySubscriptionExpression> linkedHashMap = results;
            if (linkedHashMap == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(33);
            }
            return linkedHashMap;
        }
        List<PySubscriptionExpression> subscriptedBaseClasses = PyClassElementType.getSubscriptedSuperClassesStubLike(pyClass);
        HashMap baseClassQNameToExpr = new HashMap();
        Set<QualifiedName> allBaseClassesQNames = classStub == null ? PyClassElementType.getSuperClassQNames(pyClass).keySet() : classStub.getSuperClasses().keySet();
        for (PySubscriptionExpression subscriptedBase : subscriptedBaseClasses) {
            PyExpression operand = subscriptedBase.getOperand();
            if (!(operand instanceof PyReferenceExpression)) continue;
            QualifiedName className = PyPsiUtils.asQualifiedName(operand);
            baseClassQNameToExpr.put(className, subscriptedBase);
        }
        for (QualifiedName qName : allBaseClassesQNames) {
            List<PsiElement> classes = PyResolveUtil.resolveQualifiedNameInFile(qName, (PyFile)pyClass.getContainingFile(), context);
            PyClass firstFound = (PyClass)ContainerUtil.findInstance(classes, PyClass.class);
            if (firstFound == null) continue;
            results.put(firstFound, (PySubscriptionExpression)baseClassQNameToExpr.get(qName));
        }
        LinkedHashMap<PyClass, PySubscriptionExpression> linkedHashMap = results;
        if (linkedHashMap == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(34);
        }
        return linkedHashMap;
    }

    @NotNull
    private static List<PyExpression> getSubscriptionIndices(@NotNull PySubscriptionExpression expr) {
        PyExpression indexExpr;
        PyTupleExpression tupleExpr;
        if (expr == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(35);
        }
        List<PyExpression> list2 = (tupleExpr = PyUtil.as(indexExpr = expr.getIndexExpression(), PyTupleExpression.class)) != null ? Arrays.asList(tupleExpr.getElements()) : Collections.singletonList(indexExpr);
        if (list2 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(36);
        }
        return list2;
    }

    @NotNull
    private static List<PyType> collectGenericTypes(@NotNull PyClass cls, @NotNull Context context) {
        if (cls == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(37);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(38);
        }
        if (!PyTypingTypeProvider.isGeneric(cls, context)) {
            List<PyType> list2 = Collections.emptyList();
            if (list2 == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(39);
            }
            return list2;
        }
        TypeEvalContext typeEvalContext = context.getTypeContext();
        List list3 = ((StreamEx)StreamEx.of(PyClassElementType.getSubscriptedSuperClassesStubLike(cls)).map(PySubscriptionExpression::getIndexExpression).flatMap(e -> {
            PyTupleExpression tupleExpr = PyUtil.as(e, PyTupleExpression.class);
            return tupleExpr != null ? StreamEx.of((Object[])tupleExpr.getElements()) : StreamEx.of((Object)e);
        }).nonNull().flatMap(e -> PyTypingTypeProvider.tryResolving(e, typeEvalContext).stream()).map(e -> {
            if (context == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(110);
            }
            return PyTypingTypeProvider.getGenericTypeFromTypeVar(e, context);
        }).select(PyType.class).distinct()).toList();
        if (list3 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(40);
        }
        return list3;
    }

    private static boolean isGeneric(@NotNull PyClass cls, @NotNull Context context) {
        if (cls == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(41);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(42);
        }
        for (PyClassLikeType ancestor : cls.getAncestorTypes(context.getTypeContext())) {
            if (ancestor == null || !GENERIC_CLASSES.contains((Object)ancestor.getClassQName())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static Ref<PyType> getType(@NotNull PyExpression expression, @NotNull Context context) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(43);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(44);
        }
        ArrayList members = Lists.newArrayList();
        boolean foundAny = false;
        for (PsiElement resolved : PyTypingTypeProvider.tryResolving(expression, context.getTypeContext())) {
            Ref<PyType> typeRef = PyTypingTypeProvider.getTypeForResolvedElement(resolved, context);
            if (typeRef == null) continue;
            PyType type = (PyType)typeRef.get();
            if (type == null) {
                foundAny = true;
            }
            members.add(type);
        }
        PyType union = PyUnionType.union(members);
        return union != null || foundAny ? Ref.create((Object)union) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Ref<PyType> getTypeForResolvedElement(@NotNull PsiElement resolved, @NotNull Context context) {
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(45);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(46);
        }
        if (context.getExpressionCache().contains(resolved)) {
            return null;
        }
        context.getExpressionCache().add(resolved);
        try {
            PyType unionType = PyTypingTypeProvider.getUnionType(resolved, context);
            if (unionType != null) {
                Ref ref = Ref.create((Object)unionType);
                return ref;
            }
            Ref<PyType> optionalType = PyTypingTypeProvider.getOptionalType(resolved, context);
            if (optionalType != null) {
                Ref<PyType> ref = optionalType;
                return ref;
            }
            PyType callableType = PyTypingTypeProvider.getCallableType(resolved, context);
            if (callableType != null) {
                Ref ref = Ref.create((Object)callableType);
                return ref;
            }
            Ref<PyType> classObjType = PyTypingTypeProvider.getClassObjectType(resolved, context);
            if (classObjType != null) {
                Ref<PyType> ref = classObjType;
                return ref;
            }
            PyType parameterizedType = PyTypingTypeProvider.getParameterizedType(resolved, context);
            if (parameterizedType != null) {
                Ref ref = Ref.create((Object)parameterizedType);
                return ref;
            }
            PyType builtinCollection = PyTypingTypeProvider.getBuiltinCollection(resolved, context.getTypeContext());
            if (builtinCollection != null) {
                Ref ref = Ref.create((Object)builtinCollection);
                return ref;
            }
            PyGenericType genericType = PyTypingTypeProvider.getGenericTypeFromTypeVar(resolved, context);
            if (genericType != null) {
                Ref ref = Ref.create((Object)genericType);
                return ref;
            }
            PyType stringBasedType = PyTypingTypeProvider.getStringLiteralType(resolved, context);
            if (stringBasedType != null) {
                Ref ref = Ref.create((Object)stringBasedType);
                return ref;
            }
            Ref<PyType> anyType = PyTypingTypeProvider.getAnyType(resolved);
            if (anyType != null) {
                Ref<PyType> ref = anyType;
                return ref;
            }
            Ref<PyType> classType = PyTypingTypeProvider.getClassType(resolved, context.getTypeContext());
            if (classType != null) {
                Ref<PyType> ref = classType;
                return ref;
            }
            Ref<PyType> ref = null;
            return ref;
        }
        finally {
            context.getExpressionCache().remove(resolved);
        }
    }

    @Nullable
    private static Ref<PyType> getClassObjectType(@NotNull PsiElement resolved, @NotNull Context context) {
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(47);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(48);
        }
        if (resolved instanceof PySubscriptionExpression) {
            PySubscriptionExpression subsExpr = (PySubscriptionExpression)resolved;
            PyExpression operand = subsExpr.getOperand();
            Collection<String> operandNames = PyTypingTypeProvider.resolveToQualifiedNames(operand, context.getTypeContext());
            if (operandNames.contains(TYPE)) {
                PyExpression indexExpr = subsExpr.getIndexExpression();
                if (indexExpr != null) {
                    if (PyTypingTypeProvider.resolveToQualifiedNames(indexExpr, context.getTypeContext()).contains(ANY)) {
                        return Ref.create((Object)PyBuiltinCache.getInstance(resolved).getTypeType());
                    }
                    PyType type = (PyType)Ref.deref(PyTypingTypeProvider.getType(indexExpr, context));
                    PyClassType classType = PyUtil.as(type, PyClassType.class);
                    if (classType != null && !classType.isDefinition()) {
                        return Ref.create((Object)new PyClassTypeImpl(classType.getPyClass(), true));
                    }
                    PyGenericType typeVar = PyUtil.as(type, PyGenericType.class);
                    if (typeVar != null && !typeVar.isDefinition()) {
                        return Ref.create((Object)new PyGenericType(typeVar.getName(), typeVar.getBound(), true));
                    }
                    PyUnionType unionType = PyUtil.as(type, PyUnionType.class);
                    if (unionType != null && unionType.getMembers().stream().allMatch(t -> t instanceof PyClassType && !((PyClassType)t).isDefinition())) {
                        return Ref.create((Object)PyUnionType.union(ContainerUtil.map(unionType.getMembers(), t -> (PyClassLikeType)((PyClassType)t).toClass())));
                    }
                }
                return Ref.create();
            }
        } else if (TYPE.equals(PyTypingTypeProvider.getQualifiedName(resolved))) {
            return Ref.create((Object)PyBuiltinCache.getInstance(resolved).getTypeType());
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getAnyType(@NotNull PsiElement element) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(49);
        }
        return ANY.equals(PyTypingTypeProvider.getQualifiedName(element)) ? Ref.create() : null;
    }

    @Nullable
    private static Ref<PyType> getClassType(@NotNull PsiElement element, @NotNull TypeEvalContext context) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(50);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(51);
        }
        if (element instanceof PyTypedElement) {
            PyType type = context.getType((PyTypedElement)element);
            if (type instanceof PyClassLikeType) {
                PyClassLikeType classType = (PyClassLikeType)type;
                if (classType.isDefinition()) {
                    Object instanceType = classType.toInstance();
                    return Ref.create(instanceType);
                }
            } else if (type instanceof PyNoneType) {
                return Ref.create((Object)type);
            }
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getOptionalType(@NotNull PsiElement element, @NotNull Context context) {
        PySubscriptionExpression subscriptionExpr;
        PyExpression operand;
        Collection<String> operandNames;
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(52);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(53);
        }
        if (element instanceof PySubscriptionExpression && (operandNames = PyTypingTypeProvider.resolveToQualifiedNames(operand = (subscriptionExpr = (PySubscriptionExpression)element).getOperand(), context.getTypeContext())).contains("typing.Optional")) {
            Ref<PyType> typeRef;
            PyExpression indexExpr = subscriptionExpr.getIndexExpression();
            if (indexExpr != null && (typeRef = PyTypingTypeProvider.getType(indexExpr, context)) != null) {
                return Ref.create((Object)PyUnionType.union((PyType)typeRef.get(), PyNoneType.INSTANCE));
            }
            return Ref.create();
        }
        return null;
    }

    @Nullable
    private static PyExpression getAnnotationValue(@NotNull PyAnnotationOwner owner, @NotNull TypeEvalContext context) {
        if (owner == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(54);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(55);
        }
        if (context.maySwitchToAST(owner)) {
            PyAnnotation annotation = owner.getAnnotation();
            if (annotation != null) {
                return annotation.getValue();
            }
        } else {
            String annotationText = owner.getAnnotationValue();
            if (annotationText != null) {
                return PyUtil.createExpressionFromFragment(annotationText, (PsiElement)owner.getContainingFile());
            }
        }
        return null;
    }

    @Nullable
    public static Ref<PyType> getStringBasedType(@NotNull String contents, @NotNull PsiElement anchor, @NotNull TypeEvalContext context) {
        if (contents == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(56);
        }
        if (anchor == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(57);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(58);
        }
        return PyTypingTypeProvider.getStringBasedType(contents, anchor, new Context(context));
    }

    @Nullable
    private static Ref<PyType> getStringBasedType(@NotNull String contents, @NotNull PsiElement anchor, @NotNull Context context) {
        PsiFile file2;
        if (contents == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(59);
        }
        if (anchor == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(60);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(61);
        }
        if ((file2 = FileContextUtil.getContextFile(anchor)) == null) {
            return null;
        }
        PyExpression expr = PyUtil.createExpressionFromFragment(contents, (PsiElement)file2);
        return expr != null ? PyTypingTypeProvider.getType(expr, context) : null;
    }

    @Nullable
    private static PyType getStringLiteralType(@NotNull PsiElement element, @NotNull Context context) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(62);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(63);
        }
        if (element instanceof PyStringLiteralExpression) {
            String contents = ((PyStringLiteralExpression)element).getStringValue();
            return (PyType)Ref.deref(PyTypingTypeProvider.getStringBasedType(contents, element, context));
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getVariableTypeCommentType(@NotNull String contents, @NotNull PsiElement anchor, @NotNull Context context) {
        PyExpression expr;
        if (contents == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(64);
        }
        if (anchor == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(65);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(66);
        }
        if ((expr = PyUtil.createExpressionFromFragment(contents, (PsiElement)anchor.getContainingFile())) != null) {
            if (expr instanceof PyTupleExpression) {
                PyTupleExpression tupleExpr = (PyTupleExpression)expr;
                List elementTypes = ContainerUtil.map((Object[])tupleExpr.getElements(), elementExpr -> {
                    if (context == null) {
                        PyTypingTypeProvider.$$$reportNull$$$0(109);
                    }
                    return (PyType)Ref.deref(PyTypingTypeProvider.getType(elementExpr, context));
                });
                return Ref.create((Object)PyTupleType.create(anchor, elementTypes));
            }
            return PyTypingTypeProvider.getType(expr, context);
        }
        return null;
    }

    @Nullable
    private static PyType getCallableType(@NotNull PsiElement resolved, @NotNull Context context) {
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(67);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(68);
        }
        if (resolved instanceof PySubscriptionExpression) {
            PyTupleExpression tupleExpr;
            PyExpression[] elements;
            PyExpression indexExpr;
            PySubscriptionExpression subscriptionExpr = (PySubscriptionExpression)resolved;
            PyExpression operand = subscriptionExpr.getOperand();
            Collection<String> operandNames = PyTypingTypeProvider.resolveToQualifiedNames(operand, context.getTypeContext());
            if (operandNames.contains(CALLABLE) && (indexExpr = subscriptionExpr.getIndexExpression()) instanceof PyTupleExpression && (elements = (tupleExpr = (PyTupleExpression)indexExpr).getElements()).length == 2) {
                PyExpression parametersExpr = elements[0];
                PyExpression returnTypeExpr = elements[1];
                if (parametersExpr instanceof PyListLiteralExpression) {
                    ArrayList<PyCallableParameter> parameters = new ArrayList<PyCallableParameter>();
                    PyListLiteralExpression listExpr = (PyListLiteralExpression)parametersExpr;
                    for (PyExpression argExpr : listExpr.getElements()) {
                        parameters.add(PyCallableParameterImpl.nonPsi((PyType)Ref.deref(PyTypingTypeProvider.getType(argExpr, context))));
                    }
                    PyType returnType = (PyType)Ref.deref(PyTypingTypeProvider.getType(returnTypeExpr, context));
                    return new PyCallableTypeImpl(parameters, returnType);
                }
                if (PyTypingTypeProvider.isEllipsis(parametersExpr)) {
                    return new PyCallableTypeImpl(null, (PyType)Ref.deref(PyTypingTypeProvider.getType(returnTypeExpr, context)));
                }
            }
        } else if (resolved instanceof PyTargetExpression && PyTypingTypeProvider.resolveToQualifiedNames((PyTargetExpression)resolved, context.getTypeContext()).contains(CALLABLE)) {
            return new PyCallableTypeImpl(null, null);
        }
        return null;
    }

    private static boolean isEllipsis(@NotNull PyExpression parametersExpr) {
        if (parametersExpr == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(69);
        }
        return parametersExpr instanceof PyNoneLiteralExpression && ((PyNoneLiteralExpression)parametersExpr).isEllipsis();
    }

    @Nullable
    private static PyType getUnionType(@NotNull PsiElement element, @NotNull Context context) {
        PySubscriptionExpression subscriptionExpr;
        PyExpression operand;
        Collection<String> operandNames;
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(70);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(71);
        }
        if (element instanceof PySubscriptionExpression && (operandNames = PyTypingTypeProvider.resolveToQualifiedNames(operand = (subscriptionExpr = (PySubscriptionExpression)element).getOperand(), context.getTypeContext())).contains("typing.Union")) {
            return PyUnionType.union(PyTypingTypeProvider.getIndexTypes(subscriptionExpr, context));
        }
        return null;
    }

    @Nullable
    private static PyGenericType getGenericTypeFromTypeVar(@NotNull PsiElement element, @NotNull Context context) {
        PyExpression firstArgument;
        PyExpression[] arguments;
        Collection<String> calleeQNames;
        PyCallExpression assignedCall;
        PyExpression callee;
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(72);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(73);
        }
        if (element instanceof PyCallExpression && (callee = (assignedCall = (PyCallExpression)element).getCallee()) != null && (calleeQNames = PyTypingTypeProvider.resolveToQualifiedNames(callee, context.getTypeContext())).contains("typing.TypeVar") && (arguments = assignedCall.getArguments()).length > 0 && (firstArgument = arguments[0]) instanceof PyStringLiteralExpression) {
            String name = ((PyStringLiteralExpression)firstArgument).getStringValue();
            return new PyGenericType(name, PyTypingTypeProvider.getGenericTypeBound(arguments, context));
        }
        return null;
    }

    @Nullable
    private static PyType getGenericTypeBound(@NotNull PyExpression[] typeVarArguments, @NotNull Context context) {
        if (typeVarArguments == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(74);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(75);
        }
        ArrayList<PyType> types = new ArrayList<PyType>();
        for (int i = 1; i < typeVarArguments.length; ++i) {
            types.add((PyType)Ref.deref(PyTypingTypeProvider.getType(typeVarArguments[i], context)));
        }
        return PyUnionType.union(types);
    }

    @NotNull
    private static List<PyType> getIndexTypes(@NotNull PySubscriptionExpression expression, @NotNull Context context) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(76);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(77);
        }
        ArrayList<PyType> types = new ArrayList<PyType>();
        PyExpression indexExpr = expression.getIndexExpression();
        if (indexExpr instanceof PyTupleExpression) {
            PyTupleExpression tupleExpr = (PyTupleExpression)indexExpr;
            for (PyExpression expr : tupleExpr.getElements()) {
                types.add((PyType)Ref.deref(PyTypingTypeProvider.getType(expr, context)));
            }
        } else if (indexExpr != null) {
            types.add((PyType)Ref.deref(PyTypingTypeProvider.getType(indexExpr, context)));
        }
        ArrayList<PyType> arrayList = types;
        if (arrayList == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(78);
        }
        return arrayList;
    }

    @Nullable
    private static PyType getParameterizedType(@NotNull PsiElement element, @NotNull Context context) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(79);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(80);
        }
        if (element instanceof PySubscriptionExpression) {
            PySubscriptionExpression subscriptionExpr = (PySubscriptionExpression)element;
            PyExpression operand = subscriptionExpr.getOperand();
            PyExpression indexExpr = subscriptionExpr.getIndexExpression();
            PyType operandType = (PyType)Ref.deref(PyTypingTypeProvider.getType(operand, context));
            if (operandType instanceof PyClassType) {
                PyClass cls = ((PyClassType)operandType).getPyClass();
                List<PyType> indexTypes = PyTypingTypeProvider.getIndexTypes(subscriptionExpr, context);
                if ("tuple".equals(cls.getQualifiedName())) {
                    PyExpression[] elements;
                    if (indexExpr instanceof PyTupleExpression && (elements = ((PyTupleExpression)indexExpr).getElements()).length == 2 && PyTypingTypeProvider.isEllipsis(elements[1])) {
                        return PyTupleType.createHomogeneous(element, indexTypes.get(0));
                    }
                    return PyTupleType.create(element, indexTypes);
                }
                if (indexExpr != null) {
                    return new PyCollectionTypeImpl(cls, false, indexTypes);
                }
            }
        }
        return null;
    }

    @Nullable
    private static PyType getBuiltinCollection(@NotNull PsiElement element, @NotNull TypeEvalContext context) {
        String collectionName;
        String builtinName;
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(81);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(82);
        }
        return (builtinName = (String)COLLECTION_CLASSES.get((Object)(collectionName = PyTypingTypeProvider.getQualifiedName(element)))) != null ? PyTypeParser.getTypeByName(element, builtinName, context) : null;
    }

    @NotNull
    private static List<PsiElement> tryResolving(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(83);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(84);
        }
        ArrayList elements = Lists.newArrayList();
        if (expression instanceof PyReferenceExpression) {
            List<PsiElement> results;
            if (context.maySwitchToAST((PsiElement)expression)) {
                PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(context);
                results = PyUtil.multiResolveTopPriority((PsiElement)expression, resolveContext);
            } else {
                results = PyTypingTypeProvider.tryResolvingOnStubs((PyReferenceExpression)expression, context);
            }
            for (PsiElement element : results) {
                QualifiedName osPathLikeQName;
                PsiElement osPathLike;
                PyTargetExpression targetExpr;
                PyExpression assignedValue;
                String name;
                PyClass cls;
                PyFunction function;
                if (element instanceof PyFunction && PyUtil.isInit(function = (PyFunction)element) && (cls = function.getContainingClass()) != null) {
                    elements.add(cls);
                    continue;
                }
                String string = name = element != null ? PyTypingTypeProvider.getQualifiedName(element) : null;
                if (name != null && OPAQUE_NAMES.contains((Object)name)) {
                    elements.add(element);
                    continue;
                }
                if (element instanceof PyTargetExpression && (assignedValue = context.maySwitchToAST(targetExpr = (PyTargetExpression)element) ? targetExpr.findAssignedValue() : PyTypingAliasStubType.getAssignedValueStubLike(targetExpr)) != null) {
                    elements.add(assignedValue);
                    continue;
                }
                if (PyTypingTypeProvider.isBuiltinPathLike(element) && (osPathLike = PyResolveImportUtil.resolveTopLevelMember(osPathLikeQName = QualifiedName.fromComponents((String[])new String[]{"os", "PathLike"}), PyResolveImportUtil.fromFoothold(element))) != null) {
                    elements.add(osPathLike);
                    continue;
                }
                if (element == null) continue;
                elements.add(element);
            }
        }
        List<Object> list2 = !elements.isEmpty() ? elements : Collections.singletonList(expression);
        if (list2 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(85);
        }
        return list2;
    }

    @NotNull
    private static List<PsiElement> tryResolvingOnStubs(@NotNull PyReferenceExpression expression, @NotNull TypeEvalContext context) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(86);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(87);
        }
        QualifiedName qualifiedName = expression.asQualifiedName();
        PyFile pyFile = PyUtil.as(FileContextUtil.getContextFile((PsiElement)expression), PyFile.class);
        if (pyFile != null && qualifiedName != null) {
            List<PsiElement> list2 = PyResolveUtil.resolveQualifiedNameInFile(qualifiedName, pyFile, context);
            if (list2 == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(88);
            }
            return list2;
        }
        List<PyReferenceExpression> list3 = Collections.singletonList(expression);
        if (list3 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(89);
        }
        return list3;
    }

    private static boolean isBuiltinPathLike(@Nullable PsiElement element) {
        return element instanceof PyClass && PyBuiltinCache.getInstance(element).isBuiltin(element) && "_PathLike".equals(((PyClass)element).getName());
    }

    @NotNull
    private static Collection<String> resolveToQualifiedNames(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(90);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(91);
        }
        LinkedHashSet names = Sets.newLinkedHashSet();
        for (PsiElement resolved : PyTypingTypeProvider.tryResolving(expression, context)) {
            String name = PyTypingTypeProvider.getQualifiedName(resolved);
            if (name == null) continue;
            names.add(name);
        }
        LinkedHashSet linkedHashSet = names;
        if (linkedHashSet == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(92);
        }
        return linkedHashSet;
    }

    @Nullable
    private static String getQualifiedName(@NotNull PsiElement element) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(93);
        }
        if (element instanceof PyQualifiedNameOwner) {
            PyQualifiedNameOwner qualifiedNameOwner = (PyQualifiedNameOwner)element;
            return qualifiedNameOwner.getQualifiedName();
        }
        return null;
    }

    @Nullable
    public static PyType toAsyncIfNeeded(@NotNull PyFunction function, @Nullable PyType returnType) {
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(94);
        }
        if (function.isAsync() && function.isAsyncAllowed()) {
            if (!function.isGenerator()) {
                return PyTypingTypeProvider.wrapInCoroutineType(returnType, function);
            }
            if (returnType instanceof PyClassLikeType && returnType instanceof PyCollectionType && GENERATOR.equals(((PyClassLikeType)returnType).getClassQName())) {
                return PyTypingTypeProvider.wrapInAsyncGeneratorType(((PyCollectionType)returnType).getIteratedItemType(), function);
            }
        }
        return returnType;
    }

    @Nullable
    private static PyType wrapInCoroutineType(@Nullable PyType returnType, @NotNull PsiElement resolveAnchor) {
        PyClass coroutine;
        if (resolveAnchor == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(95);
        }
        return (coroutine = PyUtil.as(PyResolveImportUtil.resolveTopLevelMember(QualifiedName.fromDottedString((String)COROUTINE), PyResolveImportUtil.fromFoothold(resolveAnchor)), PyClass.class)) != null ? new PyCollectionTypeImpl(coroutine, false, Arrays.asList(null, null, returnType)) : null;
    }

    @Nullable
    public static PyType wrapInGeneratorType(@Nullable PyType elementType, @Nullable PyType returnType, @NotNull PsiElement anchor) {
        PyClass generator;
        if (anchor == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(96);
        }
        return (generator = PyUtil.as(PyResolveImportUtil.resolveTopLevelMember(QualifiedName.fromDottedString((String)GENERATOR), PyResolveImportUtil.fromFoothold(anchor)), PyClass.class)) != null ? new PyCollectionTypeImpl(generator, false, Arrays.asList(elementType, null, returnType)) : null;
    }

    @Nullable
    private static PyType wrapInAsyncGeneratorType(@Nullable PyType elementType, @NotNull PsiElement anchor) {
        PyClass asyncGenerator;
        if (anchor == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(97);
        }
        return (asyncGenerator = PyUtil.as(PyResolveImportUtil.resolveTopLevelMember(QualifiedName.fromDottedString((String)ASYNC_GENERATOR), PyResolveImportUtil.fromFoothold(anchor)), PyClass.class)) != null ? new PyCollectionTypeImpl(asyncGenerator, false, Arrays.asList(elementType, null)) : null;
    }

    @Deprecated
    @Nullable
    public static Ref<PyType> coroutineOrGeneratorElementType(@Nullable PyType coroutineOrGeneratorType, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(98);
        }
        return PyTypingTypeProvider.coroutineOrGeneratorElementType(coroutineOrGeneratorType);
    }

    @Nullable
    public static Ref<PyType> coroutineOrGeneratorElementType(@Nullable PyType coroutineOrGeneratorType) {
        PyCollectionType genericType = PyUtil.as(coroutineOrGeneratorType, PyCollectionType.class);
        PyClassType classType = PyUtil.as(coroutineOrGeneratorType, PyClassType.class);
        if (genericType != null && classType != null && ArrayUtil.contains((String)classType.getClassQName(), (String[])new String[]{COROUTINE, GENERATOR})) {
            return Ref.create((Object)ContainerUtil.getOrElse(genericType.getElementTypes(), (int)2, null));
        }
        return null;
    }

    @NotNull
    public static Ref<PyType> getOpenFunctionCallType(@NotNull PyFunction function, @NotNull PyCallExpression call, @NotNull LanguageLevel typeLevel, @NotNull TypeEvalContext context) {
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(99);
        }
        if (call == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(100);
        }
        if (typeLevel == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(101);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(102);
        }
        String type = typeLevel.isPython2() ? "typing.BinaryIO" : (PyTypingTypeProvider.getOpenMode(function, call, context).contains("b") ? "typing.BinaryIO" : PY3_TEXT_FILE_TYPE);
        Ref ref = Ref.create((Object)PyTypeParser.getTypeByName((PsiElement)call, type, context));
        if (ref == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(103);
        }
        return ref;
    }

    @NotNull
    private static String getOpenMode(@NotNull PyFunction function, @NotNull PyCallExpression call, @NotNull TypeEvalContext context) {
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(104);
        }
        if (call == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(105);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(106);
        }
        Map<PyExpression, PyCallableParameter> arguments = PyCallExpressionHelper.mapArguments((PyCallSiteExpression)call, function, context).getMappedParameters();
        for (Map.Entry<PyExpression, PyCallableParameter> entry : arguments.entrySet()) {
            if (!"mode".equals(entry.getValue().getName())) continue;
            PyExpression argument = entry.getKey();
            if (argument instanceof PyKeywordArgument) {
                argument = ((PyKeywordArgument)argument).getValueExpression();
            }
            if (!(argument instanceof PyStringLiteralExpression)) break;
            String string = ((PyStringLiteralExpression)argument).getStringValue();
            if (string == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(107);
            }
            return string;
        }
        if ("r" == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(108);
        }
        return "r";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 36: 
            case 39: 
            case 40: 
            case 78: 
            case 85: 
            case 88: 
            case 89: 
            case 92: 
            case 103: 
            case 107: 
            case 108: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 36: 
            case 39: 
            case 40: 
            case 78: 
            case 85: 
            case 88: 
            case 89: 
            case 92: 
            case 103: 
            case 107: 
            case 108: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 16: 
            case 20: 
            case 23: 
            case 26: 
            case 28: 
            case 32: 
            case 38: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 51: 
            case 53: 
            case 55: 
            case 58: 
            case 61: 
            case 63: 
            case 66: 
            case 68: 
            case 71: 
            case 73: 
            case 75: 
            case 77: 
            case 80: 
            case 82: 
            case 84: 
            case 87: 
            case 91: 
            case 98: 
            case 102: 
            case 106: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
            case 5: 
            case 43: 
            case 76: 
            case 83: 
            case 86: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 11: 
            case 12: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 36: 
            case 39: 
            case 40: 
            case 78: 
            case 85: 
            case 88: 
            case 89: 
            case 92: 
            case 103: 
            case 107: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/typing/PyTypingTypeProvider";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 94: 
            case 99: 
            case 104: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceTarget";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 25: 
            case 27: 
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 45: 
            case 47: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 49: 
            case 50: 
            case 52: 
            case 62: 
            case 70: 
            case 72: 
            case 79: 
            case 81: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 56: 
            case 59: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 57: 
            case 60: 
            case 65: 
            case 96: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersExpr";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeVarArguments";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveAnchor";
                break;
            }
            case 100: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/typing/PyTypingTypeProvider";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypingGenericType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypingProtocolType";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericSubstitutions";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedSuperClassesAndTypeParameters";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubscriptionIndices";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "collectGenericTypes";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexTypes";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "tryResolving";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "tryResolvingOnStubs";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToQualifiedNames";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenFunctionCallType";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceExpressionType";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getParameterType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getParameterTypeFromFunctionComment";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getParameterTypeFromTypeComment";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getParameterTypeFromAnnotation";
                break;
            }
            case 11: 
            case 12: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 36: 
            case 39: 
            case 40: 
            case 78: 
            case 85: 
            case 88: 
            case 89: 
            case 92: 
            case 103: 
            case 107: 
            case 108: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "omitFirstParamInTypeComment";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeAnnotation";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionTypeAnnotation";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCallType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromTargetExpressionAnnotation";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCommentValue";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getGenericType";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getGenericSubstitutions";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedSuperClassesAndTypeParameters";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getSubscriptionIndices";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "collectGenericTypes";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isGeneric";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getTypeForResolvedElement";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getClassObjectType";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getAnyType";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getClassType";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getOptionalType";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationValue";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getStringBasedType";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getStringLiteralType";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getVariableTypeCommentType";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getCallableType";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "isEllipsis";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getUnionType";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getGenericTypeFromTypeVar";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getGenericTypeBound";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getIndexTypes";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getParameterizedType";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getBuiltinCollection";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "tryResolving";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "tryResolvingOnStubs";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "resolveToQualifiedNames";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "toAsyncIfNeeded";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "wrapInCoroutineType";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "wrapInGeneratorType";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "wrapInAsyncGeneratorType";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "coroutineOrGeneratorElementType";
                break;
            }
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "getOpenFunctionCallType";
                break;
            }
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "getOpenMode";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getVariableTypeCommentType$16";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectGenericTypes$13";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getGenericSubstitutions$10";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getCallType$3";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFunctionTypeAnnotation$1";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getParameterTypeFromAnnotation$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 36: 
            case 39: 
            case 40: 
            case 78: 
            case 85: 
            case 88: 
            case 89: 
            case 92: 
            case 103: 
            case 107: 
            case 108: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Context {
        @NotNull
        private final TypeEvalContext myContext;
        @NotNull
        private final Set<PsiElement> myCache;

        private Context(@NotNull TypeEvalContext context) {
            if (context == null) {
                Context.$$$reportNull$$$0(0);
            }
            this.myCache = new HashSet();
            this.myContext = context;
        }

        @NotNull
        public TypeEvalContext getTypeContext() {
            TypeEvalContext typeEvalContext = this.myContext;
            if (typeEvalContext == null) {
                Context.$$$reportNull$$$0(1);
            }
            return typeEvalContext;
        }

        @NotNull
        public Set<PsiElement> getExpressionCache() {
            Set<PsiElement> set2 = this.myCache;
            if (set2 == null) {
                Context.$$$reportNull$$$0(2);
            }
            return set2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/codeInsight/typing/PyTypingTypeProvider$Context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/codeInsight/typing/PyTypingTypeProvider$Context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExpressionCache";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

