/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.python.debugger.PyDebugSupportUtils;
import com.jetbrains.python.debugger.PyPositionConverter;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PySourcePosition;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyLocalPositionConverter
implements PyPositionConverter {
    private static final String[] EGG_EXTENSIONS = new String[]{".egg", ".zip"};

    @NotNull
    public final PySourcePosition create(@NotNull String filePath, int line) {
        File file2;
        if (filePath == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(0);
        }
        if ((file2 = new File(filePath)).exists()) {
            PyLocalSourcePosition pyLocalSourcePosition = new PyLocalSourcePosition(file2.getPath(), line);
            if (pyLocalSourcePosition == null) {
                PyLocalPositionConverter.$$$reportNull$$$0(1);
            }
            return pyLocalSourcePosition;
        }
        PyRemoteSourcePosition pyRemoteSourcePosition = new PyRemoteSourcePosition(filePath, line);
        if (pyRemoteSourcePosition == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(2);
        }
        return pyRemoteSourcePosition;
    }

    @NotNull
    public final PySourcePosition convertToPython(@NotNull XSourcePosition position) {
        if (position == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(3);
        }
        PySourcePosition pySourcePosition = this.convertToPython(PyLocalPositionConverter.convertFilePath(position.getFile().getPath()), PyLocalPositionConverter.convertLocalLineToRemote(position.getFile(), position.getLine()));
        if (pySourcePosition == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(4);
        }
        return pySourcePosition;
    }

    @NotNull
    protected PySourcePosition convertToPython(@NotNull String filePath, int line) {
        if (filePath == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(5);
        }
        PyLocalSourcePosition pyLocalSourcePosition = new PyLocalSourcePosition(filePath, line);
        if (pyLocalSourcePosition == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(6);
        }
        return pyLocalSourcePosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int convertLocalLineToRemote(VirtualFile file2, int line) {
        AccessToken lock = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            Document document = FileDocumentManager.getInstance().getDocument(file2);
            if (document != null) {
                while (PyDebugSupportUtils.isContinuationLine(document, line)) {
                    ++line;
                }
            }
            int n = line + 1;
            return n;
        }
        finally {
            lock.finish();
        }
    }

    @Nullable
    public XSourcePosition convertFromPython(@NotNull PySourcePosition position, String frameName) {
        if (position == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(7);
        }
        return PyLocalPositionConverter.createXSourcePosition(this.getVirtualFile(position.getFile()), position.getLine());
    }

    public PySignature convertSignature(PySignature signature) {
        return signature;
    }

    public VirtualFile getVirtualFile(String path) {
        VirtualFile vFile = this.getLocalFileSystem().findFileByPath(path);
        if (vFile == null) {
            vFile = this.findEggEntry(path);
        }
        return vFile;
    }

    protected VirtualFileSystem getLocalFileSystem() {
        return LocalFileSystem.getInstance();
    }

    private VirtualFile findEggEntry(String file2) {
        String ext;
        int ind = -1;
        String[] stringArray = EGG_EXTENSIONS;
        int n = stringArray.length;
        for (int i = 0; i < n && (ind = file2.indexOf(ext = stringArray[i])) == -1; ++i) {
        }
        if (ind != -1) {
            String jarPath = file2.substring(0, ind + 4);
            VirtualFile jarFile = this.getLocalFileSystem().findFileByPath(jarPath);
            if (jarFile != null) {
                String innerPath = file2.substring(ind + 4);
                VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(jarFile);
                if (jarRoot != null) {
                    return jarRoot.findFileByRelativePath(innerPath);
                }
            }
        }
        return null;
    }

    private static String convertFilePath(String file2) {
        String ext;
        int ind = -1;
        String[] stringArray = EGG_EXTENSIONS;
        int n = stringArray.length;
        for (int i = 0; i < n && (ind = file2.indexOf((ext = stringArray[i]) + "!")) == -1; ++i) {
        }
        if (ind != -1) {
            return file2.substring(0, ind + 4) + file2.substring(ind + 5);
        }
        return file2;
    }

    private static String winNormCase(String file2) {
        String ext;
        int ind = -1;
        String[] stringArray = EGG_EXTENSIONS;
        int n = stringArray.length;
        for (int i = 0; i < n && (ind = file2.indexOf(ext = stringArray[i])) == -1; ++i) {
        }
        if (ind != -1) {
            return file2.substring(0, ind + 4).toLowerCase() + file2.substring(ind + 4);
        }
        return file2.toLowerCase();
    }

    @Nullable
    protected static XSourcePosition createXSourcePosition(@Nullable VirtualFile vFile, int line) {
        if (vFile != null) {
            return XDebuggerUtil.getInstance().createPosition(vFile, PyLocalPositionConverter.convertRemoteLineToLocal(vFile, line));
        }
        return null;
    }

    private static int convertRemoteLineToLocal(VirtualFile vFile, int line) {
        Document document = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(vFile));
        --line;
        if (document != null) {
            while (PyDebugSupportUtils.isContinuationLine(document, line - 1)) {
                --line;
            }
        }
        return line;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/PyLocalPositionConverter";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/PyLocalPositionConverter";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToPython";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "convertToPython";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convertFromPython";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class PyRemoteSourcePosition
    extends PySourcePosition {
        public PyRemoteSourcePosition(String file2, int line) {
            super(file2, line);
        }

        protected String normalize(@Nullable String file2) {
            if (file2 == null) {
                return null;
            }
            if (SystemInfo.isWindows && PyRemoteSourcePosition.isWindowsPath((String)file2)) {
                file2 = PyLocalPositionConverter.winNormCase(file2);
            }
            return super.normalize(file2);
        }
    }

    protected static class PyLocalSourcePosition
    extends PySourcePosition {
        public PyLocalSourcePosition(String file2, int line) {
            super(file2, line);
        }

        protected String normalize(@Nullable String file2) {
            if (file2 == null) {
                return null;
            }
            if (SystemInfo.isWindows) {
                file2 = PyLocalPositionConverter.winNormCase(file2);
            }
            return super.normalize(file2);
        }
    }
}

