/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyBroadExceptionInspection;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.AddCallSuperQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Optional;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyMissingConstructorInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.missing.super.constructor", new Object[0]);
        if (string == null) {
            PyMissingConstructorInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        if (holder == null) {
            PyMissingConstructorInspection.$$$reportNull$$$0(1);
        }
        if (session2 == null) {
            PyMissingConstructorInspection.$$$reportNull$$$0(2);
        }
        Visitor visitor2 = new Visitor(holder, session2);
        if (visitor2 == null) {
            PyMissingConstructorInspection.$$$reportNull$$$0(3);
        }
        return visitor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyMissingConstructorInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyMissingConstructorInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session2) {
            if (session2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session2);
        }

        @Override
        public void visitPyClass(@NotNull PyClass node) {
            PyExpression[] superClasses;
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if ((superClasses = node.getSuperClassExpressions()).length == 0 || superClasses.length == 1 && "object".equals(superClasses[0].getText()) || !Visitor.superHasConstructor(node, this.myTypeEvalContext)) {
                return;
            }
            PyFunction initMethod = node.findMethodByName("__init__", false, this.myTypeEvalContext);
            if (initMethod == null || Visitor.isExceptionClass(node, this.myTypeEvalContext) || Visitor.hasConstructorCall(node, initMethod, this.myTypeEvalContext)) {
                return;
            }
            if (superClasses.length == 1 || node.isNewStyleClass(this.myTypeEvalContext)) {
                this.registerProblem(initMethod.getNameIdentifier(), PyBundle.message("INSP.missing.super.constructor.message", new Object[0]), new AddCallSuperQuickFix());
            } else {
                this.registerProblem(initMethod.getNameIdentifier(), PyBundle.message("INSP.missing.super.constructor.message", new Object[0]));
            }
        }

        private static boolean superHasConstructor(@NotNull PyClass cls, @NotNull TypeEvalContext context) {
            if (cls == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if (context == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            String className = cls.getName();
            for (PyClass baseClass : cls.getAncestorClasses(context)) {
                if (PyUtil.isObjectClass(baseClass) || Comparing.equal((String)className, (String)baseClass.getName()) || baseClass.findMethodByName("__init__", false, context) == null) continue;
                return true;
            }
            return false;
        }

        private static boolean isExceptionClass(@NotNull PyClass cls, @NotNull TypeEvalContext context) {
            if (cls == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            if (context == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            if (PyBroadExceptionInspection.equalsException(cls, context)) {
                return true;
            }
            return cls.getAncestorClasses(context).stream().filter(baseClass -> {
                if (context == null) {
                    Visitor.$$$reportNull$$$0(9);
                }
                return PyBroadExceptionInspection.equalsException(baseClass, context);
            }).findAny().isPresent();
        }

        private static boolean hasConstructorCall(@NotNull PyClass cls, @NotNull PyFunction initMethod, @NotNull TypeEvalContext context) {
            if (cls == null) {
                Visitor.$$$reportNull$$$0(6);
            }
            if (initMethod == null) {
                Visitor.$$$reportNull$$$0(7);
            }
            if (context == null) {
                Visitor.$$$reportNull$$$0(8);
            }
            CallVisitor visitor2 = new CallVisitor(cls, context);
            initMethod.getStatementList().accept(visitor2);
            return visitor2.myHasConstructorCall;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cls";
                    break;
                }
                case 3: 
                case 5: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initMethod";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyMissingConstructorInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyClass";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "superHasConstructor";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isExceptionClass";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasConstructorCall";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$isExceptionClass$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class CallVisitor
        extends PyRecursiveElementVisitor {
            @NotNull
            private final PyClass myClass;
            @NotNull
            private final TypeEvalContext myContext;
            private boolean myHasConstructorCall;

            public CallVisitor(@NotNull PyClass cls, @NotNull TypeEvalContext context) {
                if (cls == null) {
                    CallVisitor.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    CallVisitor.$$$reportNull$$$0(1);
                }
                this.myHasConstructorCall = false;
                this.myClass = cls;
                this.myContext = context;
            }

            @Override
            public void visitPyCallExpression(@NotNull PyCallExpression node) {
                if (node == null) {
                    CallVisitor.$$$reportNull$$$0(2);
                }
                if (CallVisitor.isConstructorCall(node, this.myClass, this.myContext)) {
                    this.myHasConstructorCall = true;
                }
            }

            private static boolean isConstructorCall(@NotNull PyCallExpression call, @NotNull PyClass cls, @NotNull TypeEvalContext context) {
                PyExpression callee;
                if (call == null) {
                    CallVisitor.$$$reportNull$$$0(3);
                }
                if (cls == null) {
                    CallVisitor.$$$reportNull$$$0(4);
                }
                if (context == null) {
                    CallVisitor.$$$reportNull$$$0(5);
                }
                if ((callee = call.getCallee()) == null || !"__init__".equals(callee.getName())) {
                    return false;
                }
                PyExpression calleeQualifier = Optional.of(callee).filter(PyQualifiedExpression.class::isInstance).map(PyQualifiedExpression.class::cast).map(PyQualifiedExpression::getQualifier).orElse(null);
                return calleeQualifier != null && (CallVisitor.isSuperCall(calleeQualifier, cls, context) || CallVisitor.isSuperClassCall(calleeQualifier, cls, context));
            }

            private static boolean isSuperCall(@NotNull PyExpression calleeQualifier, @NotNull PyClass cls, @NotNull TypeEvalContext context) {
                if (calleeQualifier == null) {
                    CallVisitor.$$$reportNull$$$0(6);
                }
                if (cls == null) {
                    CallVisitor.$$$reportNull$$$0(7);
                }
                if (context == null) {
                    CallVisitor.$$$reportNull$$$0(8);
                }
                String prevCalleeName = Optional.of(calleeQualifier).filter(PyCallExpression.class::isInstance).map(PyCallExpression.class::cast).map(PyCallExpression::getCallee).map(NavigationItem::getName).orElse(null);
                if (!"super".equals(prevCalleeName)) {
                    return false;
                }
                PyExpression[] args = ((PyCallExpression)calleeQualifier).getArguments();
                if (args.length == 0) {
                    return true;
                }
                String firstArg = args[0].getText();
                String classQName = cls.getQualifiedName();
                if (firstArg.equals(cls.getName()) || firstArg.equals("self.__class__") || classQName != null && classQName.endsWith(firstArg) || firstArg.equals("__class__") && LanguageLevel.forElement((PsiElement)cls).isAtLeast(LanguageLevel.PYTHON30)) {
                    return true;
                }
                return cls.getAncestorClasses(context).stream().map(NavigationItem::getName).filter(firstArg::equals).findAny().isPresent();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private static boolean isSuperClassCall(@NotNull PyExpression calleeQualifier, @NotNull PyClass cls, @NotNull TypeEvalContext context) {
                PsiElement callingClass;
                if (calleeQualifier == null) {
                    CallVisitor.$$$reportNull$$$0(9);
                }
                if (cls == null) {
                    CallVisitor.$$$reportNull$$$0(10);
                }
                if (context == null) {
                    CallVisitor.$$$reportNull$$$0(11);
                }
                if ((callingClass = CallVisitor.resolveCallingClass(calleeQualifier)) == null) return false;
                if (!cls.getAncestorClasses(context).stream().filter(callingClass::equals).findAny().isPresent()) return false;
                return true;
            }

            @Nullable
            private static PsiElement resolveCallingClass(@NotNull PyExpression calleeQualifier) {
                if (calleeQualifier == null) {
                    CallVisitor.$$$reportNull$$$0(12);
                }
                if (calleeQualifier instanceof PyCallExpression) {
                    return Optional.of((PyCallExpression)calleeQualifier).map(PyCallExpression::getCallee).map(PsiElement::getReference).map(PsiReference::resolve).orElse(null);
                }
                return Optional.ofNullable(calleeQualifier.getReference()).map(PsiReference::resolve).orElse(null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "cls";
                        break;
                    }
                    case 1: 
                    case 5: 
                    case 8: 
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "call";
                        break;
                    }
                    case 6: 
                    case 9: 
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "calleeQualifier";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/python/inspections/PyMissingConstructorInspection$Visitor$CallVisitor";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyCallExpression";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isConstructorCall";
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSuperCall";
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSuperClassCall";
                        break;
                    }
                    case 12: {
                        objectArray = objectArray2;
                        objectArray2[2] = "resolveCallingClass";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

