/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.ui;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.webcore.packaging.InstalledPackage;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackageManagementServiceEx;
import com.intellij.webcore.packaging.RepoPackage;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.packaging.PyPIPackageCache;
import com.jetbrains.python.packaging.PyPIPackageUtil;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageManagerUI;
import com.jetbrains.python.packaging.PyPackageService;
import com.jetbrains.python.packaging.PyPackageVersionComparator;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPackageManagementService
extends PackageManagementServiceEx {
    @NotNull
    private static final Pattern PATTERN_ERROR_LINE = Pattern.compile(".*error:.*", 2);
    @NonNls
    private static final String TEXT_PREFIX = PyPackageManagementService.buildHtmlStylePrefix();
    @NonNls
    private static final String TEXT_SUFFIX = "</body></html>";
    private final Project myProject;
    protected final Sdk mySdk;
    protected final ExecutorService myExecutorService;
    @NonNls
    private static final String HTML_PREFIX = "<a href=\"";
    @NonNls
    private static final String HTML_SUFFIX = "</a>";

    @NotNull
    private static String buildHtmlStylePrefix() {
        int fontSize = JBUI.scale((int)12);
        int m1 = JBUI.scale((int)2);
        int m2 = JBUI.scale((int)5);
        String string = String.format("<html><head>    <style type=\"text/css\">        p {            font-family: Arial,serif; font-size: %dpt; margin: %dpx %dpx        }    </style></head><body style=\"font-family: Arial,serif; font-size: %dpt; margin: %dpx %dpx;\">", fontSize, m1, m1, fontSize, m2, m2);
        if (string == null) {
            PyPackageManagementService.$$$reportNull$$$0(0);
        }
        return string;
    }

    public PyPackageManagementService(@NotNull Project project, @NotNull Sdk sdk) {
        if (project == null) {
            PyPackageManagementService.$$$reportNull$$$0(1);
        }
        if (sdk == null) {
            PyPackageManagementService.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.mySdk = sdk;
        this.myExecutorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"PyPackageManagementService pool", (int)4);
    }

    @NotNull
    public Sdk getSdk() {
        Sdk sdk = this.mySdk;
        if (sdk == null) {
            PyPackageManagementService.$$$reportNull$$$0(3);
        }
        return sdk;
    }

    @Override
    @Nullable
    public List<String> getAllRepositories() {
        PyPackageService packageService = PyPackageService.getInstance();
        ArrayList<String> result2 = new ArrayList<String>();
        if (!packageService.PYPI_REMOVED.booleanValue()) {
            result2.add("https://pypi.python.org/simple");
        }
        result2.addAll(packageService.additionalRepositories);
        return result2;
    }

    @Override
    public void addRepository(String repositoryUrl) {
        PyPackageService.getInstance().addRepository(repositoryUrl);
    }

    @Override
    public void removeRepository(String repositoryUrl) {
        PyPackageService.getInstance().removeRepository(repositoryUrl);
    }

    @Override
    @NotNull
    public List<RepoPackage> getAllPackages() throws IOException {
        PyPIPackageUtil.INSTANCE.loadAndGetPackages();
        PyPIPackageUtil.INSTANCE.loadAndGetAdditionalPackages(false);
        List<RepoPackage> list2 = this.getAllPackagesCached();
        if (list2 == null) {
            PyPackageManagementService.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<RepoPackage> reloadAllPackages() throws IOException {
        PyPIPackageUtil.INSTANCE.updatePyPICache();
        PyPIPackageUtil.INSTANCE.loadAndGetAdditionalPackages(true);
        List<RepoPackage> list2 = this.getAllPackagesCached();
        if (list2 == null) {
            PyPackageManagementService.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<RepoPackage> getAllPackagesCached() {
        ArrayList<RepoPackage> result2 = new ArrayList<RepoPackage>();
        if (!PyPackageService.getInstance().PYPI_REMOVED.booleanValue()) {
            result2.addAll(PyPackageManagementService.getCachedPyPIPackages());
        }
        result2.addAll(PyPIPackageUtil.INSTANCE.getAdditionalPackages());
        ArrayList<RepoPackage> arrayList = result2;
        if (arrayList == null) {
            PyPackageManagementService.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    private static List<RepoPackage> getCachedPyPIPackages() {
        boolean customRepoConfigured = !PyPackageService.getInstance().additionalRepositories.isEmpty();
        String url = customRepoConfigured ? "https://pypi.python.org/simple" : "";
        List list2 = ContainerUtil.map(PyPIPackageCache.getInstance().getPackageNames(), name -> new RepoPackage((String)name, url, null));
        if (list2 == null) {
            PyPackageManagementService.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @Override
    public boolean canInstallToUser() {
        return !PythonSdkType.isVirtualEnv(this.mySdk);
    }

    @Override
    @NotNull
    public String getInstallToUserText() {
        String userSiteText = "Install to user's site packages directory";
        if (!PythonSdkType.isRemote(this.mySdk)) {
            userSiteText = userSiteText + " (" + PySdkUtil.getUserSite() + ")";
        }
        String string = userSiteText;
        if (string == null) {
            PyPackageManagementService.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    public boolean isInstallToUserSelected() {
        return PyPackageService.getInstance().useUserSite(this.mySdk.getHomePath());
    }

    @Override
    public void installToUserChanged(boolean newValue) {
        PyPackageService.getInstance().addSdkToUserSite(this.mySdk.getHomePath(), newValue);
    }

    @Override
    @NotNull
    public Collection<InstalledPackage> getInstalledPackages() throws IOException {
        ArrayList packages;
        PyPackageManager manager = PyPackageManager.getInstance(this.mySdk);
        try {
            packages = Lists.newArrayList(manager.refreshAndGetPackages(true));
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        Collections.sort(packages, Comparator.comparing(InstalledPackage::getName));
        ArrayList<InstalledPackage> arrayList = new ArrayList<InstalledPackage>(packages);
        if (arrayList == null) {
            PyPackageManagementService.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Override
    public void installPackage(@NotNull RepoPackage repoPackage, @Nullable String version, boolean forceUpgrade, @Nullable String extraOptions, final @NotNull PackageManagementService.Listener listener2, boolean installToUser) {
        if (repoPackage == null) {
            PyPackageManagementService.$$$reportNull$$$0(10);
        }
        if (listener2 == null) {
            PyPackageManagementService.$$$reportNull$$$0(11);
        }
        final String packageName = repoPackage.getName();
        String repository = PyPIPackageUtil.isPyPIRepository(repoPackage.getRepoUrl()) ? null : repoPackage.getRepoUrl();
        ArrayList<String> extraArgs = new ArrayList<String>();
        if (installToUser) {
            extraArgs.add("--user");
        }
        if (extraOptions != null) {
            Collections.addAll(extraArgs, extraOptions.split(" +"));
        }
        if (!StringUtil.isEmptyOrSpaces((String)repository)) {
            extraArgs.add("--index-url");
            extraArgs.add(repository);
        }
        if (forceUpgrade) {
            extraArgs.add("-U");
        }
        PyRequirement req = version != null ? new PyRequirement(packageName, version) : new PyRequirement(packageName);
        PyPackageManagerUI ui = new PyPackageManagerUI(this.myProject, this.mySdk, new PyPackageManagerUI.Listener(){

            @Override
            public void started() {
                listener2.operationStarted(packageName);
            }

            @Override
            public void finished(@Nullable List<ExecutionException> exceptions) {
                listener2.operationFinished(packageName, PyPackageManagementService.toErrorDescription(exceptions, PyPackageManagementService.this.mySdk));
            }
        });
        ui.install(Collections.singletonList(req), extraArgs);
    }

    @Nullable
    public static PackageManagementService.ErrorDescription toErrorDescription(@Nullable List<ExecutionException> exceptions, @Nullable Sdk sdk) {
        if (exceptions != null && !exceptions.isEmpty() && !PyPackageManagementService.isCancelled(exceptions)) {
            return PyPackageManagementService.createDescription(exceptions.get(0), sdk);
        }
        return null;
    }

    @Override
    public void uninstallPackages(@NotNull List<InstalledPackage> installedPackages, final @NotNull PackageManagementService.Listener listener2) {
        if (installedPackages == null) {
            PyPackageManagementService.$$$reportNull$$$0(12);
        }
        if (listener2 == null) {
            PyPackageManagementService.$$$reportNull$$$0(13);
        }
        final String packageName = installedPackages.size() == 1 ? installedPackages.get(0).getName() : null;
        PyPackageManagerUI ui = new PyPackageManagerUI(this.myProject, this.mySdk, new PyPackageManagerUI.Listener(){

            @Override
            public void started() {
                listener2.operationStarted(packageName);
            }

            @Override
            public void finished(List<ExecutionException> exceptions) {
                listener2.operationFinished(packageName, PyPackageManagementService.toErrorDescription(exceptions, PyPackageManagementService.this.mySdk));
            }
        });
        ArrayList<PyPackage> pyPackages = new ArrayList<PyPackage>();
        for (InstalledPackage aPackage : installedPackages) {
            if (!(aPackage instanceof PyPackage)) continue;
            pyPackages.add((PyPackage)aPackage);
        }
        ui.uninstall(pyPackages);
    }

    @Override
    public void fetchPackageVersions(String packageName, CatchingConsumer<List<String>, Exception> consumer) {
        PyPIPackageUtil.INSTANCE.usePackageReleases(packageName, consumer);
    }

    @Override
    public void fetchPackageDetails(@NotNull String packageName, final @NotNull CatchingConsumer<String, Exception> consumer) {
        if (packageName == null) {
            PyPackageManagementService.$$$reportNull$$$0(14);
        }
        if (consumer == null) {
            PyPackageManagementService.$$$reportNull$$$0(15);
        }
        PyPIPackageUtil.INSTANCE.fillPackageDetails(packageName, new CatchingConsumer<PyPIPackageUtil.PackageDetails.Info, Exception>(){

            public void consume(PyPIPackageUtil.PackageDetails.Info details) {
                consumer.consume((Object)PyPackageManagementService.formatPackageInfo(details));
            }

            public void consume(Exception e) {
                consumer.consume((Throwable)e);
            }
        });
    }

    private static String formatPackageInfo(@NotNull PyPIPackageUtil.PackageDetails.Info info) {
        String homePage;
        String authorEmail;
        String author;
        String version;
        if (info == null) {
            PyPackageManagementService.$$$reportNull$$$0(16);
        }
        StringBuilder stringBuilder = new StringBuilder(TEXT_PREFIX);
        String description = info.getSummary();
        if (StringUtil.isNotEmpty((String)description)) {
            stringBuilder.append(description).append("<br/>");
        }
        if (StringUtil.isNotEmpty((String)(version = info.getVersion()))) {
            stringBuilder.append("<h4>Version</h4>");
            stringBuilder.append(version);
        }
        if (StringUtil.isNotEmpty((String)(author = info.getAuthor()))) {
            stringBuilder.append("<h4>Author</h4>");
            stringBuilder.append(author).append("<br/><br/>");
        }
        if (StringUtil.isNotEmpty((String)(authorEmail = info.getAuthorEmail()))) {
            stringBuilder.append("<br/>");
            stringBuilder.append(PyPackageManagementService.composeHref("mailto:" + authorEmail));
        }
        if (StringUtil.isNotEmpty((String)(homePage = info.getHomePage()))) {
            stringBuilder.append("<br/>");
            stringBuilder.append(PyPackageManagementService.composeHref(homePage));
        }
        stringBuilder.append(TEXT_SUFFIX);
        return stringBuilder.toString();
    }

    @NotNull
    private static String composeHref(String vendorUrl) {
        String string = HTML_PREFIX + vendorUrl + "\">" + vendorUrl + HTML_SUFFIX;
        if (string == null) {
            PyPackageManagementService.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static boolean isCancelled(@NotNull List<ExecutionException> exceptions) {
        if (exceptions == null) {
            PyPackageManagementService.$$$reportNull$$$0(18);
        }
        for (ExecutionException e : exceptions) {
            if (!(e instanceof RunCanceledByUserException)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static PackageManagementService.ErrorDescription createDescription(@NotNull ExecutionException e, @Nullable Sdk sdk) {
        if (e == null) {
            PyPackageManagementService.$$$reportNull$$$0(19);
        }
        if (e instanceof PyExecutionException) {
            PyExecutionException ee = (PyExecutionException)e;
            String stdoutCause = PyPackageManagementService.findErrorCause(ee.getStdout());
            String stderrCause = PyPackageManagementService.findErrorCause(ee.getStderr());
            String cause = stdoutCause != null ? stdoutCause : stderrCause;
            String message = cause != null ? cause : ee.getMessage();
            String command = ee.getCommand() + " " + StringUtil.join(ee.getArgs(), (String)" ");
            PackageManagementService.ErrorDescription errorDescription = new PackageManagementService.ErrorDescription(message, command, ee.getStdout() + "\n" + ee.getStderr(), PyPackageManagementService.findErrorSolution(ee, cause, sdk));
            if (errorDescription == null) {
                PyPackageManagementService.$$$reportNull$$$0(20);
            }
            return errorDescription;
        }
        PackageManagementService.ErrorDescription errorDescription = PackageManagementService.ErrorDescription.fromMessage(e.getMessage());
        if (errorDescription == null) {
            PyPackageManagementService.$$$reportNull$$$0(21);
        }
        return errorDescription;
    }

    @Nullable
    private static String findErrorSolution(@NotNull PyExecutionException e, @Nullable String cause, @Nullable Sdk sdk) {
        if (e == null) {
            PyPackageManagementService.$$$reportNull$$$0(22);
        }
        if (cause != null && StringUtil.containsIgnoreCase((String)cause, (String)"SyntaxError")) {
            LanguageLevel languageLevel = PythonSdkType.getLanguageLevelForSdk(sdk);
            return "Make sure that you use a version of Python supported by this package. Currently you are using Python " + (Object)((Object)languageLevel) + ".";
        }
        if (SystemInfo.isLinux && (PyPackageManagementService.containsInOutput(e, "pyconfig.h") || PyPackageManagementService.containsInOutput(e, "Python.h"))) {
            return "Make sure that you have installed Python development packages for your operating system.";
        }
        if ("pip".equals(e.getCommand()) && sdk != null) {
            return "Try to run this command from the system terminal. Make sure that you use the correct version of 'pip' installed for your Python interpreter located at '" + sdk.getHomePath() + "'.";
        }
        return null;
    }

    private static boolean containsInOutput(@NotNull PyExecutionException e, @NotNull String text) {
        if (e == null) {
            PyPackageManagementService.$$$reportNull$$$0(23);
        }
        if (text == null) {
            PyPackageManagementService.$$$reportNull$$$0(24);
        }
        return StringUtil.containsIgnoreCase((String)e.getStdout(), (String)text) || StringUtil.containsIgnoreCase((String)e.getStderr(), (String)text);
    }

    @Nullable
    private static String findErrorCause(@NotNull String output) {
        Matcher m;
        if (output == null) {
            PyPackageManagementService.$$$reportNull$$$0(25);
        }
        if ((m = PATTERN_ERROR_LINE.matcher(output)).find()) {
            String result2 = m.group();
            return result2 != null ? result2.trim() : null;
        }
        return null;
    }

    @Override
    public void updatePackage(@NotNull InstalledPackage installedPackage, @Nullable String version, @NotNull PackageManagementService.Listener listener2) {
        if (installedPackage == null) {
            PyPackageManagementService.$$$reportNull$$$0(26);
        }
        if (listener2 == null) {
            PyPackageManagementService.$$$reportNull$$$0(27);
        }
        this.installPackage(new RepoPackage(installedPackage.getName(), null), null, true, null, listener2, false);
    }

    @Override
    public boolean shouldFetchLatestVersionsForOnlyInstalledPackages() {
        return true;
    }

    @Override
    public void fetchLatestVersion(@NotNull InstalledPackage pkg, @NotNull CatchingConsumer<String, Exception> consumer) {
        if (pkg == null) {
            PyPackageManagementService.$$$reportNull$$$0(28);
        }
        if (consumer == null) {
            PyPackageManagementService.$$$reportNull$$$0(29);
        }
        this.myExecutorService.submit(() -> {
            if (pkg == null) {
                PyPackageManagementService.$$$reportNull$$$0(32);
            }
            if (consumer == null) {
                PyPackageManagementService.$$$reportNull$$$0(33);
            }
            try {
                PyPIPackageUtil.INSTANCE.loadAndGetPackages();
                String version = PyPIPackageUtil.INSTANCE.fetchLatestPackageVersion(pkg.getName());
                consumer.consume((Object)StringUtil.notNullize((String)version));
            }
            catch (IOException e) {
                consumer.consume((Throwable)e);
            }
        });
    }

    @Override
    public int compareVersions(@NotNull String version1, @NotNull String version2) {
        if (version1 == null) {
            PyPackageManagementService.$$$reportNull$$$0(30);
        }
        if (version2 == null) {
            PyPackageManagementService.$$$reportNull$$$0(31);
        }
        return PyPackageVersionComparator.getSTR_COMPARATOR().compare(version1, version2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/ui/PyPackageManagementService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repoPackage";
                break;
            }
            case 11: 
            case 13: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installedPackages";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 15: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 19: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installedPackage";
                break;
            }
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version1";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildHtmlStylePrefix";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/ui/PyPackageManagementService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdk";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPackages";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "reloadAllPackages";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPackagesCached";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedPyPIPackages";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallToUserText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledPackages";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "composeHref";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescription";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "installPackage";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "uninstallPackages";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fetchPackageDetails";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "formatPackageInfo";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isCancelled";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createDescription";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findErrorSolution";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "containsInOutput";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findErrorCause";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "updatePackage";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "fetchLatestVersion";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "compareVersions";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fetchLatestVersion$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

