/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.jetbrains.python.codeInsight.completion.PyClassInsertHandler;
import com.jetbrains.python.codeInsight.completion.PyFunctionInsertHandler;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.VariantsProcessor;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionVariantsProcessor
extends VariantsProcessor {
    @NotNull
    private final Map<String, LookupElement> myVariants = new HashMap<String, LookupElement>();
    private final boolean mySuppressParentheses;

    public CompletionVariantsProcessor(PsiElement context) {
        super(context);
        this.mySuppressParentheses = false;
    }

    public CompletionVariantsProcessor(PsiElement context, @Nullable Condition<PsiElement> nodeFilter, @Nullable Condition<String> nameFilter) {
        super(context, nodeFilter, nameFilter);
        this.mySuppressParentheses = false;
    }

    public CompletionVariantsProcessor(PsiElement context, @Nullable Condition<PsiElement> nodeFilter, @Nullable Condition<String> nameFilter, boolean plainNamesOnly, boolean suppressParentheses) {
        super(context, nodeFilter, nameFilter, plainNamesOnly);
        this.mySuppressParentheses = suppressParentheses;
    }

    @NotNull
    private LookupElement setupItem(@NotNull LookupElementBuilder item) {
        PsiElement parent;
        if (item == null) {
            CompletionVariantsProcessor.$$$reportNull$$$0(0);
        }
        PsiElement element = item.getPsiElement();
        if (!this.myPlainNamesOnly && element != null) {
            Project project = element.getProject();
            TypeEvalContext context = TypeEvalContext.codeCompletion(project, this.myContext != null ? this.myContext.getContainingFile() : null);
            if (!this.mySuppressParentheses && element instanceof PyFunction && ((PyFunction)element).getProperty() == null && !PyKnownDecoratorUtil.hasUnknownDecorator((PyFunction)element, context) && !CompletionVariantsProcessor.isSingleArgDecoratorCall(this.myContext, (PyFunction)element)) {
                item = item.withInsertHandler((InsertHandler)PyFunctionInsertHandler.INSTANCE);
                List parameters = ((PyFunction)element).getParameters(context);
                String params = StringUtil.join((Collection)parameters, PyCallableParameter::getName, (String)", ");
                item = item.withTailText("(" + params + ")");
            } else if (element instanceof PyClass) {
                item = item.withInsertHandler((InsertHandler)PyClassInsertHandler.INSTANCE);
            }
        }
        String source = null;
        if (element != null) {
            QualifiedName path;
            ScopeOwner owner;
            PyClass cls = null;
            if (element instanceof PyFunction) {
                cls = ((PyFunction)element).getContainingClass();
            } else if (element instanceof PyTargetExpression) {
                PyTargetExpression expr = (PyTargetExpression)element;
                if (expr.isQualified() || ScopeUtil.getScopeOwner(expr) instanceof PyClass) {
                    cls = expr.getContainingClass();
                }
            } else if (element instanceof PyClass && (owner = ScopeUtil.getScopeOwner(element)) instanceof PyClass) {
                cls = (PyClass)owner;
            }
            if (cls != null) {
                source = cls.getName();
            } else if (!(this.myContext != null && PyUtil.inSameFile(this.myContext, element) || (path = QualifiedNameFinder.findShortestImportableQName(PyPsiUtils.getFileSystemItem(element))) == null)) {
                source = ((QualifiedName)ObjectUtils.chooseNotNull((Object)QualifiedNameFinder.canonizeQualifiedName(path, null), (Object)path)).toString();
            }
        }
        if (source != null) {
            item = item.withTypeText(source);
        }
        PsiElement psiElement = parent = this.myContext != null ? this.myContext.getParent() : null;
        if (parent instanceof PyKeywordArgument) {
            String keyword = ((PyKeywordArgument)parent).getKeyword();
            if (item.getLookupString().equals(keyword)) {
                LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)item, (double)5.0);
                if (lookupElement == null) {
                    CompletionVariantsProcessor.$$$reportNull$$$0(1);
                }
                return lookupElement;
            }
        }
        LookupElementBuilder lookupElementBuilder = item;
        if (lookupElementBuilder == null) {
            CompletionVariantsProcessor.$$$reportNull$$$0(2);
        }
        return lookupElementBuilder;
    }

    private static boolean isSingleArgDecoratorCall(@Nullable PsiElement elementInCall, @NotNull PyFunction callee) {
        PyClass containingClass;
        if (callee == null) {
            CompletionVariantsProcessor.$$$reportNull$$$0(3);
        }
        if ((containingClass = callee.getContainingClass()) != null && "property".equals(containingClass.getName()) && PyBuiltinCache.getInstance(elementInCall).isBuiltin((PsiElement)containingClass)) {
            return true;
        }
        if (callee.getParameterList().getParameters().length > 1) {
            return false;
        }
        PyDecorator decorator = (PyDecorator)PsiTreeUtil.getParentOfType((PsiElement)elementInCall, PyDecorator.class);
        if (decorator == null) {
            return false;
        }
        return PsiTreeUtil.isAncestor((PsiElement)decorator.getCallee(), (PsiElement)elementInCall, (boolean)false);
    }

    @NotNull
    public LookupElement[] getResult() {
        Collection<LookupElement> variants = this.myVariants.values();
        LookupElement[] lookupElementArray = variants.toArray(new LookupElement[variants.size()]);
        if (lookupElementArray == null) {
            CompletionVariantsProcessor.$$$reportNull$$$0(4);
        }
        return lookupElementArray;
    }

    @NotNull
    public List<LookupElement> getResultList() {
        ArrayList<LookupElement> arrayList = new ArrayList<LookupElement>(this.myVariants.values());
        if (arrayList == null) {
            CompletionVariantsProcessor.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Override
    protected void addElement(@NotNull String name, @NotNull PsiElement element) {
        if (name == null) {
            CompletionVariantsProcessor.$$$reportNull$$$0(6);
        }
        if (element == null) {
            CompletionVariantsProcessor.$$$reportNull$$$0(7);
        }
        if (PyUtil.isClassPrivateName(name) && !PyUtil.inSameFile(element, this.myContext)) {
            return;
        }
        this.markAsProcessed(name);
        this.myVariants.put(name, this.setupItem(LookupElementBuilder.createWithSmartPointer((String)name, (PsiElement)element).withIcon(element.getIcon(0))));
    }

    @Override
    protected void addImportedElement(@NotNull String name, @NotNull PyElement element) {
        Icon icon;
        if (name == null) {
            CompletionVariantsProcessor.$$$reportNull$$$0(8);
        }
        if (element == null) {
            CompletionVariantsProcessor.$$$reportNull$$$0(9);
        }
        if ((icon = element.getIcon(0)) == null) {
            icon = PlatformIcons.VARIABLE_ICON;
        }
        this.markAsProcessed(name);
        this.myVariants.put(name, this.setupItem(LookupElementBuilder.createWithSmartPointer((String)name, (PsiElement)element).withIcon(icon)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/resolve/CompletionVariantsProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callee";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/resolve/CompletionVariantsProcessor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "setupItem";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getResult";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setupItem";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSingleArgDecoratorCall";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addElement";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addImportedElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

