/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyGlobalStatement;
import com.jetbrains.python.psi.PyImportedNameDefiner;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveProcessor;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyResolveUtil {
    private PyResolveUtil() {
    }

    public static void scopeCrawlUp(@NotNull PsiScopeProcessor processor2, @NotNull PsiElement element, @Nullable String name, @Nullable PsiElement roof) {
        ScopeOwner outerScopeOwner;
        PsiElement realContext;
        if (processor2 == null) {
            PyResolveUtil.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PyResolveUtil.$$$reportNull$$$0(1);
        }
        ScopeOwner originalOwner = (realContext = PyPsiUtils.getRealContext(element)) != element && realContext instanceof PyFile ? (PyFile)realContext : ScopeUtil.getScopeOwner(realContext);
        PsiElement parent = element.getParent();
        boolean isGlobalOrNonlocal = parent instanceof PyGlobalStatement || parent instanceof PyNonlocalStatement;
        ScopeOwner owner = originalOwner;
        if (isGlobalOrNonlocal && (outerScopeOwner = ScopeUtil.getScopeOwner((PsiElement)owner)) != null) {
            owner = outerScopeOwner;
        }
        PyResolveUtil.scopeCrawlUp(processor2, owner, originalOwner, name, roof);
    }

    public static void scopeCrawlUp(@NotNull PsiScopeProcessor processor2, @NotNull ScopeOwner scopeOwner, @Nullable String name, @Nullable PsiElement roof) {
        if (processor2 == null) {
            PyResolveUtil.$$$reportNull$$$0(2);
        }
        if (scopeOwner == null) {
            PyResolveUtil.$$$reportNull$$$0(3);
        }
        PyResolveUtil.scopeCrawlUp(processor2, scopeOwner, scopeOwner, name, roof);
    }

    public static void scopeCrawlUp(@NotNull PsiScopeProcessor processor2, @Nullable ScopeOwner scopeOwner, @Nullable ScopeOwner originalScopeOwner, @Nullable String name, @Nullable PsiElement roof) {
        if (processor2 == null) {
            PyResolveUtil.$$$reportNull$$$0(4);
        }
        while (scopeOwner != null) {
            if (!(scopeOwner instanceof PyClass) || scopeOwner == originalScopeOwner) {
                Scope scope = ControlFlowCache.getScope(scopeOwner);
                if (name != null) {
                    boolean includeNestedGlobals = scopeOwner instanceof PyFile;
                    for (PsiNamedElement resolved : scope.getNamedElements(name, includeNestedGlobals)) {
                        if (processor2.execute((PsiElement)resolved, ResolveState.initial())) continue;
                        return;
                    }
                } else {
                    for (PsiNamedElement element : scope.getNamedElements()) {
                        if (processor2.execute((PsiElement)element, ResolveState.initial())) continue;
                        return;
                    }
                }
                for (PyImportedNameDefiner definer : scope.getImportedNameDefiners()) {
                    if (processor2.execute((PsiElement)definer, ResolveState.initial())) continue;
                    return;
                }
            }
            if (scopeOwner == roof) {
                return;
            }
            scopeOwner = ScopeUtil.getScopeOwner((PsiElement)scopeOwner);
        }
    }

    @NotNull
    public static Collection<PsiElement> resolveLocally(@NotNull PyReferenceExpression referenceExpression) {
        String referenceName;
        if (referenceExpression == null) {
            PyResolveUtil.$$$reportNull$$$0(5);
        }
        if ((referenceName = referenceExpression.getName()) == null || referenceExpression.isQualified()) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                PyResolveUtil.$$$reportNull$$$0(6);
            }
            return list2;
        }
        PyResolveProcessor processor2 = new PyResolveProcessor(referenceName, true);
        PyResolveUtil.scopeCrawlUp((PsiScopeProcessor)processor2, (PsiElement)referenceExpression, referenceName, null);
        Collection<PsiElement> collection = processor2.getElements();
        if (collection == null) {
            PyResolveUtil.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiElement> resolveLocally(@NotNull ScopeOwner scopeOwner, @NotNull String name) {
        if (scopeOwner == null) {
            PyResolveUtil.$$$reportNull$$$0(8);
        }
        if (name == null) {
            PyResolveUtil.$$$reportNull$$$0(9);
        }
        PyResolveProcessor processor2 = new PyResolveProcessor(name, true);
        PyResolveUtil.scopeCrawlUp((PsiScopeProcessor)processor2, scopeOwner, name, null);
        Collection<PsiElement> collection = processor2.getElements();
        if (collection == null) {
            PyResolveUtil.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @NotNull
    public static List<PsiElement> resolveQualifiedNameInFile(@NotNull QualifiedName qualifiedName, @NotNull PyFile file2, @NotNull TypeEvalContext context) {
        StreamEx initialResults;
        String firstName;
        if (qualifiedName == null) {
            PyResolveUtil.$$$reportNull$$$0(11);
        }
        if (file2 == null) {
            PyResolveUtil.$$$reportNull$$$0(12);
        }
        if (context == null) {
            PyResolveUtil.$$$reportNull$$$0(13);
        }
        if ((firstName = qualifiedName.getFirstComponent()) == null) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                PyResolveUtil.$$$reportNull$$$0(14);
            }
            return list2;
        }
        List<RatedResolveResult> unqualifiedResults = file2.multiResolveName(firstName, false);
        if (unqualifiedResults.isEmpty()) {
            PsiElement builtin = PyBuiltinCache.getInstance((PsiElement)file2).getByName(firstName);
            if (builtin == null) {
                List<PsiElement> list3 = Collections.emptyList();
                if (list3 == null) {
                    PyResolveUtil.$$$reportNull$$$0(15);
                }
                return list3;
            }
            initialResults = StreamEx.of((Object)new RatedResolveResult(0, builtin));
        } else {
            initialResults = StreamEx.of(unqualifiedResults);
        }
        List remainingNames = qualifiedName.removeHead(1).getComponents();
        StreamEx result2 = (StreamEx)StreamEx.of((Collection)remainingNames).foldLeft((Object)initialResults, (prev, name) -> {
            if (context == null) {
                PyResolveUtil.$$$reportNull$$$0(17);
            }
            return prev.map(RatedResolveResult::getElement).select(PyTypedElement.class).map(context::getType).nonNull().flatMap(type -> {
                if (context == null) {
                    PyResolveUtil.$$$reportNull$$$0(18);
                }
                PyType instanceType = type instanceof PyClassLikeType ? ((PyClassLikeType)type).toInstance() : type;
                PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(context);
                List<? extends RatedResolveResult> results = instanceType.resolveMember((String)name, null, AccessDirection.READ, resolveContext);
                return results != null ? StreamEx.of(results) : StreamEx.empty();
            });
        });
        List<PsiElement> list4 = PyUtil.filterTopPriorityResults((ResolveResult[])result2.toArray(RatedResolveResult[]::new));
        if (list4 == null) {
            PyResolveUtil.$$$reportNull$$$0(16);
        }
        return list4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeOwner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/resolve/PyResolveUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/resolve/PyResolveUtil";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocally";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveQualifiedNameInFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "scopeCrawlUp";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocally";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveQualifiedNameInFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveQualifiedNameInFile$1";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

