/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring;

import com.google.common.collect.Sets;
import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.Function;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyImplicitImportNameDefiner;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyAugAssignmentStatementNavigator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDefUseUtil {
    private PyDefUseUtil() {
    }

    @NotNull
    public static List<Instruction> getLatestDefs(ScopeOwner block, String varName, PsiElement anchor, boolean acceptTypeAssertions, boolean acceptImplicitImports) {
        Collection pred;
        int instr;
        ControlFlow controlFlow = ControlFlowCache.getControlFlow(block);
        Instruction[] instructions = controlFlow.getInstructions();
        PyAugAssignmentStatement augAssignment = PyAugAssignmentStatementNavigator.getStatementByTarget(anchor);
        if (augAssignment != null) {
            anchor = augAssignment;
        }
        if ((instr = ControlFlowUtil.findInstructionNumberByElement(instructions, anchor)) < 0) {
            List<Instruction> list2 = Collections.emptyList();
            if (list2 == null) {
                PyDefUseUtil.$$$reportNull$$$0(0);
            }
            return list2;
        }
        if (anchor instanceof PyTargetExpression && !(pred = instructions[instr].allPred()).isEmpty()) {
            instr = ((Instruction)pred.iterator().next()).num();
        }
        Collection<Instruction> result2 = PyDefUseUtil.getLatestDefs(varName, instructions, instr, acceptTypeAssertions, acceptImplicitImports);
        ArrayList<Instruction> arrayList = new ArrayList<Instruction>(result2);
        if (arrayList == null) {
            PyDefUseUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static Collection<Instruction> getLatestDefs(String varName, Instruction[] instructions, int instr, boolean acceptTypeAssertions, boolean acceptImplicitImports) {
        LinkedHashSet<Instruction> result2 = new LinkedHashSet<Instruction>();
        ControlFlowUtil.iteratePrev(instr, instructions, (Function<Instruction, ControlFlowUtil.Operation>)((Function)instruction -> {
            PsiElement element = instruction.getElement();
            PyImplicitImportNameDefiner implicit = PyUtil.as(element, PyImplicitImportNameDefiner.class);
            if (instruction instanceof ReadWriteInstruction) {
                String name;
                ReadWriteInstruction rwInstruction = (ReadWriteInstruction)instruction;
                ReadWriteInstruction.ACCESS access = rwInstruction.getAccess();
                if ((access.isWriteAccess() || acceptTypeAssertions && access.isAssertTypeAccess()) && Comparing.strEqual((String)(name = PyDefUseUtil.elementName(element)), (String)varName)) {
                    result2.add(rwInstruction);
                    return ControlFlowUtil.Operation.CONTINUE;
                }
            } else if (acceptImplicitImports && implicit != null && !implicit.multiResolveName(varName).isEmpty()) {
                result2.add((Instruction)instruction);
                return ControlFlowUtil.Operation.CONTINUE;
            }
            return ControlFlowUtil.Operation.NEXT;
        }));
        return result2;
    }

    @Nullable
    private static String elementName(PsiElement element) {
        QualifiedName qname;
        if (element instanceof PyImportElement) {
            return ((PyImportElement)element).getVisibleName();
        }
        if ((element instanceof PyReferenceExpression || element instanceof PyTargetExpression) && (qname = ((PyQualifiedExpression)element).asQualifiedName()) != null) {
            return qname.toString();
        }
        return element instanceof PyElement ? ((PyElement)element).getName() : null;
    }

    @NotNull
    public static PsiElement[] getPostRefs(ScopeOwner block, PyTargetExpression var, PyExpression anchor) {
        ControlFlow controlFlow = ControlFlowCache.getControlFlow(block);
        Instruction[] instructions = controlFlow.getInstructions();
        int instr = ControlFlowUtil.findInstructionNumberByElement(instructions, (PsiElement)anchor);
        if (instr < 0) {
            if (PyElement.EMPTY_ARRAY == null) {
                PyDefUseUtil.$$$reportNull$$$0(2);
            }
            return PyElement.EMPTY_ARRAY;
        }
        boolean[] visited = new boolean[instructions.length];
        HashSet result2 = Sets.newHashSet();
        for (Instruction instruction : instructions[instr].allSucc()) {
            PyDefUseUtil.getPostRefs(var, instructions, instruction.num(), visited, result2);
        }
        PsiElement[] psiElementArray = (PsiElement[])result2.toArray(new PyElement[result2.size()]);
        if (psiElementArray == null) {
            PyDefUseUtil.$$$reportNull$$$0(3);
        }
        return psiElementArray;
    }

    private static void getPostRefs(PyTargetExpression var, Instruction[] instructions, int instr, boolean[] visited, Collection<PyElement> result2) {
        ReadWriteInstruction instruction;
        PsiElement element;
        String name;
        if (visited[instr]) {
            return;
        }
        visited[instr] = true;
        if (instructions[instr] instanceof ReadWriteInstruction && Comparing.strEqual((String)(name = PyDefUseUtil.elementName(element = (instruction = (ReadWriteInstruction)instructions[instr]).getElement())), (String)var.getName())) {
            ReadWriteInstruction.ACCESS access = instruction.getAccess();
            if (access.isWriteAccess()) {
                return;
            }
            result2.add((PyElement)instruction.getElement());
        }
        for (Instruction instruction2 : instructions[instr].allSucc()) {
            PyDefUseUtil.getPostRefs(var, instructions, instruction2.num(), visited, result2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/python/refactoring/PyDefUseUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLatestDefs";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPostRefs";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class InstructionNotFoundException
    extends RuntimeException {
    }
}

