/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.containers.HashSet;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.UnixPythonSdkFlavor;
import java.util.Collection;
import java.util.Set;

public class MacPythonSdkFlavor
extends CPythonSdkFlavor {
    public static MacPythonSdkFlavor INSTANCE = new MacPythonSdkFlavor();
    private static final String[] POSSIBLE_BINARY_NAMES = new String[]{"python", "python2", "python3"};

    private MacPythonSdkFlavor() {
    }

    @Override
    public Collection<String> suggestHomePaths() {
        HashSet candidates = new HashSet();
        MacPythonSdkFlavor.collectPythonInstallations("/Library/Frameworks/Python.framework/Versions", (Set<String>)candidates);
        MacPythonSdkFlavor.collectPythonInstallations("/System/Library/Frameworks/Python.framework/Versions", (Set<String>)candidates);
        UnixPythonSdkFlavor.collectUnixPythons("/usr/local/bin", (Set<String>)candidates);
        UnixPythonSdkFlavor.collectUnixPythons("/usr/bin", (Set<String>)candidates);
        return candidates;
    }

    private static void collectPythonInstallations(String pythonPath, Set<String> candidates) {
        VirtualFile rootVDir = LocalFileSystem.getInstance().findFileByPath(pythonPath);
        if (rootVDir != null) {
            if (rootVDir instanceof NewVirtualFile) {
                ((NewVirtualFile)rootVDir).markDirty();
            }
            rootVDir.refresh(true, false);
            block0: for (VirtualFile dir : rootVDir.getChildren()) {
                VirtualFile binDir;
                String dirName = dir.getName().toLowerCase();
                if (!dir.isDirectory() || !"Current".equals(dirName) && !dirName.startsWith("2") && !dirName.startsWith("3") || (binDir = dir.findChild("bin")) == null || !binDir.isDirectory()) continue;
                for (String name : POSSIBLE_BINARY_NAMES) {
                    String path;
                    VirtualFile child = binDir.findChild(name);
                    if (child == null || candidates.contains(path = child.getPath())) continue;
                    candidates.add(path);
                    continue block0;
                }
            }
        }
    }
}

