/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SvnScopeZipper
implements Runnable {
    @NotNull
    private final VcsDirtyScope myIn;
    @NotNull
    private final List<FilePath> myRecursiveDirs;
    @NotNull
    private final Map<String, MyDirNonRecursive> myNonRecursiveDirs;

    public SvnScopeZipper(@NotNull VcsDirtyScope in) {
        if (in == null) {
            SvnScopeZipper.$$$reportNull$$$0(0);
        }
        this.myIn = in;
        this.myRecursiveDirs = ContainerUtil.newArrayList((Iterable)in.getRecursivelyDirtyDirectories());
        this.myNonRecursiveDirs = ContainerUtil.newHashMap();
    }

    @Override
    public void run() {
        Set files = this.myIn.getDirtyFilesNoExpand();
        for (FilePath file : files) {
            if (file.isDirectory()) {
                VirtualFile vFile = file.getVirtualFile();
                MyDirNonRecursive me = this.createOrGet(file);
                if (vFile == null || !vFile.isValid()) continue;
                for (VirtualFile child : vFile.getChildren()) {
                    me.add(VcsUtil.getFilePath((VirtualFile)child));
                }
                continue;
            }
            FilePath parent = file.getParentPath();
            if (parent == null) continue;
            MyDirNonRecursive item = this.createOrGet(parent);
            item.add(file);
        }
    }

    @NotNull
    private MyDirNonRecursive createOrGet(@NotNull FilePath parent) {
        String key;
        MyDirNonRecursive result;
        if (parent == null) {
            SvnScopeZipper.$$$reportNull$$$0(1);
        }
        if ((result = this.myNonRecursiveDirs.get(key = SvnScopeZipper.getKey(parent))) == null) {
            result = new MyDirNonRecursive(parent);
            this.myNonRecursiveDirs.put(key, result);
        }
        MyDirNonRecursive myDirNonRecursive = result;
        if (myDirNonRecursive == null) {
            SvnScopeZipper.$$$reportNull$$$0(2);
        }
        return myDirNonRecursive;
    }

    @NotNull
    public List<FilePath> getRecursiveDirs() {
        List<FilePath> list = this.myRecursiveDirs;
        if (list == null) {
            SvnScopeZipper.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public Map<String, MyDirNonRecursive> getNonRecursiveDirs() {
        Map<String, MyDirNonRecursive> map = this.myNonRecursiveDirs;
        if (map == null) {
            SvnScopeZipper.$$$reportNull$$$0(4);
        }
        return map;
    }

    public static String getKey(@NotNull FilePath path) {
        if (path == null) {
            SvnScopeZipper.$$$reportNull$$$0(5);
        }
        return path.getPresentableUrl();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/SvnScopeZipper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/SvnScopeZipper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createOrGet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecursiveDirs";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonRecursiveDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createOrGet";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MyDirNonRecursive {
        @NotNull
        private final FilePath myDir;
        @NotNull
        private final Map<String, FilePath> myChildren;

        private MyDirNonRecursive(@NotNull FilePath dir) {
            if (dir == null) {
                MyDirNonRecursive.$$$reportNull$$$0(0);
            }
            this.myDir = dir;
            this.myChildren = ContainerUtil.newHashMap();
        }

        public void add(@NotNull FilePath path) {
            if (path == null) {
                MyDirNonRecursive.$$$reportNull$$$0(1);
            }
            this.myChildren.put(SvnScopeZipper.getKey(path), path);
        }

        @NotNull
        public Collection<FilePath> getChildrenList() {
            Collection<FilePath> collection = this.myChildren.values();
            if (collection == null) {
                MyDirNonRecursive.$$$reportNull$$$0(2);
            }
            return collection;
        }

        @NotNull
        public FilePath getDir() {
            FilePath filePath = this.myDir;
            if (filePath == null) {
                MyDirNonRecursive.$$$reportNull$$$0(3);
            }
            return filePath;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/svn/SvnScopeZipper$MyDirNonRecursive";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/svn/SvnScopeZipper$MyDirNonRecursive";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildrenList";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDir";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

