/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.execution;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.intellij.vcsUtil.VcsImplUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgGlobalSettings;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgCommandResultHandler;
import org.zmlx.hg4idea.execution.HgLineProcessListener;
import org.zmlx.hg4idea.execution.ShellCommand;
import org.zmlx.hg4idea.execution.ShellCommandException;
import org.zmlx.hg4idea.util.HgEncodingUtil;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgCommandExecutor {
    protected static final Logger LOG = Logger.getInstance((String)HgCommandExecutor.class.getName());
    private static final List<String> DEFAULT_OPTIONS = Arrays.asList("--config", "extensions.mq=", "--config", "ui.merge=internal:merge");
    protected final Project myProject;
    protected final HgVcs myVcs;
    protected final String myDestination;
    @NotNull
    private Charset myCharset;
    private boolean myIsSilent = false;
    private boolean myShowOutput = false;
    private boolean myIsBinary = false;
    private boolean myOutputAlwaysSuppressed = false;

    public HgCommandExecutor(Project project) {
        this(project, null);
    }

    public HgCommandExecutor(Project project, @Nullable String destination) {
        this.myProject = project;
        this.myVcs = HgVcs.getInstance(project);
        this.myDestination = destination;
        this.myCharset = HgEncodingUtil.getDefaultCharset(this.myProject);
    }

    public void setCharset(@Nullable Charset charset) {
        if (charset != null) {
            this.myCharset = charset;
        }
    }

    public void setSilent(boolean isSilent) {
        this.myIsSilent = isSilent;
    }

    public void setShowOutput(boolean showOutput) {
        this.myShowOutput = showOutput;
    }

    public void setBinary(boolean isBinary) {
        this.myIsBinary = isBinary;
    }

    public void setOutputAlwaysSuppressed(boolean outputAlwaysSuppressed) {
        this.myOutputAlwaysSuppressed = outputAlwaysSuppressed;
    }

    public void execute(@Nullable VirtualFile repo, @NotNull String operation, @Nullable List<String> arguments, @Nullable HgCommandResultHandler handler) {
        if (operation == null) {
            HgCommandExecutor.$$$reportNull$$$0(0);
        }
        BackgroundTaskUtil.executeOnPooledThread((Disposable)this.myProject, () -> {
            if (operation == null) {
                HgCommandExecutor.$$$reportNull$$$0(12);
            }
            HgCommandResult result = this.executeInCurrentThread(repo, operation, arguments);
            if (handler != null) {
                handler.process(result);
            }
        });
    }

    @Nullable
    public HgCommandResult executeInCurrentThread(@Nullable VirtualFile repo, @NotNull String operation, @Nullable List<String> arguments) {
        if (operation == null) {
            HgCommandExecutor.$$$reportNull$$$0(1);
        }
        return this.executeInCurrentThread(repo, operation, arguments, false);
    }

    @Nullable
    public HgCommandResult executeInCurrentThread(@Nullable VirtualFile repo, @NotNull String operation, @Nullable List<String> arguments, boolean ignoreDefaultOptions) {
        ShellCommand.CommandResultCollector collector;
        boolean success;
        if (operation == null) {
            HgCommandExecutor.$$$reportNull$$$0(2);
        }
        return (success = this.executeInCurrentThread(repo, operation, arguments, ignoreDefaultOptions, collector = new ShellCommand.CommandResultCollector(this.myIsBinary))) ? collector.getResult() : null;
    }

    public boolean executeInCurrentThread(@Nullable VirtualFile repo, @NotNull String operation, @Nullable List<String> arguments, boolean ignoreDefaultOptions, @NotNull HgLineProcessListener listener) {
        if (operation == null) {
            HgCommandExecutor.$$$reportNull$$$0(3);
        }
        if (listener == null) {
            HgCommandExecutor.$$$reportNull$$$0(4);
        }
        boolean success = this.executeInCurrentThreadAndLog(repo, operation, arguments, ignoreDefaultOptions, listener);
        List errors = StringUtil.split((String)listener.getErrorOutput().toString(), (String)SystemProperties.getLineSeparator());
        if (success && HgErrorUtil.isUnknownEncodingError(errors)) {
            this.setCharset(Charset.forName("utf8"));
            return this.executeInCurrentThreadAndLog(repo, operation, arguments, ignoreDefaultOptions, listener);
        }
        return success;
    }

    private boolean executeInCurrentThreadAndLog(@Nullable VirtualFile repo, @NotNull String operation, @Nullable List<String> arguments, boolean ignoreDefaultOptions, @NotNull HgLineProcessListener listener) {
        if (operation == null) {
            HgCommandExecutor.$$$reportNull$$$0(5);
        }
        if (listener == null) {
            HgCommandExecutor.$$$reportNull$$$0(6);
        }
        if (this.myProject == null || this.myProject.isDisposed() || this.myVcs == null) {
            return false;
        }
        ShellCommand shellCommand = this.createShellCommandWithArgs(repo, operation, arguments, ignoreDefaultOptions);
        try {
            long startTime = System.currentTimeMillis();
            LOG.debug(String.format("hg %s started", operation));
            shellCommand.execute(this.myShowOutput, this.myIsBinary, listener);
            LOG.debug(String.format("hg %s finished. Took %s ms", operation, System.currentTimeMillis() - startTime));
            return true;
        }
        catch (ShellCommandException e) {
            this.processError(e);
            return false;
        }
    }

    private void processError(@NotNull ShellCommandException e) {
        if (e == null) {
            HgCommandExecutor.$$$reportNull$$$0(7);
        }
        if (this.myVcs.getExecutableValidator().checkExecutableAndNotifyIfNeeded()) {
            this.showError(e);
            LOG.info(e.getMessage(), (Throwable)e);
        }
    }

    @NotNull
    private ShellCommand createShellCommandWithArgs(@Nullable VirtualFile repo, @NotNull String operation, @Nullable List<String> arguments, boolean ignoreDefaultOptions) {
        if (operation == null) {
            HgCommandExecutor.$$$reportNull$$$0(8);
        }
        this.logCommand(operation, arguments);
        LinkedList<String> cmdLine = new LinkedList<String>();
        cmdLine.add(this.myVcs.getGlobalSettings().getHgExecutable());
        if (repo != null) {
            cmdLine.add("--repository");
            cmdLine.add(repo.getPath());
        }
        if (!ignoreDefaultOptions) {
            cmdLine.addAll(DEFAULT_OPTIONS);
        }
        cmdLine.add(operation);
        if (arguments != null && arguments.size() != 0) {
            cmdLine.addAll(arguments);
        }
        if (HgVcs.HGENCODING == null) {
            cmdLine.add("--encoding");
            cmdLine.add(HgEncodingUtil.getNameFor(this.myCharset));
        }
        String workingDir = repo != null ? repo.getPath() : null;
        ShellCommand shellCommand = new ShellCommand(cmdLine, workingDir, this.myCharset);
        if (shellCommand == null) {
            HgCommandExecutor.$$$reportNull$$$0(9);
        }
        return shellCommand;
    }

    protected void logCommand(@NotNull String operation, @Nullable List<String> arguments) {
        String cmdString;
        if (operation == null) {
            HgCommandExecutor.$$$reportNull$$$0(10);
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        HgGlobalSettings settings = this.myVcs.getGlobalSettings();
        int lastSlashIndex = settings.getHgExecutable().lastIndexOf(File.separator);
        String exeName = settings.getHgExecutable().substring(lastSlashIndex + 1);
        String str = String.format("%s %s %s", exeName, operation, arguments == null ? "" : StringUtil.escapeStringCharacters((String)StringUtil.join(arguments, (String)" ")));
        String string = cmdString = this.myDestination != null ? HgUtil.removePasswordIfNeeded(str) : str;
        if (!this.myIsSilent) {
            LOG.info(cmdString);
            this.myVcs.showMessageInConsole(cmdString, ConsoleViewContentType.NORMAL_OUTPUT);
        } else {
            LOG.debug(cmdString);
        }
    }

    private void logResult(@NotNull HgCommandResult result) {
        if (result == null) {
            HgCommandExecutor.$$$reportNull$$$0(11);
        }
        if (!result.getRawOutput().isEmpty() && !this.myOutputAlwaysSuppressed) {
            if (!this.myIsSilent && this.myShowOutput) {
                LOG.info(result.getRawOutput());
                this.myVcs.showMessageInConsole(result.getRawOutput(), ConsoleViewContentType.SYSTEM_OUTPUT);
            } else {
                LOG.debug(result.getRawOutput());
            }
        }
        if (!result.getRawError().isEmpty()) {
            if (!this.myIsSilent) {
                LOG.info(result.getRawError());
                this.myVcs.showMessageInConsole(result.getRawError(), ConsoleViewContentType.ERROR_OUTPUT);
            } else {
                LOG.debug(result.getRawError());
            }
        }
    }

    protected void showError(Exception e) {
        HgVcs vcs = HgVcs.getInstance(this.myProject);
        if (vcs == null) {
            return;
        }
        String message = HgVcsMessages.message("hg4idea.command.executable.error", vcs.getGlobalSettings().getHgExecutable()) + "\nOriginal Error:\n" + e.getMessage();
        VcsImplUtil.showErrorMessage((Project)this.myProject, (String)message, (String)HgVcsMessages.message("hg4idea.error", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/execution/HgCommandExecutor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/execution/HgCommandExecutor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createShellCommandWithArgs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "executeInCurrentThread";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "executeInCurrentThreadAndLog";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processError";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createShellCommandWithArgs";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "logCommand";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "logResult";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$execute$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

