/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev.transport;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.jetbrains.python.debugger.pydev.RemoteDebugger;
import com.jetbrains.python.debugger.pydev.transport.BaseDebuggerReader;
import com.jetbrains.python.debugger.pydev.transport.BaseDebuggerTransport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.jetbrains.annotations.NotNull;

public class ServerModeDebuggerTransport
extends BaseDebuggerTransport {
    private static final Logger LOG = Logger.getInstance(ServerModeDebuggerTransport.class);
    @NotNull
    private final ServerSocket myServerSocket;
    private volatile DebuggerReader myDebuggerReader;
    private volatile boolean myConnected;
    private volatile Socket mySocket;
    private int myConnectionTimeout;

    public ServerModeDebuggerTransport(RemoteDebugger debugger, @NotNull ServerSocket socket, int connectionTimeout) {
        if (socket == null) {
            ServerModeDebuggerTransport.$$$reportNull$$$0(0);
        }
        super(debugger);
        this.myConnected = false;
        this.myServerSocket = socket;
        this.myConnectionTimeout = connectionTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForConnect() throws IOException {
        this.myServerSocket.setSoTimeout(this.myConnectionTimeout);
        Object object = this.mySocketObject;
        synchronized (object) {
            this.mySocket = this.myServerSocket.accept();
            this.myConnected = true;
        }
        try {
            object = this.mySocketObject;
            synchronized (object) {
                this.myDebuggerReader = new DebuggerReader(this.myDebugger, this.mySocket.getInputStream());
            }
        }
        catch (IOException e) {
            try {
                this.mySocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public void close() {
        try {
            if (this.myDebuggerReader != null) {
                this.myDebuggerReader.stop();
            }
        }
        finally {
            if (!this.myServerSocket.isClosed()) {
                try {
                    this.myServerSocket.close();
                }
                catch (IOException e) {
                    LOG.warn("Error closing socket", (Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean isConnected() {
        return this.myConnected && this.mySocket != null && !this.mySocket.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        Object object = this.mySocketObject;
        synchronized (object) {
            this.myConnected = false;
            if (this.mySocket != null && !this.mySocket.isClosed()) {
                try {
                    this.mySocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean sendMessageImpl(byte[] packed) throws IOException {
        Object object = this.mySocketObject;
        synchronized (object) {
            if (this.mySocket == null) {
                return false;
            }
            OutputStream os = this.mySocket.getOutputStream();
            os.write(packed);
            os.flush();
            return true;
        }
    }

    @Override
    protected void onSocketException() {
        this.myDebugger.disconnect();
        this.myDebugger.fireCommunicationError();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "socket", "com/jetbrains/python/debugger/pydev/transport/ServerModeDebuggerTransport", "<init>"));
    }

    public static class DebuggerReader
    extends BaseDebuggerReader {
        public DebuggerReader(@NotNull RemoteDebugger debugger, @NotNull InputStream stream) throws IOException {
            if (debugger == null) {
                DebuggerReader.$$$reportNull$$$0(0);
            }
            if (stream == null) {
                DebuggerReader.$$$reportNull$$$0(1);
            }
            super(stream, CharsetToolkit.UTF8_CHARSET, debugger);
            this.start(((Object)((Object)this)).getClass().getName());
        }

        @Override
        protected void onExit() {
            this.getDebugger().fireExitEvent();
        }

        @Override
        protected void onCommunicationError() {
            this.getDebugger().fireCommunicationError();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "debugger";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "stream";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/debugger/pydev/transport/ServerModeDebuggerTransport$DebuggerReader";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

